/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DisposableIterator;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.PersistentRangeHighlighterImpl;
import com.intellij.openapi.editor.impl.RangeHighlighterImpl;
import com.intellij.openapi.editor.impl.RangeHighlighterTree;
import com.intellij.openapi.editor.impl.TextRangeInterval;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkupModelImpl
extends UserDataHolderBase
implements MarkupModelEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.impl.MarkupModelImpl");
    private final DocumentEx myDocument;
    private RangeHighlighter[] myCachedHighlighters;
    private final List<MarkupModelListener> myListeners;
    private final RangeHighlighterTree myHighlighterTree;
    private final RangeHighlighterTree myHighlighterTreeForLines;

    MarkupModelImpl(@NotNull DocumentEx document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/MarkupModelImpl", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDocument = document;
        this.myHighlighterTree = new RangeHighlighterTree(document, this);
        this.myHighlighterTreeForLines = new RangeHighlighterTree(document, this);
    }

    @Override
    public void dispose() {
        this.myHighlighterTree.dispose();
        this.myHighlighterTreeForLines.dispose();
    }

    @Override
    @NotNull
    public RangeHighlighter addLineHighlighter(int lineNumber, int layer, TextAttributes textAttributes) {
        if (this.isNotValidLine(lineNumber)) {
            throw new IndexOutOfBoundsException("lineNumber:" + lineNumber + ". Must be in [0, " + (this.getDocument().getLineCount() - 1) + "]");
        }
        int offset = DocumentUtil.getFirstNonSpaceCharOffset(this.getDocument(), lineNumber);
        RangeHighlighter rangeHighlighter = this.addRangeHighlighter(offset, offset, layer, textAttributes, HighlighterTargetArea.LINES_IN_RANGE);
        if (rangeHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addLineHighlighter"));
        }
        return rangeHighlighter;
    }

    @Override
    @Nullable
    public RangeHighlighterEx addPersistentLineHighlighter(int lineNumber, int layer, TextAttributes textAttributes) {
        if (this.isNotValidLine(lineNumber)) {
            return null;
        }
        int offset = DocumentUtil.getFirstNonSpaceCharOffset(this.getDocument(), lineNumber);
        return this.addRangeHighlighter(PersistentRangeHighlighterImpl.create(this, offset, layer, HighlighterTargetArea.LINES_IN_RANGE, textAttributes, false), null);
    }

    private boolean isNotValidLine(int lineNumber) {
        return lineNumber >= this.getDocument().getLineCount() || lineNumber < 0;
    }

    @Override
    @NotNull
    public RangeHighlighter[] getAllHighlighters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myCachedHighlighters == null) {
            int size = this.myHighlighterTree.size() + this.myHighlighterTreeForLines.size();
            if (size == 0) {
                if (RangeHighlighter.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/MarkupModelImpl", "getAllHighlighters"));
                }
                return RangeHighlighter.EMPTY_ARRAY;
            }
            ArrayList list = new ArrayList(size);
            CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor(list);
            this.myHighlighterTree.process((Processor)collectProcessor);
            this.myHighlighterTreeForLines.process((Processor)collectProcessor);
            this.myCachedHighlighters = list.toArray(new RangeHighlighter[list.size()]);
        }
        if (this.myCachedHighlighters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/MarkupModelImpl", "getAllHighlighters"));
        }
        return this.myCachedHighlighters;
    }

    @Override
    @NotNull
    public RangeHighlighterEx addRangeHighlighterAndChangeAttributes(int startOffset, int endOffset, int layer, TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea, boolean isPersistent, @Nullable Consumer<RangeHighlighterEx> changeAttributesAction) {
        if (targetArea == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetArea", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addRangeHighlighterAndChangeAttributes"));
        }
        RangeHighlighterEx rangeHighlighterEx = this.addRangeHighlighter(isPersistent ? PersistentRangeHighlighterImpl.create(this, startOffset, layer, targetArea, textAttributes, true) : new RangeHighlighterImpl(this, startOffset, endOffset, layer, targetArea, textAttributes, false, false), changeAttributesAction);
        if (rangeHighlighterEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addRangeHighlighterAndChangeAttributes"));
        }
        return rangeHighlighterEx;
    }

    @NotNull
    private RangeHighlighterEx addRangeHighlighter(@NotNull RangeHighlighterImpl highlighter, @Nullable Consumer<RangeHighlighterEx> changeAttributesAction) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addRangeHighlighter"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myCachedHighlighters = null;
        if (changeAttributesAction != null) {
            highlighter.changeAttributesNoEvents(changeAttributesAction);
        }
        this.fireAfterAdded(highlighter);
        RangeHighlighterImpl rangeHighlighterImpl = highlighter;
        if (rangeHighlighterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addRangeHighlighter"));
        }
        return rangeHighlighterImpl;
    }

    @Override
    public void changeAttributesInBatch(@NotNull RangeHighlighterEx highlighter, @NotNull Consumer<RangeHighlighterEx> changeAttributesAction) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/MarkupModelImpl", "changeAttributesInBatch"));
        }
        if (changeAttributesAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeAttributesAction", "com/intellij/openapi/editor/impl/MarkupModelImpl", "changeAttributesInBatch"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeHighlighterImpl.ChangeResult changed = ((RangeHighlighterImpl)highlighter).changeAttributesNoEvents(changeAttributesAction);
        if (changed != RangeHighlighterImpl.ChangeResult.NOT_CHANGED) {
            this.fireAttributesChanged(highlighter, changed == RangeHighlighterImpl.ChangeResult.RENDERERS_CHANGED);
        }
    }

    @Override
    public void addRangeHighlighter(@NotNull RangeHighlighterEx marker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addRangeHighlighter"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.treeFor(marker).addInterval(marker, start, end, greedyToLeft, greedyToRight, layer);
    }

    private RangeHighlighterTree treeFor(RangeHighlighter marker) {
        return marker.getTargetArea() == HighlighterTargetArea.EXACT_RANGE ? this.myHighlighterTree : this.myHighlighterTreeForLines;
    }

    @Override
    @NotNull
    public RangeHighlighter addRangeHighlighter(int startOffset, int endOffset, int layer, TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea) {
        if (targetArea == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetArea", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addRangeHighlighter"));
        }
        RangeHighlighterEx rangeHighlighterEx = this.addRangeHighlighterAndChangeAttributes(startOffset, endOffset, layer, textAttributes, targetArea, false, null);
        if (rangeHighlighterEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addRangeHighlighter"));
        }
        return rangeHighlighterEx;
    }

    @Override
    public void removeHighlighter(@NotNull RangeHighlighter segmentHighlighter) {
        if (segmentHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segmentHighlighter", "com/intellij/openapi/editor/impl/MarkupModelImpl", "removeHighlighter"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myCachedHighlighters = null;
        if (!segmentHighlighter.isValid()) {
            return;
        }
        boolean removed = this.treeFor(segmentHighlighter).removeInterval((RangeHighlighterEx)segmentHighlighter);
        LOG.assertTrue(removed);
    }

    @Override
    public void removeAllHighlighters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (RangeHighlighter highlighter : this.getAllHighlighters()) {
            highlighter.dispose();
        }
        this.myCachedHighlighters = null;
        this.myHighlighterTree.clear();
        this.myHighlighterTreeForLines.clear();
    }

    @Override
    @NotNull
    public Document getDocument() {
        DocumentEx documentEx = this.myDocument;
        if (documentEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/MarkupModelImpl", "getDocument"));
        }
        return documentEx;
    }

    @Override
    public void addMarkupModelListener(@NotNull Disposable parentDisposable, final @NotNull MarkupModelListener listener) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addMarkupModelListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addMarkupModelListener"));
        }
        this.myListeners.add(listener);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                MarkupModelImpl.this.removeMarkupModelListener(listener);
            }
        });
    }

    void removeMarkupModelListener(@NotNull MarkupModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/MarkupModelImpl", "removeMarkupModelListener"));
        }
        boolean success = this.myListeners.remove(listener);
        LOG.assertTrue(success);
    }

    @Override
    public void setRangeHighlighterAttributes(@NotNull RangeHighlighter highlighter, @NotNull TextAttributes textAttributes) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/MarkupModelImpl", "setRangeHighlighterAttributes"));
        }
        if (textAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textAttributes", "com/intellij/openapi/editor/impl/MarkupModelImpl", "setRangeHighlighterAttributes"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((RangeHighlighterEx)highlighter).setTextAttributes(textAttributes);
    }

    @Override
    public void fireAttributesChanged(@NotNull RangeHighlighterEx segmentHighlighter, boolean renderersChanged) {
        if (segmentHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segmentHighlighter", "com/intellij/openapi/editor/impl/MarkupModelImpl", "fireAttributesChanged"));
        }
        for (MarkupModelListener listener : this.myListeners) {
            listener.attributesChanged(segmentHighlighter, renderersChanged);
        }
    }

    @Override
    public void fireAfterAdded(@NotNull RangeHighlighterEx segmentHighlighter) {
        if (segmentHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segmentHighlighter", "com/intellij/openapi/editor/impl/MarkupModelImpl", "fireAfterAdded"));
        }
        for (MarkupModelListener listener : this.myListeners) {
            listener.afterAdded(segmentHighlighter);
        }
    }

    @Override
    public void fireBeforeRemoved(@NotNull RangeHighlighterEx segmentHighlighter) {
        if (segmentHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segmentHighlighter", "com/intellij/openapi/editor/impl/MarkupModelImpl", "fireBeforeRemoved"));
        }
        for (MarkupModelListener listener : this.myListeners) {
            listener.beforeRemoved(segmentHighlighter);
        }
    }

    @Override
    public boolean containsHighlighter(final @NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/MarkupModelImpl", "containsHighlighter"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Processor<RangeHighlighterEx> equalId = new Processor<RangeHighlighterEx>(){

            @Override
            public boolean process(RangeHighlighterEx h) {
                return h.getId() != ((RangeHighlighterEx)highlighter).getId();
            }
        };
        return !this.treeFor(highlighter).processOverlappingWith(highlighter.getStartOffset(), highlighter.getEndOffset(), equalId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRangeHighlightersOverlappingWith(int start, int end, @NotNull Processor<? super RangeHighlighterEx> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/MarkupModelImpl", "processRangeHighlightersOverlappingWith"));
        }
        DisposableIterator iterator = this.overlappingIterator(start, end);
        try {
            while (iterator.hasNext()) {
                if (processor.process((RangeHighlighterEx)iterator.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            iterator.dispose();
        }
    }

    @Override
    public boolean processRangeHighlightersOutside(int start, int end, @NotNull Processor<? super RangeHighlighterEx> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/MarkupModelImpl", "processRangeHighlightersOutside"));
        }
        return this.myHighlighterTree.processOverlappingWithOutside(start, end, processor) && this.myHighlighterTreeForLines.processOverlappingWithOutside(start, end, processor);
    }

    @NotNull
    public IntervalTreeImpl.PeekableIterator<RangeHighlighterEx> overlappingIterator(int startOffset, int endOffset) {
        startOffset = Math.max(0, startOffset);
        endOffset = Math.max(startOffset, endOffset);
        IntervalTreeImpl.PeekableIterator<RangeHighlighterEx> peekableIterator = IntervalTreeImpl.mergingOverlappingIterator(this.myHighlighterTree, new TextRangeInterval(startOffset, endOffset), this.myHighlighterTreeForLines, this.roundToLineBoundaries(startOffset, endOffset), RangeHighlighterEx.BY_AFFECTED_START_OFFSET);
        if (peekableIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/MarkupModelImpl", "overlappingIterator"));
        }
        return peekableIterator;
    }

    @NotNull
    private TextRangeInterval roundToLineBoundaries(int startOffset, int endOffset) {
        int lineStartOffset;
        Document document = this.getDocument();
        int textLength = document.getTextLength();
        int n = startOffset <= 0 ? 0 : (lineStartOffset = startOffset > textLength ? textLength : document.getLineStartOffset(document.getLineNumber(startOffset)));
        int lineEndOffset = endOffset <= 0 ? 0 : (endOffset >= textLength ? textLength : document.getLineEndOffset(document.getLineNumber(endOffset)));
        TextRangeInterval textRangeInterval = new TextRangeInterval(lineStartOffset, lineEndOffset);
        if (textRangeInterval == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/MarkupModelImpl", "roundToLineBoundaries"));
        }
        return textRangeInterval;
    }
}

