/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.ManualRangeMarker;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.editor.impl.event.RetargetRangeMarkers;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.containers.WeakValueHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MarkerCache {
    private final Set<ManualRangeMarker> myMarkerSet = Collections.newSetFromMap(new WeakHashMap());
    private WeakValueHashMap<RangeKey, ManualRangeMarker> myByRange = new WeakValueHashMap();
    private volatile Trinity<Integer, Map<RangeKey, ManualRangeMarker>, FrozenDocument> myUpdatedRanges;

    MarkerCache() {
    }

    @Nullable
    private static RangeKey keyOf(@NotNull ManualRangeMarker marker) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/psi/impl/smartPointers/MarkerCache", "keyOf"));
        }
        ProperTextRange range = marker.getRange();
        return range == null ? null : new RangeKey(range, marker.isGreedyLeft(), marker.isGreedyRight(), marker.isSurviveOnExternalChange());
    }

    @NotNull
    synchronized ManualRangeMarker obtainMarker(@NotNull ProperTextRange range, @NotNull FrozenDocument frozen, boolean greedyLeft, boolean greedyRight, boolean persistent) {
        RangeKey key;
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/MarkerCache", "obtainMarker"));
        }
        if (frozen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frozen", "com/intellij/psi/impl/smartPointers/MarkerCache", "obtainMarker"));
        }
        WeakValueHashMap<RangeKey, ManualRangeMarker> byRange = this.getByRangeCache();
        ManualRangeMarker marker = (ManualRangeMarker)byRange.get(key = new RangeKey(range, greedyLeft, greedyRight, persistent));
        if (marker == null) {
            marker = new ManualRangeMarker(frozen, range, greedyLeft, greedyRight, persistent);
            this.myMarkerSet.add(marker);
            byRange.put((Object)key, (Object)marker);
            this.myUpdatedRanges = null;
        }
        ManualRangeMarker manualRangeMarker = marker;
        if (manualRangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/MarkerCache", "obtainMarker"));
        }
        return manualRangeMarker;
    }

    private WeakValueHashMap<RangeKey, ManualRangeMarker> getByRangeCache() {
        if (this.myByRange == null) {
            this.myByRange = new WeakValueHashMap();
            for (ManualRangeMarker marker : this.myMarkerSet) {
                RangeKey key = MarkerCache.keyOf(marker);
                if (key == null) continue;
                this.myByRange.put((Object)key, (Object)marker);
            }
        }
        return this.myByRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<RangeKey, ManualRangeMarker> getUpdatedMarkers(@NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events) {
        if (frozen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frozen", "com/intellij/psi/impl/smartPointers/MarkerCache", "getUpdatedMarkers"));
        }
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/psi/impl/smartPointers/MarkerCache", "getUpdatedMarkers"));
        }
        if (this.myMarkerSet.isEmpty()) {
            return Collections.emptyMap();
        }
        int eventCount = events.size();
        assert (eventCount > 0);
        Trinity<Integer, Map<RangeKey, ManualRangeMarker>, FrozenDocument> cache = this.myUpdatedRanges;
        if (cache != null && (Integer)cache.first == eventCount) {
            return (Map)cache.second;
        }
        MarkerCache markerCache = this;
        synchronized (markerCache) {
            cache = this.myUpdatedRanges;
            if (cache != null && (Integer)cache.first == eventCount) {
                return (Map)cache.second;
            }
            HashMap<RangeKey, ManualRangeMarker> answer = ContainerUtil.newHashMap();
            if (cache != null && (Integer)cache.first < eventCount) {
                answer.putAll((Map)cache.second);
                frozen = MarkerCache.applyEvents((FrozenDocument)cache.third, events.subList((Integer)cache.first, eventCount), answer);
            } else {
                for (ManualRangeMarker marker : this.myMarkerSet) {
                    RangeKey key = MarkerCache.keyOf(marker);
                    if (key == null) continue;
                    answer.put(key, marker);
                }
                frozen = MarkerCache.applyEvents(frozen, events, answer);
            }
            this.myUpdatedRanges = Trinity.create(eventCount, answer, frozen);
            return answer;
        }
    }

    private static FrozenDocument applyEvents(@NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events, Map<RangeKey, ManualRangeMarker> map) {
        if (frozen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frozen", "com/intellij/psi/impl/smartPointers/MarkerCache", "applyEvents"));
        }
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/psi/impl/smartPointers/MarkerCache", "applyEvents"));
        }
        for (DocumentEvent event : events) {
            DocumentEventImpl corrected;
            if (event instanceof RetargetRangeMarkers) {
                RetargetRangeMarkers retarget = (RetargetRangeMarkers)event;
                corrected = new RetargetRangeMarkers(frozen, retarget.getStartOffset(), retarget.getEndOffset(), retarget.getMoveDestinationOffset());
            } else {
                frozen = frozen.applyEvent(event, 0);
                corrected = new DocumentEventImpl(frozen, event.getOffset(), event.getOldFragment(), event.getNewFragment(), event.getOldTimeStamp(), event.isWholeTextReplaced());
            }
            for (Map.Entry<RangeKey, ManualRangeMarker> entry : map.entrySet()) {
                ManualRangeMarker currentRange = entry.getValue();
                if (currentRange == null) continue;
                entry.setValue(currentRange.getUpdatedRange(corrected));
            }
        }
        return frozen;
    }

    synchronized void updateMarkers(@NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events, @NotNull List<SmartPsiElementPointerImpl> pointers) {
        ManualRangeMarker marker;
        if (frozen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frozen", "com/intellij/psi/impl/smartPointers/MarkerCache", "updateMarkers"));
        }
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/psi/impl/smartPointers/MarkerCache", "updateMarkers"));
        }
        if (pointers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/psi/impl/smartPointers/MarkerCache", "updateMarkers"));
        }
        List<SelfElementInfo> infos = ContainerUtil.findAll(ContainerUtil.map(pointers, new NullableFunction<SmartPsiElementPointerImpl, SmartPointerElementInfo>(){

            @Override
            @Nullable
            public SmartPointerElementInfo fun(SmartPsiElementPointerImpl pointer) {
                return pointer.getElementInfo();
            }
        }), SelfElementInfo.class);
        Map<RangeKey, ManualRangeMarker> updated = this.getUpdatedMarkers(frozen, events);
        HashMap<ManualRangeMarker, ManualRangeMarker> newStates = ContainerUtil.newHashMap();
        for (SelfElementInfo selfElementInfo : infos) {
            marker = selfElementInfo.getRangeMarker();
            RangeKey key = marker == null ? null : MarkerCache.keyOf(marker);
            if (key == null) continue;
            newStates.put(marker, updated.get(key));
        }
        this.myMarkerSet.clear();
        for (Map.Entry entry : newStates.entrySet()) {
            marker = (ManualRangeMarker)entry.getKey();
            marker.applyState((ManualRangeMarker)entry.getValue());
            if (!marker.isValid()) continue;
            this.myMarkerSet.add(marker);
        }
        this.myByRange = null;
        this.myUpdatedRanges = null;
        for (SelfElementInfo selfElementInfo : infos) {
            selfElementInfo.updateValidity();
        }
    }

    @Nullable
    ProperTextRange getUpdatedRange(@NotNull ManualRangeMarker marker, @NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/psi/impl/smartPointers/MarkerCache", "getUpdatedRange"));
        }
        if (frozen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frozen", "com/intellij/psi/impl/smartPointers/MarkerCache", "getUpdatedRange"));
        }
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/psi/impl/smartPointers/MarkerCache", "getUpdatedRange"));
        }
        ManualRangeMarker updated = this.getUpdatedMarkers(frozen, events).get(MarkerCache.keyOf(marker));
        return updated == null ? null : updated.getRange();
    }

    synchronized int getMarkerCount() {
        return this.myMarkerSet.size();
    }

    private static class RangeKey {
        final int start;
        final int end;
        final int flags;

        RangeKey(ProperTextRange range, boolean greedyLeft, boolean greedyRight, boolean persistent) {
            this.start = range.getStartOffset();
            this.end = range.getEndOffset();
            this.flags = (persistent ? 4 : 0) + (greedyLeft ? 2 : 0) + (greedyRight ? 1 : 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RangeKey)) {
                return false;
            }
            RangeKey key = (RangeKey)o;
            if (this.start != key.start) {
                return false;
            }
            if (this.end != key.end) {
                return false;
            }
            return this.flags == key.flags;
        }

        public int hashCode() {
            int result = this.start;
            result = 31 * result + this.end;
            result = 31 * result + this.flags;
            return result;
        }

        public String toString() {
            return "RangeKey{start=" + this.start + ", end=" + this.end + ", flags=" + this.flags + '}';
        }
    }
}

