/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.ManualRangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.MarkerCache;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelfElementInfo
extends SmartPointerElementInfo {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.smartPointers.SelfElementInfo");
    private static final FileDocumentManager ourFileDocManager = FileDocumentManager.getInstance();
    @NotNull
    private final VirtualFile myVirtualFile;
    private final Class myType;
    private final Project myProject;
    private final Language myLanguage;
    private final MarkerCache myMarkerCache;
    @Nullable
    private ManualRangeMarker myRangeMarker;
    @Nullable
    private ProperTextRange myPsiRange;
    private final PsiDocumentManagerBase myPsiDocManager;

    SelfElementInfo(@NotNull Project project, @NotNull ProperTextRange range, @NotNull Class anchorClass, @NotNull PsiFile containingFile, @NotNull Language language) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (anchorClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchorClass", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        this.myLanguage = language;
        this.myVirtualFile = containingFile.getViewProvider().getVirtualFile();
        this.myType = anchorClass;
        assert (!PsiFile.class.isAssignableFrom(anchorClass)) : "FileElementInfo must be used for files";
        this.myProject = project;
        this.myPsiRange = range;
        this.myMarkerCache = ((SmartPointerManagerImpl)SmartPointerManager.getInstance(project)).getMarkerCache(this.myVirtualFile);
        this.myPsiDocManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject);
        Document document = this.myPsiDocManager.getCachedDocument(containingFile);
        if (document != null) {
            this.setRange(range, document);
        }
    }

    void setRange(@NotNull TextRange range, @NotNull Document document) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "setRange"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "setRange"));
        }
        this.myPsiRange = null;
        FrozenDocument frozenDocument = this.myPsiDocManager.getLastCommittedDocument(document);
        this.myRangeMarker = this.myMarkerCache.obtainMarker(ProperTextRange.create(range), frozenDocument, false, false, true);
    }

    @Override
    public Document getDocumentToSynchronize() {
        return ourFileDocManager.getCachedDocument(this.myVirtualFile);
    }

    @Override
    public void fastenBelt() {
        if (this.myRangeMarker != null) {
            return;
        }
        if (this.myPsiRange == null) {
            return;
        }
        Document document = ourFileDocManager.getDocument(this.myVirtualFile);
        if (document == null || !this.myPsiDocManager.isCommitted(document)) {
            this.myPsiRange = null;
            return;
        }
        this.setRange(this.myPsiRange, document);
    }

    @Override
    public PsiElement restoreElement() {
        Segment segment = this.getPsiRange();
        if (segment == null) {
            return null;
        }
        PsiFile file = this.restoreFile();
        if (file == null || !file.isValid()) {
            return null;
        }
        return SelfElementInfo.findElementInside(file, segment.getStartOffset(), segment.getEndOffset(), this.myType, this.myLanguage);
    }

    @Nullable
    protected Segment getPsiRange() {
        return this.myRangeMarker != null ? this.myRangeMarker.getRange() : this.myPsiRange;
    }

    @Override
    public PsiFile restoreFile() {
        return SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myLanguage);
    }

    static PsiElement findElementInside(@NotNull PsiFile file, int syncStartOffset, int syncEndOffset, @NotNull Class type, @NotNull Language language) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        PsiElement anchor = file.getViewProvider().findElementAt(syncStartOffset, language);
        if (anchor == null) {
            return null;
        }
        TextRange range = anchor.getTextRange();
        if (range.getStartOffset() != syncStartOffset) {
            return null;
        }
        while (range.getEndOffset() < syncEndOffset && (anchor = anchor.getParent()) != null && anchor.getTextRange() != null) {
            range = anchor.getTextRange();
        }
        while (range.getEndOffset() == syncEndOffset && anchor != null && !type.equals(anchor.getClass()) && (anchor = anchor.getParent()) != null && anchor.getTextRange() != null) {
            range = anchor.getTextRange();
        }
        return range.getEndOffset() == syncEndOffset ? anchor : null;
    }

    @Override
    public void cleanup() {
        this.myRangeMarker = null;
        this.myPsiRange = null;
    }

    void updateValidity() {
        if (this.myPsiRange != null) {
            LOG.error("Non-fastened smart pointer " + this + " " + this.myRangeMarker);
            this.myPsiRange = null;
            this.myRangeMarker = null;
        }
        if (this.myRangeMarker != null && !this.myRangeMarker.isValid()) {
            this.myRangeMarker = null;
        }
    }

    @Nullable
    public static PsiFile restoreFileFromVirtual(final @NotNull VirtualFile virtualFile, final @NotNull Project project, final @Nullable Language language) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreFileFromVirtual"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreFileFromVirtual"));
        }
        return ApplicationManager.getApplication().runReadAction(new NullableComputable<PsiFile>(){

            @Override
            public PsiFile compute() {
                VirtualFile child;
                if (project.isDisposed()) {
                    return null;
                }
                if (virtualFile.isValid()) {
                    child = virtualFile;
                } else {
                    VirtualFile vParent = virtualFile.getParent();
                    if (vParent == null || !vParent.isDirectory()) {
                        return null;
                    }
                    String name = virtualFile.getName();
                    child = vParent.findChild(name);
                }
                if (child == null || !child.isValid()) {
                    return null;
                }
                PsiFile file = PsiManager.getInstance(project).findFile(child);
                if (file != null && language != null) {
                    return file.getViewProvider().getPsi(language);
                }
                return file;
            }
        });
    }

    @Nullable
    public static PsiDirectory restoreDirectoryFromVirtual(final VirtualFile virtualFile, final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreDirectoryFromVirtual"));
        }
        if (virtualFile == null) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<PsiDirectory>(){

            @Override
            public PsiDirectory compute() {
                VirtualFile child;
                if (virtualFile.isValid()) {
                    child = virtualFile;
                } else {
                    VirtualFile vParent = virtualFile.getParent();
                    if (vParent == null || !vParent.isDirectory()) {
                        return null;
                    }
                    String name = virtualFile.getName();
                    child = vParent.findChild(name);
                }
                if (child == null || !child.isValid()) {
                    return null;
                }
                PsiDirectory file = PsiManager.getInstance(project).findDirectory(child);
                if (file == null || !file.isValid()) {
                    return null;
                }
                return file;
            }
        });
    }

    @Override
    public int elementHashCode() {
        return this.myVirtualFile.hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(final @NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof SelfElementInfo) {
            SelfElementInfo otherInfo = (SelfElementInfo)other;
            Segment range1 = this.getPsiRange();
            Segment range2 = otherInfo.getPsiRange();
            return Comparing.equal(this.myVirtualFile, otherInfo.myVirtualFile) && this.myType == otherInfo.myType && range1 != null && range2 != null && range1.getStartOffset() == range2.getStartOffset() && range1.getEndOffset() == range2.getEndOffset();
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                return Comparing.equal(SelfElementInfo.this.restoreElement(), other.restoreElement());
            }
        });
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "getVirtualFile"));
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public Segment getRange() {
        if (this.myRangeMarker != null) {
            PsiDocumentManagerBase documentManager;
            List<DocumentEvent> events;
            Document document = this.getDocumentToSynchronize();
            if (document != null && !(events = (documentManager = this.myPsiDocManager).getEventsSinceCommit(document)).isEmpty()) {
                return this.myMarkerCache.getUpdatedRange(this.myRangeMarker, documentManager.getLastCommittedDocument(document), events);
            }
            return this.myRangeMarker.getRange();
        }
        return this.myPsiRange;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "getProject"));
        }
        return project;
    }

    @Nullable
    ManualRangeMarker getRangeMarker() {
        return this.myRangeMarker;
    }
}

