/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.smartPointers.MarkerCache;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartPointerManagerImpl
extends SmartPointerManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl");
    private static final Object lock = new Object();
    private static final ReferenceQueue<SmartPointerEx> ourQueue = new ReferenceQueue();
    private static final LowMemoryWatcher ourWatcher = LowMemoryWatcher.register(new Runnable(){

        @Override
        public void run() {
            SmartPointerManagerImpl.processQueue();
        }
    });
    private final Project myProject;
    private final Key<FilePointersList> POINTERS_KEY;
    private static final Key<Reference<SmartPointerEx>> CACHED_SMART_POINTER_KEY = Key.create("CACHED_SMART_POINTER_KEY");

    public SmartPointerManagerImpl(Project project) {
        this.myProject = project;
        this.POINTERS_KEY = Key.create("SMART_POINTERS for " + project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processQueue() {
        PointerReference reference;
        while ((reference = (PointerReference)ourQueue.poll()) != null) {
            Object object = lock;
            synchronized (object) {
                FilePointersList pointers = (FilePointersList)reference.file.getUserData(reference.key);
                if (pointers != null) {
                    pointers.remove(reference);
                    if (pointers.isEmpty()) {
                        reference.file.putUserData(reference.key, null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fastenBelts(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "fastenBelts"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        SmartPointerManagerImpl.processQueue();
        Object object = lock;
        synchronized (object) {
            FilePointersList pointers = this.getPointers(file);
            if (pointers != null && !pointers.isEmpty()) {
                for (PointerReference ref : pointers.references) {
                    SmartPointerEx pointer = SoftReference.dereference(ref);
                    if (pointer == null) continue;
                    pointer.fastenBelt();
                }
            }
        }
    }

    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element.getContainingFile();
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        if (containingFile != null && !containingFile.isValid() || containingFile == null && !element.isValid()) {
            PsiUtilCore.ensureValid(element);
            LOG.error("Invalid element:" + element);
        }
        SmartPointerManagerImpl.processQueue();
        SmartPointerEx<E> pointer = SmartPointerManagerImpl.getCachedPointer(element);
        if (pointer == null) {
            pointer = new SmartPsiElementPointerImpl<E>(this.myProject, element, containingFile);
            if (containingFile != null) {
                this.initPointer((SmartPsiElementPointerImpl)pointer, containingFile.getViewProvider().getVirtualFile());
            }
            element.putUserData(CACHED_SMART_POINTER_KEY, new SoftReference<SmartPointerEx<E>>(pointer));
        } else {
            Object object = lock;
            synchronized (object) {
                if (pointer instanceof SmartPsiElementPointerImpl) {
                    ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(1);
                }
            }
        }
        SmartPointerEx<E> smartPointerEx = pointer;
        if (smartPointerEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPointerEx;
    }

    private static <E extends PsiElement> SmartPointerEx<E> getCachedPointer(@NotNull E element) {
        PsiElement cachedElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getCachedPointer"));
        }
        Reference<SmartPointerEx> data = element.getUserData(CACHED_SMART_POINTER_KEY);
        SmartPointerEx cachedPointer = SoftReference.dereference(data);
        if (cachedPointer != null && (cachedElement = cachedPointer.getCachedElement()) != null && cachedElement != element) {
            return null;
        }
        return cachedPointer;
    }

    @Override
    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file, @NotNull TextRange range) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (!file.isValid()) {
            LOG.error("Invalid element:" + file);
        }
        SmartPointerManagerImpl.processQueue();
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(file, ProperTextRange.create(range));
        this.initPointer(pointer, file.getViewProvider().getVirtualFile());
        SmartPsiFileRangePointerImpl smartPsiFileRangePointerImpl = pointer;
        if (smartPsiFileRangePointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        return smartPsiFileRangePointerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends PsiElement> void initPointer(@NotNull SmartPsiElementPointerImpl<E> pointer, @NotNull VirtualFile containingFile) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "initPointer"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "initPointer"));
        }
        Object object = lock;
        synchronized (object) {
            pointer.incrementAndGetReferenceCount(1);
            this.getNotNullPointerList(containingFile).add(new PointerReference(pointer, containingFile, SmartPointerManagerImpl.ourQueue, this.POINTERS_KEY));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private FilePointersList getNotNullPointerList(@NotNull VirtualFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getNotNullPointerList"));
        }
        Object object = lock;
        // MONITORENTER : object
        FilePointersList pointers = this.getPointers(containingFile);
        if (pointers == null) {
            pointers = new FilePointersList();
            containingFile.putUserData(this.POINTERS_KEY, pointers);
        }
        FilePointersList filePointersList = pointers;
        // MONITOREXIT : object
        if (filePointersList != null) return filePointersList;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getNotNullPointerList"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePointer(@NotNull SmartPsiElementPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "removePointer"));
        }
        if (!(pointer instanceof SmartPsiElementPointerImpl)) {
            return false;
        }
        PsiFile containingFile = pointer.getContainingFile();
        Object object = lock;
        synchronized (object) {
            int refCount = ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(-1);
            if (refCount == 0) {
                PsiElement element = ((SmartPointerEx)pointer).getCachedElement();
                if (element != null) {
                    element.putUserData(CACHED_SMART_POINTER_KEY, null);
                }
                SmartPointerElementInfo info = ((SmartPsiElementPointerImpl)pointer).getElementInfo();
                info.cleanup();
                if (containingFile == null) {
                    return false;
                }
                VirtualFile vFile = containingFile.getViewProvider().getVirtualFile();
                FilePointersList pointers = this.getPointers(vFile);
                if (pointers == null) {
                    return false;
                }
                boolean result = pointers.remove(pointer);
                if (pointers.isEmpty()) {
                    vFile.putUserData(this.POINTERS_KEY, null);
                }
                return result;
            }
        }
        return false;
    }

    @Nullable
    private FilePointersList getPointers(@NotNull VirtualFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointers"));
        }
        return containingFile.getUserData(this.POINTERS_KEY);
    }

    @NotNull
    MarkerCache getMarkerCache(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getMarkerCache"));
        }
        MarkerCache markerCache = this.getNotNullPointerList(file).markerCache;
        if (markerCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getMarkerCache"));
        }
        return markerCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPointersNumber(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointersNumber"));
        }
        Object object = lock;
        synchronized (object) {
            VirtualFile file = containingFile.getViewProvider().getVirtualFile();
            FilePointersList pointers = this.getPointers(file);
            return pointers == null ? 0 : pointers.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMarkerCount(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getMarkerCount"));
        }
        Object object = lock;
        synchronized (object) {
            VirtualFile file = FileDocumentManager.getInstance().getFile(document);
            return file == null ? 0 : this.getMarkerCache(file).getMarkerCount();
        }
    }

    @Override
    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer1", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        if (pointer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer2", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }

    public void updatePointers(Document document, FrozenDocument frozen, List<DocumentEvent> events) {
        FilePointersList list;
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        FilePointersList filePointersList = list = file == null ? null : this.getPointers(file);
        if (list == null) {
            return;
        }
        list.markerCache.updateMarkers(frozen, events, list.getAlivePointers());
    }

    private static class FilePointersList {
        private int nextAvailableIndex;
        private int size;
        private PointerReference[] references = new PointerReference[10];
        private final MarkerCache markerCache = new MarkerCache();

        private FilePointersList() {
        }

        private void add(@NotNull PointerReference reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "add"));
            }
            if (this.nextAvailableIndex >= this.references.length || this.nextAvailableIndex > this.size * 2) {
                int newCapacity = this.nextAvailableIndex >= this.references.length ? this.references.length * 3 / 2 + 1 : this.size * 3 / 2 + 1;
                PointerReference[] newReferences = new PointerReference[newCapacity];
                int o = 0;
                for (PointerReference oldRef : this.references) {
                    if (SoftReference.dereference(oldRef) == null) continue;
                    newReferences[o++] = oldRef;
                }
                this.references = newReferences;
                this.size = this.nextAvailableIndex = o;
            }
            this.references[this.nextAvailableIndex++] = reference;
            ++this.size;
        }

        private void remove(@NotNull PointerReference reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "remove"));
            }
            int index = ArrayUtil.indexOf(this.references, reference);
            if (index != -1) {
                this.references[index] = null;
                --this.size;
            }
        }

        private boolean remove(@NotNull SmartPsiElementPointer smartPointer) {
            if (smartPointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "smartPointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "remove"));
            }
            boolean result = false;
            for (int i = 0; i < this.references.length; ++i) {
                PointerReference reference = this.references[i];
                if (reference == null || reference.get() != smartPointer) continue;
                this.references[i] = null;
                result = true;
                break;
            }
            --this.size;
            return result;
        }

        private boolean isEmpty() {
            return this.size == 0;
        }

        @NotNull
        private List<SmartPsiElementPointerImpl> getAlivePointers() {
            List<SmartPsiElementPointerImpl> list = ContainerUtil.mapNotNull(this.references, new Function<PointerReference, SmartPsiElementPointerImpl>(){

                @Override
                public SmartPsiElementPointerImpl fun(PointerReference reference) {
                    return (SmartPsiElementPointerImpl)SoftReference.dereference(reference);
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "getAlivePointers"));
            }
            return list;
        }
    }

    private static class PointerReference
    extends WeakReference<SmartPointerEx> {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final Key<FilePointersList> key;

        private PointerReference(@NotNull SmartPointerEx<?> pointer, @NotNull VirtualFile containingFile, @NotNull ReferenceQueue<SmartPointerEx> queue, @NotNull Key<FilePointersList> key) {
            if (pointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            if (queue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            super(pointer, queue);
            this.file = containingFile;
            this.key = key;
        }
    }
}

