/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph;

import com.intellij.openapi.util.Couple;
import com.intellij.util.graph.Graph;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DFSTBuilder<Node> {
    private final Graph<Node> myGraph;
    private final TObjectIntHashMap<Node> myNodeToNNumber;
    private TObjectIntHashMap<Node> myNodeToTNumber;
    private final Node[] myInvN;
    private Couple<Node> myBackEdge;
    private Comparator<Node> myComparator;
    private boolean myNBuilt;
    private boolean myTBuilt;
    private TIntArrayList mySCCs;
    private Node[] myInvT;

    public DFSTBuilder(Graph<Node> graph) {
        this.myGraph = graph;
        this.myNodeToNNumber = new TObjectIntHashMap(this.myGraph.getNodes().size() * 2, 0.5f);
        this.myInvN = new Object[this.myGraph.getNodes().size()];
    }

    public void buildDFST() {
        if (this.myNBuilt) {
            return;
        }
        Collection<Node> nodes = this.myGraph.getNodes();
        int indexN = nodes.size();
        LinkedHashSet processed = new LinkedHashSet();
        for (Node node : nodes) {
            if (this.myGraph.getIn(node).hasNext()) continue;
            indexN = this.traverseSubGraph(node, indexN, processed);
        }
        for (Node node : nodes) {
            indexN = this.traverseSubGraph(node, indexN, processed);
        }
        this.myNBuilt = true;
    }

    public Comparator<Node> comparator() {
        if (this.myComparator == null) {
            TObjectIntHashMap<Node> map;
            this.buildDFST();
            if (this.isAcyclic()) {
                map = this.myNodeToNNumber;
            } else {
                this.build_T();
                map = this.myNodeToTNumber;
            }
            this.myComparator = new Comparator<Node>(){

                @Override
                public int compare(@NotNull Node t, @NotNull Node t1) {
                    if (t == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/graph/DFSTBuilder$1", "compare"));
                    }
                    if (t1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t1", "com/intellij/util/graph/DFSTBuilder$1", "compare"));
                    }
                    return map.get(t) - map.get(t1);
                }
            };
        }
        return this.myComparator;
    }

    private int traverseSubGraph(Node node, int nNumber, Set<Node> processed) {
        if (!processed.contains(node)) {
            processed.add(node);
            Iterator<Node> it = this.myGraph.getOut(node);
            while (it.hasNext()) {
                nNumber = this.traverseSubGraph(it.next(), nNumber, processed);
            }
            this.myNodeToNNumber.put(node, --nNumber);
            this.myInvN[nNumber] = node;
            if (this.myBackEdge == null) {
                it = this.myGraph.getIn(node);
                while (it.hasNext()) {
                    Node prev = it.next();
                    int prevNumber = this.myNodeToNNumber.get(prev);
                    if (!this.myNodeToNNumber.containsKey(prev) || prevNumber <= nNumber) continue;
                    this.myBackEdge = Couple.of(node, prev);
                    break;
                }
            }
        }
        return nNumber;
    }

    private Set<Node> region(Node v) {
        LinkedList<Node> frontier = new LinkedList<Node>();
        frontier.addFirst(v);
        LinkedHashSet result = new LinkedHashSet();
        int number = this.myNodeToNNumber.get(v);
        while (!frontier.isEmpty()) {
            Object curr = frontier.removeFirst();
            result.add(curr);
            Iterator<Node> it = this.myGraph.getIn(curr);
            while (it.hasNext()) {
                Node w = it.next();
                if (this.myNodeToNNumber.get(w) <= number || result.contains(w)) continue;
                frontier.add(w);
            }
        }
        return result;
    }

    private void build_T() {
        if (this.myTBuilt) {
            return;
        }
        this.myInvT = new Object[this.myGraph.getNodes().size()];
        this.mySCCs = new TIntArrayList();
        int size = this.myGraph.getNodes().size();
        this.myNodeToTNumber = new TObjectIntHashMap(size * 2, 0.5f);
        int currT = 0;
        for (int i = 0; i < size; ++i) {
            Node v = this.myInvN[i];
            if (this.myNodeToTNumber.containsKey(v)) continue;
            Set<Node> region = this.region(v);
            this.mySCCs.add(region.size());
            this.myNodeToTNumber.put(v, currT);
            this.myInvT[currT++] = v;
            for (Node w : region) {
                if (w == v) continue;
                this.myNodeToTNumber.put(w, currT);
                this.myInvT[currT++] = w;
            }
        }
        this.myTBuilt = true;
    }

    public Couple<Node> getCircularDependency() {
        this.buildDFST();
        return this.myBackEdge;
    }

    public boolean isAcyclic() {
        return this.getCircularDependency() == null;
    }

    public Node getNodeByNNumber(int n) {
        return this.myInvN[n];
    }

    public Node getNodeByTNumber(int n) {
        return this.myInvT[n];
    }

    public TIntArrayList getSCCs() {
        if (!this.myNBuilt) {
            this.buildDFST();
        }
        if (!this.myTBuilt) {
            this.build_T();
        }
        return this.mySCCs;
    }

    @NotNull
    public List<Node> getSortedNodes() {
        ArrayList<Node> result = new ArrayList<Node>(this.myGraph.getNodes());
        Collections.sort(result, this.comparator());
        ArrayList<Node> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/graph/DFSTBuilder", "getSortedNodes"));
        }
        return arrayList;
    }
}

