/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.finalization;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

class CallToSuperFinalizeVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean callToSuperFinalizeFound;

    CallToSuperFinalizeVisitor() {
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/finalization/CallToSuperFinalizeVisitor", "visitElement"));
        }
        if (!this.callToSuperFinalizeFound) {
            super.visitElement(element);
        }
    }

    @Override
    public void visitIfStatement(PsiIfStatement statement) {
        PsiExpression condition = statement.getCondition();
        Object result = ExpressionUtils.computeConstantExpression(condition);
        if (result != null && result.equals(Boolean.FALSE)) {
            return;
        }
        super.visitIfStatement(statement);
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/finalization/CallToSuperFinalizeVisitor", "visitMethodCallExpression"));
        }
        if (this.callToSuperFinalizeFound) {
            return;
        }
        super.visitMethodCallExpression(expression);
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiExpression target = methodExpression.getQualifierExpression();
        if (!(target instanceof PsiSuperExpression)) {
            return;
        }
        String methodName = methodExpression.getReferenceName();
        if (!"finalize".equals(methodName)) {
            return;
        }
        this.callToSuperFinalizeFound = true;
    }

    boolean isCallToSuperFinalizeFound() {
        return this.callToSuperFinalizeFound;
    }
}

