/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html.dtd;

import com.intellij.html.impl.RelaxedHtmlFromSchemaElementDescriptor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.html.dtd.HtmlAttributeDescriptorImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.dtd.BaseXmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.HashMap;

public class HtmlElementDescriptorImpl
extends BaseXmlElementDescriptorImpl {
    private final XmlElementDescriptor myDelegate;
    private final boolean myRelaxed;
    private final boolean myCaseSensitive;

    public HtmlElementDescriptorImpl(XmlElementDescriptor _delegate, boolean relaxed, boolean caseSensitive) {
        this.myDelegate = _delegate;
        this.myRelaxed = relaxed;
        this.myCaseSensitive = caseSensitive;
    }

    @Override
    public String getQualifiedName() {
        return this.myDelegate.getQualifiedName();
    }

    @Override
    public String getDefaultName() {
        return this.myDelegate.getDefaultName();
    }

    @Override
    protected final XmlElementDescriptor[] doCollectXmlDescriptors(XmlTag context) {
        XmlElementDescriptor[] elementsDescriptors = this.myDelegate.getElementsDescriptors(context);
        XmlElementDescriptor[] temp = new XmlElementDescriptor[elementsDescriptors.length];
        for (int i = 0; i < elementsDescriptors.length; ++i) {
            temp[i] = new HtmlElementDescriptorImpl(elementsDescriptors[i], this.myRelaxed, this.myCaseSensitive);
        }
        return temp;
    }

    @Override
    public XmlElementDescriptor getElementDescriptor(XmlTag element, XmlTag contextTag) {
        XmlElementDescriptor xmlElementDescriptor;
        String name = element.getName();
        if (!this.myCaseSensitive) {
            name = name.toLowerCase();
        }
        if ((xmlElementDescriptor = this.getElementDescriptor(name, element)) == null && "html".equals(this.getName())) {
            XmlElementDescriptor bodyDescriptor;
            XmlElementDescriptor headDescriptor;
            XmlTag head = null;
            PsiElement body = null;
            for (XmlTag child : PsiTreeUtil.getChildrenOfTypeAsList(contextTag, XmlTag.class)) {
                if ("head".equals(child.getName())) {
                    head = child;
                }
                if (!"body".equals(child.getName())) continue;
                body = child;
            }
            if (head == null && (body == null || element.getTextOffset() < body.getTextOffset()) && (headDescriptor = this.getElementDescriptor("head", contextTag)) != null) {
                xmlElementDescriptor = headDescriptor.getElementDescriptor(element, contextTag);
            }
            if (xmlElementDescriptor == null && body == null && (bodyDescriptor = this.getElementDescriptor("body", contextTag)) != null) {
                xmlElementDescriptor = bodyDescriptor.getElementDescriptor(element, contextTag);
            }
        }
        if (xmlElementDescriptor == null && this.myRelaxed) {
            xmlElementDescriptor = RelaxedHtmlFromSchemaElementDescriptor.getRelaxedDescriptor(this, element);
        }
        return xmlElementDescriptor;
    }

    @Override
    protected HashMap<String, XmlElementDescriptor> collectElementDescriptorsMap(XmlTag element) {
        XmlElementDescriptor[] elementDescriptors;
        HashMap<String, XmlElementDescriptor> hashMap = new HashMap<String, XmlElementDescriptor>();
        for (XmlElementDescriptor elementDescriptor : elementDescriptors = this.myDelegate.getElementsDescriptors(element)) {
            hashMap.put(elementDescriptor.getName(), new HtmlElementDescriptorImpl(elementDescriptor, this.myRelaxed, this.myCaseSensitive));
        }
        return hashMap;
    }

    @Override
    protected XmlAttributeDescriptor[] collectAttributeDescriptors(XmlTag context) {
        XmlAttributeDescriptor[] attributesDescriptors = this.myDelegate.getAttributesDescriptors(context);
        XmlAttributeDescriptor[] temp = new XmlAttributeDescriptor[attributesDescriptors.length];
        for (int i = 0; i < attributesDescriptors.length; ++i) {
            temp[i] = new HtmlAttributeDescriptorImpl(attributesDescriptors[i], this.myCaseSensitive);
        }
        return temp;
    }

    @Override
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context) {
        XmlNSDescriptor nsdescriptor;
        String prefix;
        String caseSensitiveAttributeName = !this.myCaseSensitive ? attributeName.toLowerCase() : attributeName;
        XmlAttributeDescriptor descriptor = super.getAttributeDescriptor(caseSensitiveAttributeName, context);
        if (descriptor == null) {
            descriptor = RelaxedHtmlFromSchemaElementDescriptor.getAttributeDescriptorFromFacelets(attributeName, context);
        }
        if (descriptor == null && "xml".equals(prefix = XmlUtil.findPrefixByQualifiedName(attributeName)) && (nsdescriptor = context.getNSDescriptor("http://www.w3.org/XML/1998/namespace", true)) instanceof XmlNSDescriptorImpl) {
            descriptor = ((XmlNSDescriptorImpl)nsdescriptor).getAttribute(XmlUtil.findLocalNameByQualifiedName(caseSensitiveAttributeName), "http://www.w3.org/XML/1998/namespace", context);
        }
        if (descriptor == null && HtmlUtil.isHtml5Context(context)) {
            descriptor = this.myDelegate.getAttributeDescriptor(attributeName, context);
        }
        return descriptor;
    }

    @Override
    protected HashMap<String, XmlAttributeDescriptor> collectAttributeDescriptorsMap(XmlTag context) {
        XmlAttributeDescriptor[] elementAttributeDescriptors;
        HashMap<String, XmlAttributeDescriptor> hashMap = new HashMap<String, XmlAttributeDescriptor>();
        for (XmlAttributeDescriptor attributeDescriptor : elementAttributeDescriptors = this.myDelegate.getAttributesDescriptors(context)) {
            hashMap.put(attributeDescriptor.getName(), new HtmlAttributeDescriptorImpl(attributeDescriptor, this.myCaseSensitive));
        }
        return hashMap;
    }

    @Override
    public XmlNSDescriptor getNSDescriptor() {
        return this.myDelegate.getNSDescriptor();
    }

    @Override
    public int getContentType() {
        return this.myDelegate.getContentType();
    }

    @Override
    public PsiElement getDeclaration() {
        return this.myDelegate.getDeclaration();
    }

    @Override
    public String getName(PsiElement context) {
        return this.myDelegate.getName(context);
    }

    @Override
    public String getName() {
        return this.myDelegate.getName();
    }

    @Override
    public void init(PsiElement element) {
        this.myDelegate.init(element);
    }

    @Override
    public Object[] getDependences() {
        return this.myDelegate.getDependences();
    }

    @Override
    public XmlAttributeDescriptor[] getAttributesDescriptors(XmlTag context) {
        return RelaxedHtmlFromSchemaElementDescriptor.addAttrDescriptorsForFacelets(context, super.getAttributesDescriptors(context));
    }

    public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
        return true;
    }

    @Override
    public String toString() {
        return this.myDelegate.toString();
    }
}

