/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FixedConcurrentIntQueue;
import org.jetbrains.annotations.NotNull;

public class LRUConcurrentIntObjectMap<V> {
    private static final int TOMB_VALUE = -1;
    private final ConcurrentIntObjectMap<V> myMap;
    private final FixedConcurrentIntQueue queue;

    public LRUConcurrentIntObjectMap(int capacity) {
        this.queue = new FixedConcurrentIntQueue(capacity - capacity / 4 - 2, -1);
        this.myMap = ContainerUtil.createConcurrentIntObjectMap(capacity, 1.0f, Runtime.getRuntime().availableProcessors());
    }

    public V get(int key) {
        return this.myMap.get(key);
    }

    @NotNull
    public V computeIfAbsent(int key, @NotNull IntFunction<V> function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/util/containers/LRUConcurrentIntObjectMap", "computeIfAbsent"));
        }
        V v = this.myMap.get(key);
        if (v != null) {
            V v2 = v;
            if (v2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LRUConcurrentIntObjectMap", "computeIfAbsent"));
            }
            return v2;
        }
        V newV = function.apply(key);
        V prev = this.myMap.putIfAbsent(key, newV);
        if (prev == null) {
            this.addToQueue(key);
            V v3 = newV;
            if (v3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LRUConcurrentIntObjectMap", "computeIfAbsent"));
            }
            return v3;
        }
        V v4 = prev;
        if (v4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LRUConcurrentIntObjectMap", "computeIfAbsent"));
        }
        return v4;
    }

    public V put(int key, V value) {
        V prev = this.myMap.put(key, value);
        if (prev == null) {
            this.addToQueue(key);
        }
        return prev;
    }

    private void addToQueue(int key) {
        int evicted = this.queue.push(key);
        if (evicted != -1) {
            this.myMap.remove(evicted);
        }
    }

    public static interface IntFunction<R> {
        @NotNull
        public R apply(int var1);
    }
}

