/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ExceptionUtil;
import org.jetbrains.annotations.NotNull;

public class RunResult<T>
extends Result<T> {
    private BaseActionRunnable<T> myActionRunnable;
    private Throwable myThrowable;

    protected RunResult() {
    }

    public RunResult(@NotNull BaseActionRunnable<T> action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/RunResult", "<init>"));
        }
        this.myActionRunnable = action;
    }

    public RunResult<T> run() {
        try {
            this.myActionRunnable.run(this);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            this.myThrowable = t;
            if (!this.myActionRunnable.isSilentExecution()) {
                ExceptionUtil.rethrowUnchecked(t);
                throw new RuntimeException(this.myThrowable);
            }
        }
        finally {
            this.myActionRunnable = null;
        }
        return this;
    }

    public T getResultObject() {
        return (T)this.myResult;
    }

    @NotNull
    public RunResult logException(Logger logger) {
        if (this.myThrowable != null) {
            logger.error(this.myThrowable);
        }
        RunResult runResult = this;
        if (runResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/RunResult", "logException"));
        }
        return runResult;
    }

    @NotNull
    public RunResult<T> throwException() throws RuntimeException, Error {
        if (this.myThrowable != null) {
            ExceptionUtil.rethrowUnchecked(this.myThrowable);
            throw new RuntimeException(this.myThrowable);
        }
        RunResult runResult = this;
        if (runResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/RunResult", "throwException"));
        }
        return runResult;
    }

    public boolean hasException() {
        return this.myThrowable != null;
    }

    public Throwable getThrowable() {
        return this.myThrowable;
    }

    public void setThrowable(Exception throwable) {
        this.myThrowable = throwable;
    }
}

