/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.psi.impl.source.tree.LighterASTNodeVisitor;
import com.intellij.util.Function;
import com.intellij.util.WalkingState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class RecursiveLighterASTNodeWalkingVisitor
extends LighterASTNodeVisitor {
    @NotNull
    private final LighterAST ast;
    private final Stack<IndexedLighterASTNode[]> childrenStack;
    private final Stack<IndexedLighterASTNode> parentStack;
    private final WalkingState<IndexedLighterASTNode> myWalkingState;

    protected RecursiveLighterASTNodeWalkingVisitor(final @NotNull LighterAST ast) {
        if (ast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ast", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor", "<init>"));
        }
        this.childrenStack = new Stack();
        this.parentStack = new Stack();
        this.ast = ast;
        this.myWalkingState = new WalkingState<IndexedLighterASTNode>((WalkingState.TreeGuide)new LighterASTGuide()){

            @Override
            public void elementFinished(@NotNull IndexedLighterASTNode element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$1", "elementFinished"));
                }
                RecursiveLighterASTNodeWalkingVisitor.this.elementFinished(element.node);
                if (RecursiveLighterASTNodeWalkingVisitor.this.parentStack.peek() == element) {
                    IndexedLighterASTNode[] children = (IndexedLighterASTNode[])RecursiveLighterASTNodeWalkingVisitor.this.childrenStack.pop();
                    List<LighterASTNode> list = children.length == 0 ? Collections.emptyList() : ContainerUtil.map(children, new Function<IndexedLighterASTNode, LighterASTNode>(){

                        @Override
                        public LighterASTNode fun(IndexedLighterASTNode node) {
                            return node.node;
                        }
                    });
                    ast.disposeChildren(list);
                    RecursiveLighterASTNodeWalkingVisitor.this.parentStack.pop();
                }
            }

            @Override
            public void visit(@NotNull IndexedLighterASTNode iNode) {
                if (iNode == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iNode", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$1", "visit"));
                }
                LighterASTNode element = iNode.node;
                RecursiveLighterASTNodeWalkingVisitor visitor = RecursiveLighterASTNodeWalkingVisitor.this;
                if (element instanceof LighterLazyParseableNode) {
                    visitor.visitLazyParseableNode((LighterLazyParseableNode)element);
                } else if (element instanceof LighterASTTokenNode) {
                    visitor.visitTokenNode((LighterASTTokenNode)element);
                } else {
                    visitor.visitNode(element);
                }
            }
        };
    }

    protected void elementFinished(@NotNull LighterASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor", "elementFinished"));
        }
    }

    @Override
    public void visitNode(@NotNull LighterASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor", "visitNode"));
        }
        this.myWalkingState.elementStarted(new IndexedLighterASTNode(element, 0));
    }

    public void stopWalking() {
        this.myWalkingState.stopWalking();
    }

    private class LighterASTGuide
    implements WalkingState.TreeGuide<IndexedLighterASTNode> {
        private LighterASTGuide() {
        }

        @Override
        public IndexedLighterASTNode getNextSibling(@NotNull IndexedLighterASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$LighterASTGuide", "getNextSibling"));
            }
            IndexedLighterASTNode[] children = element == RecursiveLighterASTNodeWalkingVisitor.this.parentStack.peek() ? (IndexedLighterASTNode[])RecursiveLighterASTNodeWalkingVisitor.this.childrenStack.get(RecursiveLighterASTNodeWalkingVisitor.this.childrenStack.size() - 2) : (IndexedLighterASTNode[])RecursiveLighterASTNodeWalkingVisitor.this.childrenStack.peek();
            int indexInParent = element.indexInParent;
            assert (children[indexInParent] == element);
            return indexInParent == children.length - 1 ? null : children[indexInParent + 1];
        }

        @Override
        public IndexedLighterASTNode getPrevSibling(@NotNull IndexedLighterASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$LighterASTGuide", "getPrevSibling"));
            }
            IndexedLighterASTNode[] children = element == RecursiveLighterASTNodeWalkingVisitor.this.parentStack.peek() ? (IndexedLighterASTNode[])RecursiveLighterASTNodeWalkingVisitor.this.childrenStack.get(RecursiveLighterASTNodeWalkingVisitor.this.childrenStack.size() - 2) : (IndexedLighterASTNode[])RecursiveLighterASTNodeWalkingVisitor.this.childrenStack.peek();
            int indexInParent = element.indexInParent;
            assert (children[indexInParent] == element);
            return indexInParent == 0 ? null : children[indexInParent - 1];
        }

        @Override
        public IndexedLighterASTNode getFirstChild(@NotNull IndexedLighterASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$LighterASTGuide", "getFirstChild"));
            }
            List<LighterASTNode> children = RecursiveLighterASTNodeWalkingVisitor.this.ast.getChildren(element.node);
            IndexedLighterASTNode[] indexedChildren = children.isEmpty() ? IndexedLighterASTNode.EMPTY_ARRAY : new IndexedLighterASTNode[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                IndexedLighterASTNode indexedNode;
                LighterASTNode child = children.get(i);
                indexedChildren[i] = indexedNode = new IndexedLighterASTNode(child, i);
            }
            RecursiveLighterASTNodeWalkingVisitor.this.childrenStack.push(indexedChildren);
            RecursiveLighterASTNodeWalkingVisitor.this.parentStack.push(element);
            return children.isEmpty() ? null : indexedChildren[0];
        }

        @Override
        public IndexedLighterASTNode getParent(@NotNull IndexedLighterASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$LighterASTGuide", "getParent"));
            }
            return (IndexedLighterASTNode)RecursiveLighterASTNodeWalkingVisitor.this.parentStack.peek();
        }
    }

    private static class IndexedLighterASTNode {
        private static final IndexedLighterASTNode[] EMPTY_ARRAY = new IndexedLighterASTNode[0];
        private final LighterASTNode node;
        private final int indexInParent;

        IndexedLighterASTNode(@NotNull LighterASTNode node, int indexInParent) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$IndexedLighterASTNode", "<init>"));
            }
            this.node = node;
            this.indexInParent = indexInParent;
        }
    }
}

