/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.WeakHashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TObjectFunction;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStatusMap
implements Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.FileStatusMap");
    private final Project myProject;
    private final Map<Document, FileStatus> myDocumentToStatusMap;
    private volatile boolean myAllowDirt;
    private static final RangeMarker WHOLE_FILE_DIRTY_MARKER = new RangeMarker(){

        @Override
        @NotNull
        public Document getDocument() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getStartOffset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getEndOffset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void setGreedyToLeft(boolean greedy) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setGreedyToRight(boolean greedy) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isGreedyToRight() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isGreedyToLeft() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void dispose() {
        }

        @Override
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/daemon/impl/FileStatusMap$1", "getUserData"));
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/daemon/impl/FileStatusMap$1", "putUserData"));
            }
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "WHOLE_FILE";
        }
    };
    private static final ConcurrentMap<Thread, Integer> threads = new ConcurrentHashMap<Thread, Integer>();
    private static final StringBuilder log = new StringBuilder();
    private static final boolean IN_TESTS = ApplicationManager.getApplication().isUnitTestMode();

    public FileStatusMap(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "<init>"));
        }
        this.myDocumentToStatusMap = new WeakHashMap<Document, FileStatus>();
        this.myAllowDirt = true;
        this.myProject = project;
    }

    @Override
    public void dispose() {
        this.markAllFilesDirty("FileStatusMap dispose");
    }

    @Nullable(value="null means the file is clean")
    public static TextRange getDirtyTextRange(@NotNull Editor editor, int passId) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "getDirtyTextRange"));
        }
        Document document = editor.getDocument();
        FileStatusMap me = DaemonCodeAnalyzerEx.getInstanceEx(editor.getProject()).getFileStatusMap();
        TextRange dirtyScope = me.getFileDirtyScope(document, passId);
        if (dirtyScope == null) {
            return null;
        }
        TextRange documentRange = TextRange.from(0, document.getTextLength());
        return documentRange.intersection(dirtyScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorFoundFlag(@NotNull Project project, @NotNull Document document, boolean errorFound) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "setErrorFoundFlag"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "setErrorFoundFlag"));
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                if (!errorFound) {
                    return;
                }
                status = new FileStatus(project);
                this.myDocumentToStatusMap.put(document, status);
            }
            status.errorFound = errorFound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean wasErrorFound(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "wasErrorFound"));
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            return status != null && status.errorFound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAllFilesDirty(@NotNull @NonNls Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "markAllFilesDirty"));
        }
        this.assertAllowModifications();
        LOG.debug("Mark all dirty: ", reason);
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            this.myDocumentToStatusMap.clear();
        }
    }

    private void assertAllowModifications() {
        try {
            assert (this.myAllowDirt);
        }
        finally {
            this.myAllowDirt = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileUpToDate(@NotNull Document document, int passId) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "markFileUpToDate"));
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                status = new FileStatus(this.myProject);
                this.myDocumentToStatusMap.put(document, status);
            }
            status.defensivelyMarked = false;
            if (passId == 9) {
                status.wolfPassFinished = true;
            } else if (status.dirtyScopes.containsKey(passId)) {
                status.setDirtyScope(passId, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TextRange getFileDirtyScope(@NotNull Document document, int passId) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "getFileDirtyScope"));
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            PsiFile file = PsiDocumentManager.getInstance(this.myProject).getPsiFile(document);
            if (!ProblemHighlightFilter.shouldHighlightFile(file)) {
                return null;
            }
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                return file == null ? null : file.getTextRange();
            }
            if (status.defensivelyMarked) {
                status.markWholeFileDirty(this.myProject);
                status.defensivelyMarked = false;
            }
            LOG.assertTrue(status.dirtyScopes.containsKey(passId), "Unknown pass " + passId);
            RangeMarker marker = (RangeMarker)status.dirtyScopes.get(passId);
            return marker == null ? null : (marker.isValid() ? TextRange.create(marker) : new TextRange(0, document.getTextLength()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markFileScopeDirtyDefensively(@NotNull PsiFile file, @NotNull @NonNls Object reason) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "markFileScopeDirtyDefensively"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "markFileScopeDirtyDefensively"));
        }
        this.assertAllowModifications();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mark dirty file defensively: " + file.getName() + ": " + reason);
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            Document document = PsiDocumentManager.getInstance(this.myProject).getCachedDocument(file);
            if (document == null) {
                return;
            }
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                return;
            }
            status.defensivelyMarked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markFileScopeDirty(@NotNull Document document, @NotNull TextRange scope, int fileLength, @NotNull @NonNls Object reason) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "markFileScopeDirty"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "markFileScopeDirty"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "markFileScopeDirty"));
        }
        this.assertAllowModifications();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mark scope dirty: " + scope + " : " + reason);
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                return;
            }
            if (status.defensivelyMarked) {
                status.defensivelyMarked = false;
            }
            status.combineScopesWith(scope, fileLength, document);
        }
    }

    @NotNull
    private static RangeMarker combineScopes(RangeMarker old, @NotNull TextRange scope, int textLength, @NotNull Document document) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "combineScopes"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "combineScopes"));
        }
        if (old == null) {
            if (scope.equalsToRange(0, textLength)) {
                RangeMarker rangeMarker = WHOLE_FILE_DIRTY_MARKER;
                if (rangeMarker == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "combineScopes"));
                }
                return rangeMarker;
            }
            RangeMarker rangeMarker = document.createRangeMarker(scope);
            if (rangeMarker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "combineScopes"));
            }
            return rangeMarker;
        }
        if (old == WHOLE_FILE_DIRTY_MARKER) {
            RangeMarker rangeMarker = old;
            if (rangeMarker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "combineScopes"));
            }
            return rangeMarker;
        }
        TextRange oldRange = TextRange.create(old);
        TextRange union = scope.union(oldRange);
        if (old.isValid() && union.equals(oldRange)) {
            RangeMarker rangeMarker = old;
            if (rangeMarker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "combineScopes"));
            }
            return rangeMarker;
        }
        if (union.getEndOffset() > textLength) {
            union = union.intersection(new TextRange(0, textLength));
        }
        assert (union != null);
        RangeMarker rangeMarker = document.createRangeMarker(union);
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "combineScopes"));
        }
        return rangeMarker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean allDirtyScopesAreNull(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "allDirtyScopesAreNull"));
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            PsiFile file = PsiDocumentManager.getInstance(this.myProject).getPsiFile(document);
            if (!ProblemHighlightFilter.shouldHighlightFile(file)) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
            FileStatus status = this.myDocumentToStatusMap.get(document);
            return status != null && !status.defensivelyMarked && status.wolfPassFinished && status.allDirtyScopesAreNull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertAllDirtyScopesAreNull(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "assertAllDirtyScopesAreNull"));
        }
        Map<Document, FileStatus> map = this.myDocumentToStatusMap;
        synchronized (map) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            assert (status != null && !status.defensivelyMarked && status.wolfPassFinished && status.allDirtyScopesAreNull()) : status;
        }
    }

    void allowDirt(boolean allow) {
        this.myAllowDirt = allow;
    }

    private static int getThreadNum() {
        return ConcurrencyUtil.cacheOrGet(threads, Thread.currentThread(), threads.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(Object ... info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "log"));
        }
        if (IN_TESTS) {
            StringBuilder stringBuilder = log;
            synchronized (stringBuilder) {
                if (log.length() > 10000) {
                    log.replace(0, log.length() - 5000, "");
                }
                String s = StringUtil.repeatSymbol(' ', FileStatusMap.getThreadNum() * 4) + Arrays.asList(info) + "\n";
                log.append(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    static String getAndClearLog() {
        StringBuilder stringBuilder = log;
        // MONITORENTER : stringBuilder
        String l = log.toString();
        log.setLength(0);
        String string = l;
        // MONITOREXIT : stringBuilder
        if (string != null) return string;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/FileStatusMap", "getAndClearLog"));
    }

    private static class FileStatus {
        private boolean defensivelyMarked;
        private boolean wolfPassFinished;
        private final TIntObjectHashMap<RangeMarker> dirtyScopes;
        private boolean errorFound;

        private FileStatus(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/FileStatusMap$FileStatus", "<init>"));
            }
            this.dirtyScopes = new TIntObjectHashMap();
            this.markWholeFileDirty(project);
        }

        private void markWholeFileDirty(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/FileStatusMap$FileStatus", "markWholeFileDirty"));
            }
            this.setDirtyScope(4, WHOLE_FILE_DIRTY_MARKER);
            this.setDirtyScope(8, WHOLE_FILE_DIRTY_MARKER);
            this.setDirtyScope(7, WHOLE_FILE_DIRTY_MARKER);
            TextEditorHighlightingPassRegistrarEx registrar = (TextEditorHighlightingPassRegistrarEx)TextEditorHighlightingPassRegistrar.getInstance(project);
            for (DirtyScopeTrackingHighlightingPassFactory factory : registrar.getDirtyScopeTrackingFactories()) {
                this.setDirtyScope(factory.getPassId(), WHOLE_FILE_DIRTY_MARKER);
            }
        }

        private boolean allDirtyScopesAreNull() {
            for (Object o : this.dirtyScopes.getValues()) {
                if (o == null) continue;
                return false;
            }
            return true;
        }

        private void combineScopesWith(final @NotNull TextRange scope, final int fileLength, final @NotNull Document document) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInsight/daemon/impl/FileStatusMap$FileStatus", "combineScopesWith"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/FileStatusMap$FileStatus", "combineScopesWith"));
            }
            this.dirtyScopes.transformValues((TObjectFunction)new TObjectFunction<RangeMarker, RangeMarker>(){

                public RangeMarker execute(RangeMarker oldScope) {
                    RangeMarker newScope = FileStatusMap.combineScopes(oldScope, scope, fileLength, document);
                    if (newScope != oldScope && oldScope != null) {
                        oldScope.dispose();
                    }
                    return newScope;
                }
            });
        }

        public String toString() {
            final StringBuilder s = new StringBuilder();
            s.append("defensivelyMarked = ").append(this.defensivelyMarked);
            s.append("; wolfPassFinfished = ").append(this.wolfPassFinished);
            s.append("; errorFound = ").append(this.errorFound);
            s.append("; dirtyScopes: (");
            this.dirtyScopes.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<RangeMarker>(){

                public boolean execute(int passId, RangeMarker rangeMarker) {
                    s.append(" pass: ").append(passId).append(" -> ").append(rangeMarker == WHOLE_FILE_DIRTY_MARKER ? "Whole file" : rangeMarker).append(";");
                    return true;
                }
            });
            s.append(")");
            return s.toString();
        }

        private void setDirtyScope(int passId, RangeMarker scope) {
            RangeMarker marker = (RangeMarker)this.dirtyScopes.get(passId);
            if (marker != scope) {
                if (marker != null) {
                    marker.dispose();
                }
                this.dirtyScopes.put(passId, (Object)scope);
            }
        }
    }
}

