/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleLoadingErrorDescription;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleManagerImpl
extends ModuleManager
implements ProjectComponent,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.module.impl.ModuleManagerImpl");
    static final Key<String> DISPOSED_MODULE_NAME = Key.create("DisposedNeverAddedModuleName");
    private static final String IML_EXTENSION = ".iml";
    protected final Project myProject;
    protected final MessageBus myMessageBus;
    protected volatile ModuleModelImpl myModuleModel = new ModuleModelImpl();
    @NonNls
    public static final String COMPONENT_NAME = "ProjectModuleManager";
    private static final String MODULE_GROUP_SEPARATOR = "/";
    private List<ModulePath> myModulePaths;
    private final List<ModulePath> myFailedModulePaths = new ArrayList<ModulePath>();
    @NonNls
    public static final String ELEMENT_MODULES = "modules";
    @NonNls
    public static final String ELEMENT_MODULE = "module";
    @NonNls
    private static final String ATTRIBUTE_FILEURL = "fileurl";
    @NonNls
    public static final String ATTRIBUTE_FILEPATH = "filepath";
    @NonNls
    private static final String ATTRIBUTE_GROUP = "group";
    private volatile Module[] myCachedSortedModules;
    private volatile Comparator<Module> myCachedModuleComparator;

    public static ModuleManagerImpl getInstanceImpl(Project project) {
        return (ModuleManagerImpl)ModuleManagerImpl.getInstance(project);
    }

    public ModuleManagerImpl(Project project, MessageBus messageBus) {
        this.myProject = project;
        this.myMessageBus = messageBus;
    }

    protected void cleanCachedStuff() {
        this.myCachedModuleComparator = null;
        this.myCachedSortedModules = null;
    }

    @Override
    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getComponentName"));
        }
        return COMPONENT_NAME;
    }

    @Override
    public void initComponent() {
    }

    @Override
    public void disposeComponent() {
        this.myModuleModel.disposeModel();
    }

    @Override
    public Element getState() {
        Element e = new Element("state");
        this.writeExternal(e);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadState(Element state) {
        List<ModulePath> prevPaths = this.myModulePaths;
        this.readExternal(state);
        if (prevPaths != null) {
            ModifiableModuleModel model = this.getModifiableModel();
            Module[] existingModules = model.getModules();
            ModuleGroupInterner groupInterner = new ModuleGroupInterner();
            for (Module existingModule : existingModules) {
                Object[] group;
                ModulePath correspondingPath = this.findCorrespondingPath(existingModule);
                if (correspondingPath == null) {
                    model.disposeModule(existingModule);
                    continue;
                }
                this.myModulePaths.remove(correspondingPath);
                String groupStr = correspondingPath.getModuleGroup();
                Object[] objectArray = group = groupStr == null ? null : groupStr.split(MODULE_GROUP_SEPARATOR);
                if (Arrays.equals(group, model.getModuleGroupPath(existingModule))) continue;
                groupInterner.setModuleGroupPath(model, existingModule, (String[])group);
            }
            this.loadModules((ModuleModelImpl)model);
            AccessToken token = WriteAction.start();
            try {
                model.commit();
            }
            finally {
                token.finish();
            }
        }
    }

    private ModulePath findCorrespondingPath(@NotNull Module existingModule) {
        if (existingModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingModule", "com/intellij/openapi/module/impl/ModuleManagerImpl", "findCorrespondingPath"));
        }
        for (ModulePath modulePath : this.myModulePaths) {
            if (!modulePath.getPath().equals(existingModule.getModuleFilePath())) continue;
            return modulePath;
        }
        return null;
    }

    @NotNull
    public static ModulePath[] getPathsToModuleFiles(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getPathsToModuleFiles"));
        }
        ArrayList<ModulePath> paths = new ArrayList<ModulePath>();
        Element modules = element.getChild(ELEMENT_MODULES);
        if (modules != null) {
            for (Object value : modules.getChildren(ELEMENT_MODULE)) {
                Element moduleElement = (Element)value;
                String fileUrlValue = moduleElement.getAttributeValue(ATTRIBUTE_FILEURL);
                String filepath = fileUrlValue != null ? VirtualFileManager.extractPath(fileUrlValue).replace('/', File.separatorChar) : moduleElement.getAttributeValue(ATTRIBUTE_FILEPATH).replace('/', File.separatorChar);
                String group = moduleElement.getAttributeValue(ATTRIBUTE_GROUP);
                paths.add(new ModulePath(filepath, group));
            }
        }
        ModulePath[] modulePathArray = paths.toArray(new ModulePath[paths.size()]);
        if (modulePathArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getPathsToModuleFiles"));
        }
        return modulePathArray;
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/module/impl/ModuleManagerImpl", "readExternal"));
        }
        this.myModulePaths = new ArrayList<ModulePath>(Arrays.asList(ModuleManagerImpl.getPathsToModuleFiles(element)));
    }

    protected void loadModules(@NotNull ModuleModelImpl moduleModel) {
        ProgressIndicator progressIndicator;
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/openapi/module/impl/ModuleManagerImpl", "loadModules"));
        }
        if (this.myModulePaths == null || this.myModulePaths.isEmpty()) {
            return;
        }
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        ProgressIndicator progressIndicator2 = progressIndicator = this.myProject.isDefault() ? null : ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText("Loading modules...");
            progressIndicator.setText2("");
        }
        this.myFailedModulePaths.clear();
        this.myFailedModulePaths.addAll(this.myModulePaths);
        ArrayList<Module> modulesWithUnknownTypes = new ArrayList<Module>();
        ArrayList<ModuleLoadingErrorDescription> errors = new ArrayList<ModuleLoadingErrorDescription>();
        for (int i = 0; i < this.myModulePaths.size(); ++i) {
            ModulePath modulePath = this.myModulePaths.get(i);
            if (progressIndicator != null) {
                progressIndicator.setFraction((double)i / (double)this.myModulePaths.size());
            }
            try {
                String groupPathString;
                Module module = moduleModel.loadModuleInternal(modulePath.getPath());
                if (this.isUnknownModuleType(module)) {
                    modulesWithUnknownTypes.add(module);
                }
                if ((groupPathString = modulePath.getModuleGroup()) != null) {
                    String[] groupPath = groupPathString.split(MODULE_GROUP_SEPARATOR);
                    groupInterner.setModuleGroupPath(moduleModel, module, groupPath);
                }
                this.myFailedModulePaths.remove(modulePath);
                continue;
            }
            catch (IOException e) {
                errors.add(ModuleLoadingErrorDescription.create(ProjectBundle.message("module.cannot.load.error", modulePath.getPath(), e.getMessage()), modulePath, this));
                continue;
            }
            catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                errors.add(ModuleLoadingErrorDescription.create(moduleWithNameAlreadyExists.getMessage(), modulePath, this));
            }
        }
        this.onModuleLoadErrors(errors);
        this.showUnknownModuleTypeNotification(modulesWithUnknownTypes);
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
    }

    protected boolean isUnknownModuleType(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "isUnknownModuleType"));
        }
        return false;
    }

    protected void showUnknownModuleTypeNotification(@NotNull List<Module> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/openapi/module/impl/ModuleManagerImpl", "showUnknownModuleTypeNotification"));
        }
    }

    protected void fireModuleAdded(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleAdded"));
        }
        this.myMessageBus.syncPublisher(ProjectTopics.MODULES).moduleAdded(this.myProject, module);
    }

    protected void fireModuleRemoved(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleRemoved"));
        }
        this.myMessageBus.syncPublisher(ProjectTopics.MODULES).moduleRemoved(this.myProject, module);
    }

    protected void fireBeforeModuleRemoved(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireBeforeModuleRemoved"));
        }
        this.myMessageBus.syncPublisher(ProjectTopics.MODULES).beforeModuleRemoved(this.myProject, module);
    }

    protected void fireModulesRenamed(@NotNull List<Module> modules, final @NotNull Map<Module, String> oldNames) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULES, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModulesRenamed"));
        }
        if (oldNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNames", "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModulesRenamed"));
        }
        if (!modules.isEmpty()) {
            this.myMessageBus.syncPublisher(ProjectTopics.MODULES).modulesRenamed(this.myProject, modules, new Function<Module, String>(){

                @Override
                public String fun(Module module) {
                    return (String)oldNames.get(module);
                }
            });
        }
    }

    protected void onModuleLoadErrors(@NotNull List<ModuleLoadingErrorDescription> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/openapi/module/impl/ModuleManagerImpl", "onModuleLoadErrors"));
        }
        if (errors.isEmpty()) {
            return;
        }
        ModuleModelImpl.access$502(this.myModuleModel, null);
        for (ModuleLoadingErrorDescription error : errors) {
            final ModuleEx module = this.myModuleModel.getModuleByFilePath(FileUtil.toSystemIndependentName(error.getModulePath().getPath()));
            if (module == null) continue;
            this.myModuleModel.myModules.remove(module);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Disposer.dispose(module);
                }
            });
        }
        this.fireModuleLoadErrors(errors);
    }

    protected void fireModuleLoadErrors(@NotNull List<ModuleLoadingErrorDescription> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleLoadErrors"));
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            throw new RuntimeException(errors.get(0).getDescription());
        }
        ProjectLoadingErrorsNotifier.getInstance(this.myProject).registerErrors(errors);
    }

    public void removeFailedModulePath(@NotNull ModulePath modulePath) {
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/intellij/openapi/module/impl/ModuleManagerImpl", "removeFailedModulePath"));
        }
        this.myFailedModulePaths.remove(modulePath);
    }

    @Override
    @NotNull
    public ModifiableModuleModel getModifiableModel() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ModuleModelImpl moduleModelImpl = new ModuleModelImpl(this.myModuleModel);
        if (moduleModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModifiableModel"));
        }
        return moduleModelImpl;
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/module/impl/ModuleManagerImpl", "writeExternal"));
        }
        Module[] collection = this.getModules();
        ArrayList<SaveItem> sorted = new ArrayList<SaveItem>(collection.length + this.myFailedModulePaths.size());
        for (Module module : collection) {
            sorted.add(new ModuleSaveItem(module));
        }
        for (ModulePath modulePath : this.myFailedModulePaths) {
            sorted.add(new ModulePathSaveItem(modulePath));
        }
        if (!sorted.isEmpty()) {
            Collections.sort(sorted, new Comparator<SaveItem>(){

                @Override
                public int compare(SaveItem item1, SaveItem item2) {
                    return item1.getModuleName().compareTo(item2.getModuleName());
                }
            });
            Element modules = new Element(ELEMENT_MODULES);
            for (SaveItem saveItem : sorted) {
                saveItem.writeExternal(modules);
            }
            element.addContent(modules);
        }
    }

    @Override
    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl", "newModule"));
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.newModule(filePath, moduleTypeId);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "newModule"));
        }
        return module2;
    }

    @Override
    @NotNull
    public Module loadModule(@NotNull String filePath) throws IOException, JDOMException, ModuleWithNameAlreadyExists {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl", "loadModule"));
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.loadModule(filePath);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "loadModule"));
        }
        return module2;
    }

    @Override
    public void disposeModule(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "disposeModule"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ModifiableModuleModel modifiableModel = ModuleManagerImpl.this.getModifiableModel();
                modifiableModel.disposeModule(module);
                modifiableModel.commit();
            }
        });
    }

    @Override
    @NotNull
    public Module[] getModules() {
        if (this.myModuleModel.myIsWritable) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        Module[] moduleArray = this.myModuleModel.getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModules"));
        }
        return moduleArray;
    }

    @Override
    @NotNull
    public Module[] getSortedModules() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        if (this.myCachedSortedModules == null) {
            this.myCachedSortedModules = this.myModuleModel.getSortedModules();
        }
        if (this.myCachedSortedModules == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getSortedModules"));
        }
        return this.myCachedSortedModules;
    }

    @Override
    public Module findModuleByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/module/impl/ModuleManagerImpl", "findModuleByName"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.myModuleModel.findModuleByName(name);
    }

    @Override
    @NotNull
    public Comparator<Module> moduleDependencyComparator() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        if (this.myCachedModuleComparator == null) {
            this.myCachedModuleComparator = this.myModuleModel.moduleDependencyComparator();
        }
        Comparator<Module> comparator = this.myCachedModuleComparator;
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "moduleDependencyComparator"));
        }
        return comparator;
    }

    protected void deliverPendingEvents() {
    }

    @Override
    @NotNull
    public Graph<Module> moduleGraph() {
        Graph<Module> graph = this.moduleGraph(true);
        if (graph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "moduleGraph"));
        }
        return graph;
    }

    @Override
    @NotNull
    public Graph<Module> moduleGraph(boolean includeTests) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Graph graph = this.myModuleModel.moduleGraph(includeTests);
        if (graph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "moduleGraph"));
        }
        return graph;
    }

    @Override
    @NotNull
    public List<Module> getModuleDependentModules(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModuleDependentModules"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        List list = this.myModuleModel.getModuleDependentModules(module);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModuleDependentModules"));
        }
        return list;
    }

    @Override
    public boolean isModuleDependent(@NotNull Module module, @NotNull Module onModule) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "isModuleDependent"));
        }
        if (onModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onModule", "com/intellij/openapi/module/impl/ModuleManagerImpl", "isModuleDependent"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.myModuleModel.isModuleDependent(module, onModule);
    }

    @Override
    public void projectOpened() {
        this.fireModulesAdded();
        this.myModuleModel.projectOpened();
    }

    protected void fireModulesAdded() {
        for (Module module : this.myModuleModel.myModules) {
            this.fireModuleAddedInWriteAction(module);
        }
    }

    protected void fireModuleAddedInWriteAction(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleAddedInWriteAction"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ((ModuleEx)module).moduleAdded();
                ModuleManagerImpl.this.fireModuleAdded(module);
            }
        });
    }

    @Override
    public void projectClosed() {
        this.myModuleModel.projectClosed();
    }

    public static void commitModelWithRunnable(@NotNull ModifiableModuleModel model, Runnable runnable) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/module/impl/ModuleManagerImpl", "commitModelWithRunnable"));
        }
        ((ModuleModelImpl)model).commitWithRunnable(runnable);
    }

    @NotNull
    protected abstract ModuleEx createModule(@NotNull String var1);

    @NotNull
    protected abstract ModuleEx createAndLoadModule(@NotNull String var1) throws IOException;

    private void commitModel(final ModuleModelImpl moduleModel, final Runnable runnable) {
        ModuleModelImpl.access$502(this.myModuleModel, null);
        this.incModificationCount();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Set<Module> oldModules = this.myModuleModel.myModules;
        Set<Module> newModules = moduleModel.myModules;
        final ArrayList<Module> removedModules = new ArrayList<Module>(oldModules);
        removedModules.removeAll(newModules);
        final ArrayList<Module> addedModules = new ArrayList<Module>(newModules);
        addedModules.removeAll(oldModules);
        ProjectRootManagerEx.getInstanceEx(this.myProject).makeRootsChange(new Runnable(){

            @Override
            public void run() {
                for (Object removedModule : removedModules) {
                    ModuleManagerImpl.this.fireBeforeModuleRemoved((Module)removedModule);
                    ModuleManagerImpl.this.cleanCachedStuff();
                }
                ArrayList neverAddedModules = new ArrayList(moduleModel.myModulesToDispose);
                neverAddedModules.removeAll(ModuleManagerImpl.this.myModuleModel.myModules);
                for (Module neverAddedModule : neverAddedModules) {
                    neverAddedModule.putUserData(DISPOSED_MODULE_NAME, neverAddedModule.getName());
                    Disposer.dispose(neverAddedModule);
                }
                if (runnable != null) {
                    runnable.run();
                }
                Map modulesToNewNamesMap = moduleModel.myModuleToNewName;
                Set modulesToBeRenamed = modulesToNewNamesMap.keySet();
                modulesToBeRenamed.removeAll(moduleModel.myModulesToDispose);
                ArrayList<Module> modules = new ArrayList<Module>();
                HashMap<Module, String> oldNames = ContainerUtil.newHashMap();
                for (Module module : modulesToBeRenamed) {
                    oldNames.put(module, module.getName());
                    moduleModel.myModules.remove(module);
                    modules.add(module);
                    ((ModuleEx)module).rename((String)modulesToNewNamesMap.get(module));
                    moduleModel.myModules.add(module);
                }
                moduleModel.myIsWritable = false;
                ModuleManagerImpl.this.myModuleModel = moduleModel;
                for (Module module : removedModules) {
                    ModuleManagerImpl.this.fireModuleRemoved(module);
                    ModuleManagerImpl.this.cleanCachedStuff();
                    Disposer.dispose(module);
                    ModuleManagerImpl.this.cleanCachedStuff();
                }
                for (Module addedModule : addedModules) {
                    ((ModuleEx)addedModule).moduleAdded();
                    ModuleManagerImpl.this.cleanCachedStuff();
                    ModuleManagerImpl.this.fireModuleAdded(addedModule);
                    ModuleManagerImpl.this.cleanCachedStuff();
                }
                ModuleManagerImpl.this.cleanCachedStuff();
                ModuleManagerImpl.this.fireModulesRenamed(modules, oldNames);
                ModuleManagerImpl.this.cleanCachedStuff();
            }
        }, false, true);
    }

    public void fireModuleRenamedByVfsEvent(final @NotNull Module module, final @NotNull String oldName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleRenamedByVfsEvent"));
        }
        if (oldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleRenamedByVfsEvent"));
        }
        ProjectRootManagerEx.getInstanceEx(this.myProject).makeRootsChange(new Runnable(){

            @Override
            public void run() {
                ModuleManagerImpl.this.fireModulesRenamed(Collections.singletonList(module), Collections.singletonMap(module, oldName));
            }
        }, false, true);
    }

    @Override
    public String[] getModuleGroupPath(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModuleGroupPath"));
        }
        return this.myModuleModel.getModuleGroupPath(module);
    }

    public void setModuleGroupPath(Module module, String[] groupPath) {
        this.myModuleModel.setModuleGroupPath(module, groupPath);
    }

    class ModuleModelImpl
    implements ModifiableModuleModel {
        final Set<Module> myModules;
        private volatile Module[] myModulesCache;
        private final List<Module> myModulesToDispose;
        private final Map<Module, String> myModuleToNewName;
        private final Map<String, Module> myNewNameToModule;
        private boolean myIsWritable;
        private Map<Module, String[]> myModuleGroupPath;

        private ModuleModelImpl() {
            this.myModules = new LinkedHashSet<Module>();
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new com.intellij.util.containers.HashMap<Module, String>();
            this.myNewNameToModule = new com.intellij.util.containers.HashMap<String, Module>();
            this.myIsWritable = false;
        }

        private ModuleModelImpl(ModuleModelImpl that) {
            if (that == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "<init>"));
            }
            this.myModules = new LinkedHashSet<Module>();
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new com.intellij.util.containers.HashMap<Module, String>();
            this.myNewNameToModule = new com.intellij.util.containers.HashMap<String, Module>();
            this.myModules.addAll(that.myModules);
            Map<Module, String[]> groupPath = that.myModuleGroupPath;
            if (groupPath != null) {
                this.myModuleGroupPath = new THashMap();
                this.myModuleGroupPath.putAll(that.myModuleGroupPath);
            }
            this.myIsWritable = true;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myIsWritable, "Attempt to modify committed ModifiableModuleModel");
        }

        @Override
        @NotNull
        public Module[] getModules() {
            if (this.myModulesCache == null) {
                Set<Module> modules = this.myModules;
                this.myModulesCache = modules.toArray(new Module[modules.size()]);
            }
            if (this.myModulesCache == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModules"));
            }
            return this.myModulesCache;
        }

        @NotNull
        private Module[] getSortedModules() {
            Module[] allModules = (Module[])this.getModules().clone();
            Arrays.sort(allModules, this.moduleDependencyComparator());
            if (allModules == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getSortedModules"));
            }
            return allModules;
        }

        @Override
        public void renameModule(@NotNull Module module, @NotNull String newName) throws ModuleWithNameAlreadyExists {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "renameModule"));
            }
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "renameModule"));
            }
            Module oldModule = this.getModuleByNewName(newName);
            this.myNewNameToModule.remove(this.myModuleToNewName.get(module));
            if (module.getName().equals(newName)) {
                this.myModuleToNewName.remove(module);
                this.myNewNameToModule.remove(newName);
            } else {
                this.myModuleToNewName.put(module, newName);
                this.myNewNameToModule.put(newName, module);
            }
            if (oldModule != null) {
                throw new ModuleWithNameAlreadyExists(ProjectBundle.message("module.already.exists.error", newName), newName);
            }
        }

        @Override
        public Module getModuleToBeRenamed(@NotNull String newName) {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModuleToBeRenamed"));
            }
            return this.myNewNameToModule.get(newName);
        }

        private Module getModuleByNewName(@NotNull String newName) {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModuleByNewName"));
            }
            Module moduleToBeRenamed = this.getModuleToBeRenamed(newName);
            if (moduleToBeRenamed != null) {
                return moduleToBeRenamed;
            }
            Module moduleWithOldName = this.findModuleByName(newName);
            return this.myModuleToNewName.get(moduleWithOldName) == null ? moduleWithOldName : null;
        }

        @Override
        public String getNewName(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getNewName"));
            }
            return this.myModuleToNewName.get(module);
        }

        @Override
        @NotNull
        public Module newModule(@NotNull String filePath, String moduleTypeId) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            Module module = this.newModule(filePath, moduleTypeId, null);
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            return module;
        }

        @Override
        @NotNull
        public Module newModule(@NotNull String filePath, final @NotNull String moduleTypeId, final @Nullable Map<String, String> options) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            if (moduleTypeId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleTypeId", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            this.assertWritable();
            filePath = FileUtil.toSystemIndependentName(this.resolveShortWindowsName(filePath));
            ModuleEx module = this.getModuleByFilePath(filePath);
            if (module == null) {
                final ModuleEx newModule = module = ModuleManagerImpl.this.createModule(filePath);
                this.initModule(module, filePath, new Runnable(){

                    @Override
                    public void run() {
                        newModule.setOption("type", moduleTypeId);
                        if (options != null) {
                            for (Map.Entry option : options.entrySet()) {
                                newModule.setOption((String)option.getKey(), (String)option.getValue());
                            }
                        }
                    }
                });
            }
            ModuleEx moduleEx = module;
            if (moduleEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            return moduleEx;
        }

        @NotNull
        private String resolveShortWindowsName(@NotNull String filePath) {
            String string;
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "resolveShortWindowsName"));
            }
            try {
                string = FileUtil.resolveShortWindowsName(filePath);
            }
            catch (IOException ignored) {
                String string2 = filePath;
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "resolveShortWindowsName"));
                }
                return string2;
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "resolveShortWindowsName"));
            }
            return string;
        }

        @Nullable
        private ModuleEx getModuleByFilePath(@NotNull String filePath) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModuleByFilePath"));
            }
            for (Module module : this.myModules) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? module.getModuleFilePath().equals(filePath) : module.getModuleFilePath().equalsIgnoreCase(filePath))) continue;
                return (ModuleEx)module;
            }
            return null;
        }

        @Override
        @NotNull
        public Module loadModule(@NotNull String filePath) throws IOException, ModuleWithNameAlreadyExists {
            Module module;
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModule"));
            }
            this.assertWritable();
            try {
                module = this.loadModuleInternal(filePath);
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IOException(ProjectBundle.message("module.corrupted.file.error", FileUtil.toSystemDependentName(filePath), e.getMessage()), e);
            }
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModule"));
            }
            return module;
        }

        @NotNull
        private Module loadModuleInternal(@NotNull String filePath) throws ModuleWithNameAlreadyExists, IOException {
            String path;
            ModuleEx module;
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModuleInternal"));
            }
            filePath = this.resolveShortWindowsName(filePath);
            final VirtualFile moduleFile = StandardFileSystems.local().findFileByPath(filePath);
            if (moduleFile == null || !moduleFile.exists()) {
                throw new FileNotFoundException(ProjectBundle.message("module.file.does.not.exist.error", filePath));
            }
            String name = moduleFile.getName();
            if (name.endsWith(ModuleManagerImpl.IML_EXTENSION)) {
                String moduleName = name.substring(0, name.length() - 4);
                for (Module module2 : this.myModules) {
                    if (!module2.getName().equals(moduleName)) continue;
                    throw new ModuleWithNameAlreadyExists(ProjectBundle.message("module.already.exists.error", moduleName), moduleName);
                }
            }
            if ((module = this.getModuleByFilePath(path = moduleFile.getPath())) == null) {
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        moduleFile.refresh(false, false);
                    }
                }, ModalityState.any());
                module = ModuleManagerImpl.this.createAndLoadModule(path);
                this.initModule(module, path, null);
            }
            ModuleEx moduleEx = module;
            if (moduleEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModuleInternal"));
            }
            return moduleEx;
        }

        private void initModule(@NotNull ModuleEx module, @NotNull String path, @Nullable Runnable beforeComponentCreation) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "initModule"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "initModule"));
            }
            module.init(path, beforeComponentCreation);
            this.myModulesCache = null;
            this.myModules.add(module);
        }

        @Override
        public void disposeModule(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "disposeModule"));
            }
            this.assertWritable();
            this.myModulesCache = null;
            if (this.myModules.remove(module)) {
                this.myModulesToDispose.add(module);
            }
            if (this.myModuleGroupPath != null) {
                this.myModuleGroupPath.remove(module);
            }
        }

        @Override
        public Module findModuleByName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "findModuleByName"));
            }
            for (Module module : this.myModules) {
                if (module.isDisposed() || !module.getName().equals(name)) continue;
                return module;
            }
            return null;
        }

        private Comparator<Module> moduleDependencyComparator() {
            DFSTBuilder<Module> builder = new DFSTBuilder<Module>(this.moduleGraph(true));
            return builder.comparator();
        }

        private Graph<Module> moduleGraph(final boolean includeTests) {
            return GraphGenerator.create(CachingSemiGraph.create(new GraphGenerator.SemiGraph<Module>(){

                @Override
                public Collection<Module> getNodes() {
                    return ModuleModelImpl.this.myModules;
                }

                @Override
                public Iterator<Module> getIn(Module m) {
                    Module[] dependentModules = ModuleRootManager.getInstance(m).getDependencies(includeTests);
                    return Arrays.asList(dependentModules).iterator();
                }
            }));
        }

        @NotNull
        private List<Module> getModuleDependentModules(Module module) {
            ArrayList<Module> result = new ArrayList<Module>();
            for (Module aModule : this.myModules) {
                if (!this.isModuleDependent(aModule, module)) continue;
                result.add(aModule);
            }
            ArrayList<Module> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModuleDependentModules"));
            }
            return arrayList;
        }

        private boolean isModuleDependent(Module module, Module onModule) {
            return ModuleRootManager.getInstance(module).isDependsOn(onModule);
        }

        @Override
        public void commit() {
            ModifiableRootModel[] rootModels = new ModifiableRootModel[]{};
            ModifiableModelCommitter.multiCommit(rootModels, (ModifiableModuleModel)this);
        }

        private void commitWithRunnable(Runnable runnable) {
            ModuleManagerImpl.this.commitModel(this, runnable);
            this.clearRenamingStuff();
        }

        private void clearRenamingStuff() {
            this.myModuleToNewName.clear();
            this.myNewNameToModule.clear();
        }

        @Override
        public void dispose() {
            this.assertWritable();
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            Set<Module> list = ModuleManagerImpl.this.myModuleModel.myModules;
            Set<Module> thisModules = this.myModules;
            for (Module thisModule : thisModules) {
                if (list.contains(thisModule)) continue;
                Disposer.dispose(thisModule);
            }
            for (Module moduleToDispose : this.myModulesToDispose) {
                if (list.contains(moduleToDispose)) continue;
                Disposer.dispose(moduleToDispose);
            }
            this.clearRenamingStuff();
        }

        @Override
        public boolean isChanged() {
            if (!this.myIsWritable) {
                return false;
            }
            return !this.myModules.equals(ModuleManagerImpl.this.myModuleModel.myModules) || !Comparing.equal(ModuleManagerImpl.this.myModuleModel.myModuleGroupPath, this.myModuleGroupPath);
        }

        private void disposeModel() {
            this.myModulesCache = null;
            for (Module module : this.myModules) {
                Disposer.dispose(module);
            }
            this.myModules.clear();
            this.myModuleGroupPath = null;
        }

        public void projectOpened() {
            Set<Module> collection = this.myModules;
            for (Module aCollection : collection) {
                ModuleEx module = (ModuleEx)aCollection;
                module.projectOpened();
            }
        }

        public void projectClosed() {
            for (Module aCollection : this.myModules) {
                ModuleEx module = (ModuleEx)aCollection;
                module.projectClosed();
            }
        }

        @Override
        public String[] getModuleGroupPath(Module module) {
            return this.myModuleGroupPath == null ? null : this.myModuleGroupPath.get(module);
        }

        @Override
        public boolean hasModuleGroups() {
            return this.myModuleGroupPath != null && !this.myModuleGroupPath.isEmpty();
        }

        @Override
        public void setModuleGroupPath(@NotNull Module module, @Nullable(value="null means remove") String[] groupPath) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "setModuleGroupPath"));
            }
            if (this.myModuleGroupPath == null) {
                this.myModuleGroupPath = new THashMap();
            }
            if (groupPath == null) {
                this.myModuleGroupPath.remove(module);
            } else {
                this.myModuleGroupPath.put(module, groupPath);
            }
        }

        static /* synthetic */ Module[] access$502(ModuleModelImpl x0, Module[] x1) {
            x0.myModulesCache = x1;
            return x1;
        }
    }

    private static class ModulePathSaveItem
    extends SaveItem {
        private final ModulePath myModulePath;
        private final String myFilePath;
        private final String myName;

        private ModulePathSaveItem(@NotNull ModulePath modulePath) {
            if (modulePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModulePathSaveItem", "<init>"));
            }
            this.myModulePath = modulePath;
            this.myFilePath = modulePath.getPath().replace(File.separatorChar, '/');
            int slashIndex = this.myFilePath.lastIndexOf(47);
            int startIndex = slashIndex >= 0 && slashIndex + 1 < this.myFilePath.length() ? slashIndex + 1 : 0;
            int endIndex = this.myFilePath.endsWith(ModuleManagerImpl.IML_EXTENSION) ? this.myFilePath.length() - ModuleManagerImpl.IML_EXTENSION.length() : this.myFilePath.length();
            this.myName = this.myFilePath.substring(startIndex, endIndex);
        }

        @Override
        @NotNull
        protected String getModuleName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModulePathSaveItem", "getModuleName"));
            }
            return string;
        }

        @Override
        protected String getGroupPathString() {
            return this.myModulePath.getModuleGroup();
        }

        @Override
        @NotNull
        protected String getModuleFilePath() {
            String string = this.myFilePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModulePathSaveItem", "getModuleFilePath"));
            }
            return string;
        }
    }

    private class ModuleSaveItem
    extends SaveItem {
        private final Module myModule;

        public ModuleSaveItem(Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem", "<init>"));
            }
            this.myModule = module;
        }

        @Override
        @NotNull
        protected String getModuleName() {
            String string = this.myModule.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem", "getModuleName"));
            }
            return string;
        }

        @Override
        protected String getGroupPathString() {
            String[] groupPath = ModuleManagerImpl.this.getModuleGroupPath(this.myModule);
            return groupPath != null ? StringUtil.join(groupPath, ModuleManagerImpl.MODULE_GROUP_SEPARATOR) : null;
        }

        @Override
        @NotNull
        protected String getModuleFilePath() {
            String string = this.myModule.getModuleFilePath().replace(File.separatorChar, '/');
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem", "getModuleFilePath"));
            }
            return string;
        }
    }

    private static abstract class SaveItem {
        private SaveItem() {
        }

        @NotNull
        protected abstract String getModuleName();

        protected abstract String getGroupPathString();

        @NotNull
        protected abstract String getModuleFilePath();

        public final void writeExternal(@NotNull Element parentElement) {
            if (parentElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentElement", "com/intellij/openapi/module/impl/ModuleManagerImpl$SaveItem", "writeExternal"));
            }
            Element moduleElement = new Element(ModuleManagerImpl.ELEMENT_MODULE);
            String moduleFilePath = this.getModuleFilePath();
            String url = VirtualFileManager.constructUrl("file", moduleFilePath);
            moduleElement.setAttribute(ModuleManagerImpl.ATTRIBUTE_FILEURL, url);
            moduleElement.setAttribute(ModuleManagerImpl.ATTRIBUTE_FILEPATH, moduleFilePath);
            String groupPath = this.getGroupPathString();
            if (groupPath != null) {
                moduleElement.setAttribute(ModuleManagerImpl.ATTRIBUTE_GROUP, groupPath);
            }
            parentElement.addContent(moduleElement);
        }
    }

    public static final class ModulePath {
        private final String myPath;
        private final String myModuleGroup;

        public ModulePath(String path, String moduleGroup) {
            this.myPath = path;
            this.myModuleGroup = moduleGroup;
        }

        public String getPath() {
            return this.myPath;
        }

        public String getModuleGroup() {
            return this.myModuleGroup;
        }
    }

    private static class ModuleGroupInterner {
        private final StringInterner groups = new StringInterner();
        private final Map<String[], String[]> paths = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<String[]>(){

            public int computeHashCode(String[] object) {
                return Arrays.hashCode(object);
            }

            public boolean equals(String[] o1, String[] o2) {
                return Arrays.equals(o1, o2);
            }
        });

        private ModuleGroupInterner() {
        }

        private void setModuleGroupPath(@NotNull ModifiableModuleModel model, @NotNull Module module, @Nullable String[] group) {
            String[] cached;
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleGroupInterner", "setModuleGroupPath"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleGroupInterner", "setModuleGroupPath"));
            }
            String[] stringArray = cached = group == null ? null : this.paths.get(group);
            if (cached == null && group != null) {
                cached = new String[group.length];
                for (int i = 0; i < group.length; ++i) {
                    String g = group[i];
                    cached[i] = this.groups.intern(g);
                }
                this.paths.put(cached, cached);
            }
            model.setModuleGroupPath(module, cached);
        }
    }
}

