/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.ProjectRootListener;
import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.projectRoots.ex.ProjectRootContainer;
import com.intellij.openapi.projectRoots.impl.CompositeProjectRoot;
import com.intellij.openapi.projectRoots.impl.ProjectRootUtil;
import com.intellij.openapi.projectRoots.impl.SimpleProjectRoot;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.vfs.JarCopyingFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ProjectRootContainerImpl
implements JDOMExternalizable,
ProjectRootContainer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.projectRoots.impl.ProjectRootContainerImpl");
    private final Map<OrderRootType, CompositeProjectRoot> myRoots = new HashMap<OrderRootType, CompositeProjectRoot>();
    private Map<OrderRootType, VirtualFile[]> myFiles = new HashMap<OrderRootType, VirtualFile[]>();
    private boolean myInsideChange = false;
    private final List<ProjectRootListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myNoCopyJars = false;

    public ProjectRootContainerImpl(boolean noCopyJars) {
        this.myNoCopyJars = noCopyJars;
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            this.myRoots.put(rootType, new CompositeProjectRoot());
            this.myFiles.put(rootType, VirtualFile.EMPTY_ARRAY);
        }
    }

    @Override
    @NotNull
    public VirtualFile[] getRootFiles(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "getRootFiles"));
        }
        VirtualFile[] virtualFileArray = this.myFiles.get(type);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "getRootFiles"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public ProjectRoot[] getRoots(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "getRoots"));
        }
        ProjectRoot[] projectRootArray = this.myRoots.get(type).getProjectRoots();
        if (projectRootArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "getRoots"));
        }
        return projectRootArray;
    }

    @Override
    public void startChange() {
        LOG.assertTrue(!this.myInsideChange);
        this.myInsideChange = true;
    }

    @Override
    public void finishChange() {
        LOG.assertTrue(this.myInsideChange);
        HashMap oldRoots = new HashMap(this.myFiles);
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            VirtualFile[] roots = this.myRoots.get(orderRootType).getVirtualFiles();
            boolean same = Comparing.equal(roots, (Object[])oldRoots.get(orderRootType));
            this.myFiles.put(orderRootType, this.myRoots.get(orderRootType).getVirtualFiles());
            if (same) continue;
            this.fireRootsChanged();
        }
        this.myInsideChange = false;
    }

    public void addProjectRootContainerListener(ProjectRootListener listener) {
        this.myListeners.add(listener);
    }

    public void removeProjectRootContainerListener(ProjectRootListener listener) {
        this.myListeners.remove(listener);
    }

    private void fireRootsChanged() {
        for (ProjectRootListener listener : this.myListeners) {
            listener.rootsChanged();
        }
    }

    @Override
    public void removeRoot(@NotNull ProjectRoot root, @NotNull OrderRootType type) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "removeRoot"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "removeRoot"));
        }
        LOG.assertTrue(this.myInsideChange);
        this.myRoots.get(type).remove(root);
    }

    @Override
    @NotNull
    public ProjectRoot addRoot(@NotNull VirtualFile virtualFile, @NotNull OrderRootType type) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "addRoot"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "addRoot"));
        }
        LOG.assertTrue(this.myInsideChange);
        ProjectRoot projectRoot = this.myRoots.get(type).add(virtualFile);
        if (projectRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "addRoot"));
        }
        return projectRoot;
    }

    @Override
    public void addRoot(@NotNull ProjectRoot root, @NotNull OrderRootType type) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "addRoot"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "addRoot"));
        }
        LOG.assertTrue(this.myInsideChange);
        this.myRoots.get(type).add(root);
    }

    @Override
    public void removeAllRoots(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "removeAllRoots"));
        }
        LOG.assertTrue(this.myInsideChange);
        this.myRoots.get(type).clear();
    }

    @Override
    public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType type) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "removeRoot"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl", "removeRoot"));
        }
        LOG.assertTrue(this.myInsideChange);
        this.myRoots.get(type).remove(root);
    }

    @Override
    public void removeAllRoots() {
        LOG.assertTrue(this.myInsideChange);
        for (CompositeProjectRoot myRoot : this.myRoots.values()) {
            myRoot.clear();
        }
    }

    @Override
    public void update() {
        LOG.assertTrue(this.myInsideChange);
        for (CompositeProjectRoot myRoot : this.myRoots.values()) {
            myRoot.update();
        }
    }

    @Override
    public void readExternal(Element element) {
        for (OrderRootType type : OrderRootType.getAllPersistentTypes()) {
            this.read(element, (PersistentOrderRootType)type);
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                ProjectRootContainerImpl.this.myFiles = new HashMap();
                for (OrderRootType rootType : ProjectRootContainerImpl.this.myRoots.keySet()) {
                    CompositeProjectRoot root = (CompositeProjectRoot)ProjectRootContainerImpl.this.myRoots.get(rootType);
                    if (ProjectRootContainerImpl.this.myNoCopyJars) {
                        ProjectRootContainerImpl.setNoCopyJars(root);
                    }
                    ProjectRootContainerImpl.this.myFiles.put(rootType, root.getVirtualFiles());
                }
            }
        });
        OrderRootType[] orderRootTypeArray = OrderRootType.getAllTypes();
        int n = orderRootTypeArray.length;
        for (int i = 0; i < n; ++i) {
            OrderRootType type;
            VirtualFile[] oldRoots = VirtualFile.EMPTY_ARRAY;
            type = orderRootTypeArray[i];
            VirtualFile[] newRoots = this.getRootFiles(type);
            if (Comparing.equal(oldRoots, newRoots)) continue;
            this.fireRootsChanged();
        }
    }

    @Override
    public void writeExternal(Element element) {
        List<PersistentOrderRootType> allTypes = OrderRootType.getSortedRootTypes();
        for (PersistentOrderRootType type : allTypes) {
            this.write(element, type);
        }
    }

    private static void setNoCopyJars(ProjectRoot root) {
        block3: {
            block2: {
                if (!(root instanceof SimpleProjectRoot)) break block2;
                String url = ((SimpleProjectRoot)root).getUrl();
                if (!"jar".equals(VirtualFileManager.extractProtocol(url))) break block3;
                String path = VirtualFileManager.extractPath(url);
                VirtualFileSystem fileSystem = StandardFileSystems.jar();
                if (!(fileSystem instanceof JarCopyingFileSystem)) break block3;
                ((JarCopyingFileSystem)((Object)fileSystem)).setNoCopyJarForPath(path);
                break block3;
            }
            if (root instanceof CompositeProjectRoot) {
                ProjectRoot[] roots;
                for (ProjectRoot root1 : roots = ((CompositeProjectRoot)root).getProjectRoots()) {
                    ProjectRootContainerImpl.setNoCopyJars(root1);
                }
            }
        }
    }

    private void read(Element element, PersistentOrderRootType type) {
        Element child;
        String sdkRootName = type.getSdkRootName();
        Element element2 = child = sdkRootName != null ? element.getChild(sdkRootName) : null;
        if (child == null) {
            this.myRoots.put(type, new CompositeProjectRoot());
            return;
        }
        List children = child.getChildren();
        LOG.assertTrue(children.size() == 1);
        CompositeProjectRoot root = (CompositeProjectRoot)ProjectRootUtil.read((Element)children.get(0));
        this.myRoots.put(type, root);
    }

    private void write(Element roots, PersistentOrderRootType type) {
        String sdkRootName = type.getSdkRootName();
        if (sdkRootName != null) {
            Element e = new Element(sdkRootName);
            roots.addContent(e);
            Element root = ProjectRootUtil.write(this.myRoots.get(type));
            if (root != null) {
                e.addContent(root);
            }
        }
    }

    void readOldVersion(Element child) {
        block0: for (Element root : child.getChildren("root")) {
            String url = root.getAttributeValue("file");
            SimpleProjectRoot projectRoot = new SimpleProjectRoot(url);
            String type = root.getChild("property").getAttributeValue("value");
            for (PersistentOrderRootType rootType : OrderRootType.getAllPersistentTypes()) {
                if (!type.equals(rootType.getOldSdkRootName())) continue;
                this.addRoot(projectRoot, (OrderRootType)rootType);
                continue block0;
            }
        }
        this.myFiles = new HashMap<OrderRootType, VirtualFile[]>();
        for (OrderRootType rootType : this.myRoots.keySet()) {
            this.myFiles.put(rootType, this.myRoots.get(rootType).getVirtualFiles());
        }
        Iterator<Object> iterator = OrderRootType.getAllTypes();
        int n = ((Iterator<Object>)iterator).length;
        for (int i = 0; i < n; ++i) {
            VirtualFile[] oldRoots = VirtualFile.EMPTY_ARRAY;
            Iterator<Object> type = iterator[i];
            VirtualFile[] newRoots = this.getRootFiles((OrderRootType)((Object)type));
            if (Comparing.equal(oldRoots, newRoots)) continue;
            this.fireRootsChanged();
        }
    }
}

