/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildNumber
implements Comparable<BuildNumber> {
    private static final String BUILD_NUMBER = "__BUILD_NUMBER__";
    private static final String STAR = "*";
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String FALLBACK_VERSION = "999.SNAPSHOT";
    private final String myProductCode;
    private final int myBaselineVersion;
    private final int myBuildNumber;
    private final String myAttemptInfo;

    public BuildNumber(@NotNull String productCode, int baselineVersion, int buildNumber) {
        if (productCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/openapi/util/BuildNumber", "<init>"));
        }
        this(productCode, baselineVersion, buildNumber, null);
    }

    public BuildNumber(@NotNull String productCode, int baselineVersion, int buildNumber, @Nullable String attemptInfo) {
        if (productCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/openapi/util/BuildNumber", "<init>"));
        }
        this.myProductCode = productCode;
        this.myBaselineVersion = baselineVersion;
        this.myBuildNumber = buildNumber;
        this.myAttemptInfo = StringUtil.isEmpty(attemptInfo) ? null : attemptInfo;
    }

    public String asString() {
        return this.asString(true, false);
    }

    public String asStringWithoutProductCode() {
        return this.asString(false, false);
    }

    private String asString(boolean includeProductCode, boolean withBuildAttempt) {
        StringBuilder builder = new StringBuilder();
        if (includeProductCode && !StringUtil.isEmpty(this.myProductCode)) {
            builder.append(this.myProductCode).append('-');
        }
        builder.append(this.myBaselineVersion).append('.');
        if (this.myBuildNumber != Integer.MAX_VALUE) {
            builder.append(this.myBuildNumber);
        } else {
            builder.append(SNAPSHOT);
        }
        if (withBuildAttempt && this.myAttemptInfo != null) {
            builder.append('.').append(this.myAttemptInfo);
        }
        return builder.toString();
    }

    public static BuildNumber fromString(String version) {
        return BuildNumber.fromString(version, null);
    }

    public static BuildNumber fromString(String version, @Nullable String name) {
        int buildNumber;
        int baselineVersion;
        String productCode;
        if (version == null) {
            return null;
        }
        if (BUILD_NUMBER.equals(version)) {
            String productCode2 = name != null ? name : "";
            return new BuildNumber(productCode2, Holder.TOP_BASELINE_VERSION, Integer.MAX_VALUE);
        }
        String code = version;
        int productSeparator = code.indexOf(45);
        if (productSeparator > 0) {
            productCode = code.substring(0, productSeparator);
            code = code.substring(productSeparator + 1);
        } else {
            productCode = "";
        }
        int baselineVersionSeparator = code.indexOf(46);
        String attemptInfo = null;
        if (baselineVersionSeparator > 0) {
            try {
                String baselineVersionString = code.substring(0, baselineVersionSeparator);
                if (baselineVersionString.trim().isEmpty()) {
                    return null;
                }
                baselineVersion = Integer.parseInt(baselineVersionString);
                code = code.substring(baselineVersionSeparator + 1);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid version number: " + version + "; plugin name: " + name);
            }
            int minorBuildSeparator = code.indexOf(46);
            if (minorBuildSeparator > 0) {
                attemptInfo = code.substring(minorBuildSeparator + 1);
                code = code.substring(0, minorBuildSeparator);
            }
            buildNumber = BuildNumber.parseBuildNumber(version, code, name);
        } else {
            buildNumber = BuildNumber.parseBuildNumber(version, code, name);
            if (buildNumber <= 2000) {
                return new BuildNumber(productCode, buildNumber, 0, null);
            }
            baselineVersion = BuildNumber.getBaseLineForHistoricBuilds(buildNumber);
        }
        return new BuildNumber(productCode, baselineVersion, buildNumber, attemptInfo);
    }

    private static int parseBuildNumber(String version, String code, String name) {
        if (SNAPSHOT.equals(code) || STAR.equals(code) || BUILD_NUMBER.equals(code)) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(code);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid version number: " + version + "; plugin name: " + name);
        }
    }

    private static BuildNumber fromFile() {
        try {
            String home = PathManager.getHomePath();
            File buildTxtFile = FileUtil.findFirstThatExist(home + "/build.txt", home + "/Resources/build.txt", home + "/community/build.txt");
            if (buildTxtFile != null) {
                String text = FileUtil.loadFile(buildTxtFile).trim();
                return BuildNumber.fromString(text);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return BuildNumber.fallback();
    }

    public static BuildNumber fallback() {
        return BuildNumber.fromString(FALLBACK_VERSION);
    }

    public String toString() {
        return this.asString();
    }

    @Override
    public int compareTo(@NotNull BuildNumber o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/openapi/util/BuildNumber", "compareTo"));
        }
        if (this.isSnapshot() && o.isSnapshot()) {
            return 0;
        }
        if (this.myBaselineVersion == o.myBaselineVersion) {
            return this.myBuildNumber - o.myBuildNumber;
        }
        return this.myBaselineVersion - o.myBaselineVersion;
    }

    @NotNull
    public String getProductCode() {
        String string = this.myProductCode;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/BuildNumber", "getProductCode"));
        }
        return string;
    }

    public int getBaselineVersion() {
        return this.myBaselineVersion;
    }

    public int getBuildNumber() {
        return this.myBuildNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildNumber that = (BuildNumber)o;
        if (this.isSnapshot() && ((BuildNumber)o).isSnapshot()) {
            return true;
        }
        if (this.myBaselineVersion != that.myBaselineVersion) {
            return false;
        }
        if (this.myBuildNumber != that.myBuildNumber) {
            return false;
        }
        if (!this.myProductCode.equals(that.myProductCode)) {
            return false;
        }
        return Comparing.equal(this.myAttemptInfo, that.myAttemptInfo);
    }

    public int hashCode() {
        if (this.isSnapshot()) {
            return 0;
        }
        int result = this.myProductCode.hashCode();
        result = 31 * result + this.myBaselineVersion;
        result = 31 * result + this.myBuildNumber;
        if (this.myAttemptInfo != null) {
            result = 31 * result + this.myAttemptInfo.hashCode();
        }
        return result;
    }

    private static int getBaseLineForHistoricBuilds(int bn) {
        if (bn == Integer.MAX_VALUE) {
            return Holder.TOP_BASELINE_VERSION;
        }
        if (bn >= 10000) {
            return 88;
        }
        if (bn >= 9500) {
            return 85;
        }
        if (bn >= 9100) {
            return 81;
        }
        if (bn >= 8000) {
            return 80;
        }
        if (bn >= 7500) {
            return 75;
        }
        if (bn >= 7200) {
            return 72;
        }
        if (bn >= 6900) {
            return 69;
        }
        if (bn >= 6500) {
            return 65;
        }
        if (bn >= 6000) {
            return 60;
        }
        if (bn >= 5000) {
            return 55;
        }
        if (bn >= 4000) {
            return 50;
        }
        return 40;
    }

    public boolean isSnapshot() {
        return this.myBuildNumber == Integer.MAX_VALUE;
    }

    public String asStringWithAllDetails() {
        return this.asString(true, true);
    }

    static /* synthetic */ BuildNumber access$000() {
        return BuildNumber.fromFile();
    }

    private static class Holder {
        private static final int TOP_BASELINE_VERSION = BuildNumber.access$000().getBaselineVersion();

        private Holder() {
        }
    }
}

