/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentRefHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentWeakHashMap<K, V>
extends ConcurrentRefHashMap<K, V> {
    @Override
    protected ConcurrentRefHashMap.KeyReference<K, V> createKeyReference(@NotNull K key, @NotNull V value, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentWeakHashMap", "createKeyReference"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentWeakHashMap", "createKeyReference"));
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ConcurrentWeakHashMap", "createKeyReference"));
        }
        return new WeakKey(key, hashingStrategy.computeHashCode(key), hashingStrategy, value, this.myReferenceQueue);
    }

    public ConcurrentWeakHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ConcurrentWeakHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ConcurrentWeakHashMap() {
    }

    public ConcurrentWeakHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ConcurrentWeakHashMap", "<init>"));
        }
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    public ConcurrentWeakHashMap(Map<? extends K, ? extends V> t) {
        super(t);
    }

    public ConcurrentWeakHashMap(@NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ConcurrentWeakHashMap", "<init>"));
        }
        super(hashingStrategy);
    }

    private static class WeakKey<K, V>
    extends WeakReference<K>
    implements ConcurrentRefHashMap.KeyReference<K, V> {
        private final int myHash;
        @NotNull
        private final TObjectHashingStrategy<K> myStrategy;
        private final V value;

        private WeakKey(@NotNull K k, int hash, @NotNull TObjectHashingStrategy<K> strategy, V v, ReferenceQueue<K> q) {
            if (k == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "com/intellij/util/containers/ConcurrentWeakHashMap$WeakKey", "<init>"));
            }
            if (strategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/ConcurrentWeakHashMap$WeakKey", "<init>"));
            }
            super(k, q);
            this.myStrategy = strategy;
            this.value = v;
            this.myHash = hash;
        }

        @Override
        @NotNull
        public V getValue() {
            V v = this.value;
            if (v == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentWeakHashMap$WeakKey", "getValue"));
            }
            return v;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConcurrentRefHashMap.KeyReference)) {
                return false;
            }
            Object t = this.get();
            Object u = ((ConcurrentRefHashMap.KeyReference)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return this.myStrategy.equals(t, u);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }
    }
}

