/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.AbstractBatchSuppressByNoInspectionCommentFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressFix
extends AbstractBatchSuppressByNoInspectionCommentFix {
    private String myAlternativeID;

    public SuppressFix(@NotNull HighlightDisplayKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "<init>"));
        }
        this(key.getID());
        this.myAlternativeID = HighlightDisplayKey.getAlternativeID(key);
    }

    public SuppressFix(@NotNull String ID2) {
        if (ID2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ID", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "<init>"));
        }
        super(ID2, false);
    }

    @Override
    @NotNull
    public String getText() {
        String myText = super.getText();
        String string = StringUtil.isEmpty(myText) ? "Suppress for member" : myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "getText"));
        }
        return string;
    }

    @Override
    @Nullable
    public PsiDocCommentOwner getContainer(PsiElement context) {
        if (context == null || !context.getManager().isInProject(context)) {
            return null;
        }
        PsiFile containingFile = context.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        if (!containingFile.getLanguage().isKindOf(JavaLanguage.INSTANCE) || context instanceof PsiFile) {
            return null;
        }
        PsiElement container = context;
        while (container instanceof PsiAnonymousClass || !(container instanceof PsiDocCommentOwner) || container instanceof PsiTypeParameter) {
            if ((container = PsiTreeUtil.getParentOfType(container, PsiDocCommentOwner.class)) != null) continue;
            return null;
        }
        return (PsiDocCommentOwner)container;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
        boolean isValid;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "isAvailable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "isAvailable"));
        }
        PsiDocCommentOwner container = this.getContainer(context);
        boolean bl = isValid = container != null && (!(container instanceof PsiMethod) || !(container instanceof SyntheticElement));
        if (!isValid) {
            return false;
        }
        this.setText(container instanceof PsiClass ? InspectionsBundle.message("suppress.inspection.class", new Object[0]) : (container instanceof PsiMethod ? InspectionsBundle.message("suppress.inspection.method", new Object[0]) : InspectionsBundle.message("suppress.inspection.field", new Object[0])));
        return true;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "invoke"));
        }
        if (this.doSuppress(project, this.getContainer(element))) {
            return;
        }
        UndoUtil.markPsiFileForUndo(element.getContainingFile());
    }

    private boolean doSuppress(@NotNull Project project, PsiDocCommentOwner container) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "doSuppress"));
        }
        assert (container != null);
        if (!FileModificationService.getInstance().preparePsiElementForWrite(container)) {
            return true;
        }
        if (this.use15Suppressions(container)) {
            PsiModifierList modifierList = container.getModifierList();
            if (modifierList != null) {
                JavaSuppressionUtil.addSuppressAnnotation(project, container, container, this.getID(container));
            }
        } else {
            PsiDocComment docComment = container.getDocComment();
            PsiManager manager = PsiManager.getInstance(project);
            if (docComment == null) {
                String commentText = "/** @noinspection " + this.getID(container) + "*/";
                docComment = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createDocCommentFromText(commentText);
                PsiElement firstChild = container.getFirstChild();
                container.addBefore(docComment, firstChild);
            } else {
                PsiDocTag noInspectionTag = docComment.findTagByName("noinspection");
                if (noInspectionTag != null) {
                    String tagText = noInspectionTag.getText() + ", " + this.getID(container);
                    noInspectionTag.replace(JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createDocTagFromText(tagText));
                } else {
                    String tagText = "@noinspection " + this.getID(container);
                    docComment.add(JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createDocTagFromText(tagText));
                }
            }
        }
        return false;
    }

    protected boolean use15Suppressions(@NotNull PsiDocCommentOwner container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "use15Suppressions"));
        }
        return JavaSuppressionUtil.canHave15Suppressions(container) && !JavaSuppressionUtil.alreadyHas14Suppressions(container);
    }

    private String getID(@NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "getID"));
        }
        String id = SuppressFix.getID(place, this.myAlternativeID);
        return id != null ? id : this.myID;
    }

    @Nullable
    static String getID(@NotNull PsiElement place, String alternativeID) {
        Module module;
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/daemon/impl/actions/SuppressFix", "getID"));
        }
        if (alternativeID != null && (module = ModuleUtilCore.findModuleForPsiElement(place)) != null && !ClassPathStorageUtil.isDefaultStorage(module)) {
            return alternativeID;
        }
        return null;
    }
}

