/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class FixedConcurrentIntQueue {
    private final AtomicInteger tail = new AtomicInteger();
    final AtomicIntegerArray queue;
    private final int capacity;
    private final int tombValue;

    public FixedConcurrentIntQueue(int capacity, int tombValue) {
        this.capacity = capacity;
        this.tombValue = tombValue;
        this.queue = new AtomicIntegerArray(capacity);
        for (int i = 0; i < capacity; ++i) {
            this.queue.set(i, tombValue);
        }
    }

    public int push(int value) {
        if (value == this.tombValue) {
            throw new IllegalArgumentException("Must not use tomb value: " + value);
        }
        int index = this.getAndIncrement();
        return this.queue.getAndSet(index, value);
    }

    private int getAndIncrement() {
        int next;
        int index;
        do {
            if ((next = (index = this.tail.get()) + 1) < this.capacity) continue;
            next -= this.capacity;
        } while (!this.tail.compareAndSet(index, next));
        return index;
    }
}

