/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoggingConditionDisagreesWithLogStatementInspection
extends BaseInspection {
    private static final Set<String> loggingLevels = new HashSet<String>(Arrays.asList("debug", "error", "fatal", "info", "trace", "warn", "severe", "warning", "info", "config", "fine", "finer", "finest"));
    private static final Map<String, LoggingProblemChecker> problemCheckers = new HashMap<String, LoggingProblemChecker>();

    private static void register(LoggingProblemChecker problemChecker) {
        for (String name : problemChecker.getClassNames()) {
            problemCheckers.put(name, problemChecker);
        }
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("logging.condition.disagrees.with.log.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/LoggingConditionDisagreesWithLogStatementInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("logging.condition.disagrees.with.log.statement.problem.descriptor", infos[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/LoggingConditionDisagreesWithLogStatementInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoggingConditionDisagreesWithLogStatementVisitor();
    }

    static {
        LoggingConditionDisagreesWithLogStatementInspection.register(new Log4jProblemChecker());
        LoggingConditionDisagreesWithLogStatementInspection.register(new CommonsLoggingProblemChecker());
        LoggingConditionDisagreesWithLogStatementInspection.register(new JavaUtilLoggingProblemChecker());
        LoggingConditionDisagreesWithLogStatementInspection.register(new Slf4jProblemChecker());
    }

    private static class Log4jProblemChecker
    implements LoggingProblemChecker {
        private Log4jProblemChecker() {
        }

        @Override
        public String[] getClassNames() {
            return new String[]{"org.apache.log4j.Logger", "org.apache.log4j.Category"};
        }

        @Override
        public boolean hasLoggingProblem(String priority, PsiMethodCallExpression methodCallExpression) {
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String enabledFor = null;
            if ("isDebugEnabled".equals(methodName)) {
                enabledFor = "debug";
            } else if ("isInfoEnabled".equals(methodName)) {
                enabledFor = "info";
            } else if ("isTraceEnabled".equals(methodName)) {
                enabledFor = "trace";
            } else if ("isEnabledFor".equals(methodName)) {
                PsiExpression[] arguments;
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                    PsiElement argumentTarget;
                    PsiClassType classType;
                    PsiClass aClass;
                    if (!(argument instanceof PsiReferenceExpression)) continue;
                    PsiReferenceExpression argumentReference = (PsiReferenceExpression)argument;
                    PsiType type = argument.getType();
                    if (!(type instanceof PsiClassType) || !InheritanceUtil.isInheritor(aClass = (classType = (PsiClassType)type).resolve(), "org.apache.log4j.Priority") || !((argumentTarget = argumentReference.resolve()) instanceof PsiField)) continue;
                    PsiField field = (PsiField)argumentTarget;
                    enabledFor = field.getName().toLowerCase();
                }
                if (enabledFor == null) {
                    return false;
                }
            }
            return !priority.equals(enabledFor);
        }
    }

    private static class Slf4jProblemChecker
    implements LoggingProblemChecker {
        private Slf4jProblemChecker() {
        }

        @Override
        public String[] getClassNames() {
            return new String[]{"org.slf4j.Logger"};
        }

        @Override
        public boolean hasLoggingProblem(String priority, PsiMethodCallExpression methodCallExpression) {
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if ("isTraceEnabled".equals(methodName)) {
                return !"trace".equals(priority);
            }
            if ("isDebugEnabled".equals(methodName)) {
                return !"debug".equals(priority);
            }
            if ("isInfoEnabled".equals(methodName)) {
                return !"info".equals(priority);
            }
            if ("isWarnEnabled".equals(methodName)) {
                return !"warn".equals(priority);
            }
            if ("isErrorEnabled".equals(methodName)) {
                return !"error".equals(priority);
            }
            return false;
        }
    }

    private static class CommonsLoggingProblemChecker
    implements LoggingProblemChecker {
        private CommonsLoggingProblemChecker() {
        }

        @Override
        public String[] getClassNames() {
            return new String[]{"org.apache.commons.logging.Log"};
        }

        @Override
        public boolean hasLoggingProblem(String priority, PsiMethodCallExpression methodCallExpression) {
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if ("isTraceEnabled".equals(methodName)) {
                return !priority.equals("trace");
            }
            if ("isDebugEnabled".equals(methodName)) {
                return !priority.equals("debug");
            }
            if ("isInfoEnabled".equals(methodName)) {
                return !priority.equals("info");
            }
            if ("isWarnEnabled".equals(methodName)) {
                return !priority.equals("warn");
            }
            if ("isErrorEnabled".equals(methodName)) {
                return !priority.equals("error");
            }
            if ("isFatalEnabled".equals(methodName)) {
                return !priority.equals("fatal");
            }
            return false;
        }
    }

    private static class JavaUtilLoggingProblemChecker
    implements LoggingProblemChecker {
        private JavaUtilLoggingProblemChecker() {
        }

        @Override
        public String[] getClassNames() {
            return new String[]{"java.util.logging.Logger"};
        }

        @Override
        public boolean hasLoggingProblem(String priority, PsiMethodCallExpression methodCallExpression) {
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"isLoggable".equals(methodName)) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiExpression argument = arguments[0];
            String loggingLevel = JavaUtilLoggingProblemChecker.getLoggingLevelFromArgument(argument);
            if (loggingLevel == null) {
                return false;
            }
            return !loggingLevel.equals(priority);
        }

        @Nullable
        public static String getLoggingLevelFromArgument(PsiExpression argument) {
            if (!(argument instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression argumentReference = (PsiReferenceExpression)argument;
            PsiType type = argument.getType();
            if (!(type instanceof PsiClassType)) {
                return null;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return null;
            }
            String qName = aClass.getQualifiedName();
            if (!"java.util.logging.Level".equals(qName)) {
                return null;
            }
            PsiElement argumentTarget = argumentReference.resolve();
            if (!(argumentTarget instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)argumentTarget;
            return field.getName().toLowerCase();
        }
    }

    static interface LoggingProblemChecker {
        public String[] getClassNames();

        public boolean hasLoggingProblem(String var1, PsiMethodCallExpression var2);
    }

    private static class LoggingConditionDisagreesWithLogStatementVisitor
    extends BaseInspectionVisitor {
        private LoggingConditionDisagreesWithLogStatementVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiExpression qualifier;
            PsiIfStatement ifStatement;
            PsiMethod method;
            String loggingLevel;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null) {
                return;
            }
            if (!loggingLevels.contains(referenceName)) {
                if (!"log".equals(referenceName)) {
                    return;
                }
                PsiExpressionList argumentList = expression.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                if (arguments.length < 2) {
                    return;
                }
                PsiExpression argument = arguments[0];
                loggingLevel = JavaUtilLoggingProblemChecker.getLoggingLevelFromArgument(argument);
                if (loggingLevel == null) {
                    return;
                }
            } else {
                loggingLevel = referenceName;
            }
            if ((method = expression.resolveMethod()) == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiExpressionStatement)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiCodeBlock) {
                PsiElement greatGrandParent = grandParent.getParent();
                if (!(greatGrandParent instanceof PsiBlockStatement)) {
                    return;
                }
                PsiElement greatGreatGrandParent = greatGrandParent.getParent();
                if (!(greatGreatGrandParent instanceof PsiIfStatement)) {
                    return;
                }
                ifStatement = (PsiIfStatement)greatGreatGrandParent;
            } else if (grandParent instanceof PsiIfStatement) {
                ifStatement = (PsiIfStatement)grandParent;
            } else {
                return;
            }
            PsiExpression condition = ifStatement.getCondition();
            if (condition instanceof PsiMethodCallExpression) {
                PsiStatement thenBranch = ifStatement.getThenBranch();
                if (!PsiTreeUtil.isAncestor(thenBranch, expression, false)) {
                    return;
                }
            } else if (condition instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition;
                if (!JavaTokenType.EXCL.equals(prefixExpression.getOperationTokenType())) {
                    return;
                }
                PsiStatement elseBranch = ifStatement.getElseBranch();
                if (!PsiTreeUtil.isAncestor(elseBranch, expression, false)) {
                    return;
                }
                condition = prefixExpression.getOperand();
                if (!(condition instanceof PsiMethodCallExpression)) {
                    return;
                }
            } else {
                return;
            }
            if (!((qualifier = methodExpression.getQualifierExpression()) instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (target == null) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)condition;
            PsiReferenceExpression conditionMethodExpression = methodCallExpression.getMethodExpression();
            PsiExpression conditionQualifier = conditionMethodExpression.getQualifierExpression();
            if (!(conditionQualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression conditionReferenceExpression = (PsiReferenceExpression)conditionQualifier;
            PsiElement conditionTarget = conditionReferenceExpression.resolve();
            if (!target.equals(conditionTarget)) {
                return;
            }
            String qualifiedName = containingClass.getQualifiedName();
            LoggingProblemChecker problemChecker = (LoggingProblemChecker)problemCheckers.get(qualifiedName);
            if (problemChecker == null || !problemChecker.hasLoggingProblem(loggingLevel, methodCallExpression)) {
                return;
            }
            this.registerMethodCallError(methodCallExpression, loggingLevel);
        }
    }
}

