/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.Nullable;

public abstract class ReadWriteAccessDetector {
    public static final ExtensionPointName<ReadWriteAccessDetector> EP_NAME = ExtensionPointName.create("com.intellij.readWriteAccessDetector");

    @Nullable
    public static ReadWriteAccessDetector findDetector(PsiElement element) {
        ReadWriteAccessDetector detector = null;
        for (ReadWriteAccessDetector accessDetector : Extensions.getExtensions(EP_NAME)) {
            if (!accessDetector.isReadWriteAccessible(element)) continue;
            detector = accessDetector;
            break;
        }
        return detector;
    }

    public abstract boolean isReadWriteAccessible(PsiElement var1);

    public abstract boolean isDeclarationWriteAccess(PsiElement var1);

    public abstract Access getReferenceAccess(PsiElement var1, PsiReference var2);

    public abstract Access getExpressionAccess(PsiElement var1);

    public static enum Access {
        Read,
        Write,
        ReadWrite;

    }
}

