/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPrimitiveType
extends PsiType.Stub {
    private static final Map<String, PsiPrimitiveType> ourQNameToUnboxed = new THashMap();
    private static final Map<PsiPrimitiveType, String> ourUnboxedToQName = new THashMap();
    private final String myName;

    PsiPrimitiveType(@NonNls @NotNull String name, @NonNls String boxedName) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/PsiPrimitiveType", "<init>"));
        }
        this(name, PsiAnnotation.EMPTY_ARRAY);
        if (boxedName != null) {
            ourQNameToUnboxed.put(boxedName, this);
            ourUnboxedToQName.put(this, boxedName);
        }
    }

    public PsiPrimitiveType(@NonNls @NotNull String name, @NotNull PsiAnnotation[] annotations) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/PsiPrimitiveType", "<init>"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiPrimitiveType", "<init>"));
        }
        super(annotations);
        this.myName = name;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = this.getText(false, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiPrimitiveType", "getPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(true, annotated);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiPrimitiveType", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getText(true, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiPrimitiveType", "getInternalCanonicalText"));
        }
        return string;
    }

    private String getText(boolean qualified, boolean annotated) {
        PsiAnnotation[] annotations = this.getAnnotations();
        if (!annotated || annotations.length == 0) {
            return this.myName;
        }
        StringBuilder sb = new StringBuilder();
        PsiNameHelper.appendAnnotations(sb, annotations, qualified);
        sb.append(this.myName);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/PsiPrimitiveType", "equalsToText"));
        }
        return this.myName.equals(text);
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/PsiPrimitiveType", "accept"));
        }
        return visitor.visitPrimitiveType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return null;
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiPrimitiveType", "getSuperTypes"));
        }
        return EMPTY_ARRAY;
    }

    @Nullable
    public static PsiPrimitiveType getUnboxedType(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        LanguageLevel languageLevel = ((PsiClassType)type).getLanguageLevel();
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return null;
        }
        assert (type.isValid()) : type;
        PsiClass psiClass = ((PsiClassType)type).resolve();
        if (psiClass == null) {
            return null;
        }
        PsiPrimitiveType unboxed = ourQNameToUnboxed.get(psiClass.getQualifiedName());
        PsiAnnotation[] annotations = type.getAnnotations();
        if (unboxed != null && annotations.length > 0) {
            unboxed = new PsiPrimitiveType(unboxed.myName, annotations);
        }
        return unboxed;
    }

    public String getBoxedTypeName() {
        return ourUnboxedToQName.get(this);
    }

    @Nullable
    public PsiClassType getBoxedType(PsiElement context) {
        PsiFile file = context.getContainingFile();
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(file);
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return null;
        }
        String boxedQName = this.getBoxedTypeName();
        if (boxedQName == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance(file.getProject());
        PsiClass aClass = facade.findClass(boxedQName, context.getResolveScope());
        if (aClass == null) {
            return null;
        }
        PsiElementFactory factory = facade.getElementFactory();
        return factory.createType(aClass, PsiSubstitutor.EMPTY, languageLevel, this.getAnnotations());
    }

    @Nullable
    public PsiClassType getBoxedType(PsiManager manager, GlobalSearchScope resolveScope) {
        String boxedQName = this.getBoxedTypeName();
        if (boxedQName == null) {
            return null;
        }
        PsiClass aClass = JavaPsiFacade.getInstance(manager.getProject()).findClass(boxedQName, resolveScope);
        if (aClass == null) {
            return null;
        }
        return JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createType(aClass);
    }

    public static Collection<String> getAllBoxedTypeNames() {
        return Collections.unmodifiableCollection(ourQNameToUnboxed.keySet());
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PsiPrimitiveType && this.myName.equals(((PsiPrimitiveType)obj).myName);
    }
}

