/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class PsiPolyExpressionUtil {
    public static boolean hasStandaloneForm(PsiExpression expression) {
        return !(expression instanceof PsiFunctionalExpression) && !(expression instanceof PsiParenthesizedExpression) && !(expression instanceof PsiConditionalExpression) && !(expression instanceof PsiCallExpression);
    }

    public static boolean isPolyExpression(PsiExpression expression) {
        if (expression instanceof PsiFunctionalExpression) {
            return true;
        }
        if (expression instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isPolyExpression(((PsiParenthesizedExpression)expression).getExpression());
        }
        if (expression instanceof PsiNewExpression) {
            PsiTypeElement[] typeElements;
            PsiReferenceParameterList parameterList;
            PsiJavaCodeReferenceElement classReference = ((PsiNewExpression)expression).getClassOrAnonymousClassReference();
            if (classReference != null && (parameterList = classReference.getParameterList()) != null && (typeElements = parameterList.getTypeParameterElements()).length == 1 && typeElements[0].getType() instanceof PsiDiamondType) {
                return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression);
            }
        } else {
            ConditionalKind conditionalKind;
            if (expression instanceof PsiMethodCallExpression) {
                MethodCandidateInfo.CurrentCandidateProperties candidateProperties = MethodCandidateInfo.getCurrentMethod(((PsiMethodCallExpression)expression).getArgumentList());
                return PsiPolyExpressionUtil.isMethodCallPolyExpression(expression, candidateProperties != null ? candidateProperties.getMethod() : ((PsiMethodCallExpression)expression).resolveMethod());
            }
            if (expression instanceof PsiConditionalExpression && (conditionalKind = PsiPolyExpressionUtil.isBooleanOrNumeric(expression)) == null) {
                return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression);
            }
        }
        return false;
    }

    public static boolean isMethodCallPolyExpression(PsiExpression expression, PsiMethod method) {
        if (PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression) && ((PsiCallExpression)expression).getTypeArguments().length == 0) {
            if (method != null) {
                PsiType returnType;
                HashSet<PsiTypeParameter> typeParameters = new HashSet<PsiTypeParameter>(Arrays.asList(method.getTypeParameters()));
                if (!typeParameters.isEmpty() && (returnType = method.getReturnType()) != null) {
                    return PsiPolyExpressionUtil.mentionsTypeParameters(returnType, typeParameters);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static Boolean mentionsTypeParameters(@Nullable PsiType returnType, final Set<PsiTypeParameter> typeParameters) {
        if (returnType == null) {
            return false;
        }
        return returnType.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitType(PsiType type) {
                return false;
            }

            @Override
            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound != null) {
                    return bound.accept(this);
                }
                return false;
            }

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                for (PsiType type : classType.getParameters()) {
                    if (!type.accept(this).booleanValue()) continue;
                    return true;
                }
                PsiClass psiClass = classType.resolve();
                return psiClass instanceof PsiTypeParameter && typeParameters.contains(psiClass);
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }
        });
    }

    private static boolean isInAssignmentOrInvocationContext(PsiExpression expr) {
        PsiElement context = PsiUtil.skipParenthesizedExprUp(expr.getParent());
        return context instanceof PsiExpressionList || context instanceof PsiArrayInitializerExpression || context instanceof PsiConditionalExpression && (expr instanceof PsiCallExpression || PsiPolyExpressionUtil.isPolyExpression((PsiExpression)context)) || PsiPolyExpressionUtil.isAssignmentContext(expr, context);
    }

    private static boolean isAssignmentContext(PsiExpression expr, PsiElement context) {
        return PsiUtil.isCondition(expr, context) || context instanceof PsiReturnStatement || context instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)context).getOperationTokenType() == JavaTokenType.EQ || context instanceof PsiVariable || context instanceof PsiLambdaExpression;
    }

    private static ConditionalKind isBooleanOrNumeric(PsiExpression expr) {
        PsiMethod method;
        if (expr instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isBooleanOrNumeric(((PsiParenthesizedExpression)expr).getExpression());
        }
        if (expr == null) {
            return null;
        }
        PsiType type = null;
        if (expr instanceof PsiNewExpression || PsiPolyExpressionUtil.hasStandaloneForm(expr)) {
            type = expr.getType();
        } else if (expr instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)expr).resolveMethod()) != null) {
            type = method.getReturnType();
        }
        if (TypeConversionUtil.isNumericType(type)) {
            return ConditionalKind.NUMERIC;
        }
        if (TypeConversionUtil.isBooleanType(type)) {
            return ConditionalKind.BOOLEAN;
        }
        if (expr instanceof PsiConditionalExpression) {
            ConditionalKind elseKind;
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            ConditionalKind thenKind = PsiPolyExpressionUtil.isBooleanOrNumeric(thenExpression);
            if (thenKind == (elseKind = PsiPolyExpressionUtil.isBooleanOrNumeric(elseExpression)) || elseKind == null) {
                return thenKind;
            }
            if (thenKind == null) {
                return elseKind;
            }
        }
        return null;
    }

    private static enum ConditionalKind {
        BOOLEAN,
        NUMERIC;

    }
}

