/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Restarter {
    private Restarter() {
    }

    private static int getRestartCode() {
        String s = System.getProperty("jb.restart.code");
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static boolean isSupported() {
        if (Restarter.getRestartCode() != 0) {
            return true;
        }
        if (SystemInfo.isWindows) {
            return new File(PathManager.getBinPath(), "restarter.exe").exists();
        }
        if (SystemInfo.isMac) {
            return PathManager.getHomePath().contains(".app");
        }
        return false;
    }

    public static int scheduleRestart(String ... beforeRestart) throws IOException {
        if (beforeRestart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeRestart", "com/intellij/util/Restarter", "scheduleRestart"));
        }
        try {
            int restartCode = Restarter.getRestartCode();
            if (restartCode != 0) {
                Restarter.runCommand(beforeRestart);
                return restartCode;
            }
            if (SystemInfo.isWindows) {
                Restarter.restartOnWindows(beforeRestart);
                return 0;
            }
            if (SystemInfo.isMac) {
                Restarter.restartOnMac(beforeRestart);
                return 0;
            }
        }
        catch (Throwable t) {
            throw new IOException("Cannot restart application: " + t.getMessage(), t);
        }
        Restarter.runCommand(beforeRestart);
        throw new IOException("Cannot restart application: not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runCommand(String ... beforeRestart) throws IOException {
        if (beforeRestart.length == 0) {
            return;
        }
        File restartDir = new File(System.getProperty("user.home") + "/." + System.getProperty("idea.paths.selector") + "/restart");
        if (!FileUtilRt.createDirectory(restartDir)) {
            throw new IOException("Cannot create dir: " + restartDir);
        }
        File restarter = new File(restartDir, "restarter.sh");
        BufferedWriter output = new BufferedWriter(new FileWriter(restarter));
        try {
            output.write("#!/bin/sh\n");
            for (int i = 0; i < beforeRestart.length; ++i) {
                output.write(beforeRestart[i]);
                output.write(i == beforeRestart.length - 1 ? 10 : 32);
            }
        }
        finally {
            output.close();
        }
        if (!restarter.setExecutable(true, true)) {
            throw new IOException("Cannot make file executable: " + restarter);
        }
    }

    private static void restartOnWindows(final String ... beforeRestart) throws IOException {
        if (beforeRestart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeRestart", "com/intellij/util/Restarter", "restartOnWindows"));
        }
        Kernel32 kernel32 = (Kernel32)Native.loadLibrary((String)"kernel32", Kernel32.class);
        Shell32 shell32 = (Shell32)Native.loadLibrary((String)"shell32", Shell32.class);
        final int pid = kernel32.GetCurrentProcessId();
        final IntByReference argc = new IntByReference();
        Pointer argv_ptr = shell32.CommandLineToArgvW(kernel32.GetCommandLineW(), argc);
        final String[] argv = argv_ptr.getStringArray(0L, argc.getValue(), true);
        kernel32.LocalFree(argv_ptr);
        Restarter.doScheduleRestart(new File(PathManager.getBinPath(), "restarter.exe"), new Consumer<List<String>>(){

            @Override
            public void consume(List<String> commands) {
                Collections.addAll(commands, String.valueOf(pid), String.valueOf(beforeRestart.length));
                Collections.addAll(commands, beforeRestart);
                Collections.addAll(commands, String.valueOf(argc.getValue()));
                Collections.addAll(commands, argv);
            }
        });
        TimeoutUtil.sleep(500L);
    }

    private static void restartOnMac(final String ... beforeRestart) throws IOException {
        if (beforeRestart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeRestart", "com/intellij/util/Restarter", "restartOnMac"));
        }
        String homePath = PathManager.getHomePath();
        int p = homePath.indexOf(".app");
        if (p < 0) {
            throw new IOException("Application bundle not found: " + homePath);
        }
        final String bundlePath = homePath.substring(0, p + 4);
        Restarter.doScheduleRestart(new File(PathManager.getBinPath(), "restarter"), new Consumer<List<String>>(){

            @Override
            public void consume(List<String> commands) {
                Collections.addAll(commands, bundlePath);
                Collections.addAll(commands, beforeRestart);
            }
        });
    }

    private static void doScheduleRestart(File restarterFile, Consumer<List<String>> argumentsBuilder) throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(Restarter.createTempExecutable(restarterFile).getPath());
        argumentsBuilder.consume(commands);
        Runtime.getRuntime().exec(ArrayUtil.toStringArray(commands));
    }

    public static File createTempExecutable(File executable) throws IOException {
        File executableDir = new File(System.getProperty("user.home") + "/." + System.getProperty("idea.paths.selector") + "/restart");
        if (!FileUtilRt.createDirectory(executableDir)) {
            throw new IOException("Cannot create dir: " + executableDir);
        }
        File copy = new File(executableDir.getPath() + "/" + executable.getName());
        if (!FileUtilRt.ensureCanCreateFile(copy) || copy.exists() && !copy.delete()) {
            String ext = FileUtilRt.getExtension(executable.getName());
            copy = FileUtilRt.createTempFile(executableDir, FileUtilRt.getNameWithoutExtension(copy.getName()), StringUtil.isEmptyOrSpaces(ext) ? ".tmp" : "." + ext, true, false);
        }
        FileUtilRt.copy(executable, copy);
        if (!copy.setExecutable(executable.canExecute())) {
            throw new IOException("Cannot make file executable: " + copy);
        }
        return copy;
    }

    private static interface Shell32
    extends StdCallLibrary {
        public Pointer CommandLineToArgvW(WString var1, IntByReference var2);
    }

    private static interface Kernel32
    extends StdCallLibrary {
        public int GetCurrentProcessId();

        public WString GetCommandLineW();

        public Pointer LocalFree(Pointer var1);
    }
}

