/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.UISettings;
import java.awt.RenderingHints;
import sun.swing.SwingUtilities2;

public enum AntialiasingType {
    SUBPIXEL,
    GREYSCALE,
    OFF;

    private static final SwingUtilities2.AATextInfo aaEnabled;
    private static final SwingUtilities2.AATextInfo lcdEnabled;
    private static final SwingUtilities2.AATextInfo aaDisabled;

    public static Object getAAHintForSwingComponent() {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings == null) {
            return aaEnabled;
        }
        switch (uiSettings.IDE_AA_TYPE) {
            case SUBPIXEL: {
                return lcdEnabled;
            }
            case GREYSCALE: {
                return aaEnabled;
            }
            case OFF: {
                return aaDisabled;
            }
        }
        return aaEnabled;
    }

    public Object getRenderingHintValue() {
        Object value = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB;
        switch (this) {
            case SUBPIXEL: {
                break;
            }
            case GREYSCALE: {
                value = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
                break;
            }
            case OFF: {
                value = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
            }
        }
        return value;
    }

    public static Object getKeyForCurrentScope(boolean inEditor) {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings == null) {
            return RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        }
        return inEditor ? uiSettings.EDITOR_AA_TYPE.getRenderingHintValue() : uiSettings.IDE_AA_TYPE.getRenderingHintValue();
    }

    public String toString() {
        String description;
        switch (this) {
            case SUBPIXEL: {
                description = "Subpixel";
                break;
            }
            case GREYSCALE: {
                description = "Greyscale";
                break;
            }
            case OFF: {
                description = "No antialiasing";
                break;
            }
            default: {
                description = "Subpixel";
            }
        }
        return description;
    }

    static {
        aaEnabled = new SwingUtilities2.AATextInfo(RenderingHints.VALUE_TEXT_ANTIALIAS_ON, Integer.valueOf(140));
        lcdEnabled = new SwingUtilities2.AATextInfo(RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB, Integer.valueOf(140));
        aaDisabled = null;
    }
}

