/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import java.util.HashMap;

public class Conditions {
    public static final Condition<Object> TRUE = Condition.TRUE;
    public static final Condition<Object> FALSE = Condition.FALSE;

    private Conditions() {
    }

    public static <T> Condition<T> alwaysTrue() {
        return TRUE;
    }

    public static <T> Condition<T> alwaysFalse() {
        return FALSE;
    }

    public static <T> Condition<T> notNull() {
        return Condition.NOT_NULL;
    }

    public static <T> Condition<T> instanceOf(final Class<?> clazz) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                return clazz.isInstance(t);
            }
        };
    }

    public static <T> Condition<T> notInstanceOf(final Class<?> clazz) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                return !clazz.isInstance(t);
            }
        };
    }

    public static Condition<Class> assignableTo(final Class clazz) {
        return new Condition<Class>(){

            @Override
            public boolean value(Class t) {
                return clazz.isAssignableFrom(t);
            }
        };
    }

    public static <T> Condition<T> instanceOf(final Class<?> ... clazz) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                for (Class aClass : clazz) {
                    if (!aClass.isInstance(t)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Condition<T> is(T option) {
        return Conditions.equalTo(option);
    }

    public static <T> Condition<T> equalTo(final Object option) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                return Comparing.equal(t, option);
            }
        };
    }

    public static <T> Condition<T> notEqualTo(final Object option) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                return !Comparing.equal(t, option);
            }
        };
    }

    public static <T> Condition<T> oneOf(final T ... options) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                return ArrayUtilRt.find(options, t) >= 0;
            }
        };
    }

    public static <T> Condition<T> oneOf(final Iterable<? extends T> options) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                for (Object option : options) {
                    if (!Comparing.equal(option, t)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Condition<T> not(Condition<T> c) {
        if (c == TRUE) {
            return Conditions.alwaysFalse();
        }
        if (c == FALSE) {
            return Conditions.alwaysTrue();
        }
        if (c instanceof Not) {
            return ((Not)c).c;
        }
        return new Not<T>(c);
    }

    public static <T> Condition<T> and(Condition<T> c1, Condition<T> c2) {
        return Conditions.and2(c1, c2);
    }

    public static <T> Condition<T> and2(Condition<? super T> c1, Condition<? super T> c2) {
        if (c1 == TRUE || c2 == FALSE) {
            return c2;
        }
        if (c2 == TRUE || c1 == FALSE) {
            return c1;
        }
        return new And<T>(c1, c2);
    }

    public static <T> Condition<T> or(Condition<T> c1, Condition<T> c2) {
        return Conditions.or2(c1, c2);
    }

    public static <T> Condition<T> or2(Condition<? super T> c1, Condition<? super T> c2) {
        if (c1 == FALSE || c2 == TRUE) {
            return c2;
        }
        if (c2 == FALSE || c1 == TRUE) {
            return c1;
        }
        return new Or<T>(c1, c2);
    }

    public static <A, B> Condition<A> compose(final Function<? super A, B> fun, final Condition<? super B> condition) {
        return new Condition<A>(){

            @Override
            public boolean value(A o) {
                return condition.value(fun.fun(o));
            }
        };
    }

    public static <T> Condition<T> cached(Condition<T> c) {
        return new SoftRefCache<T>(c);
    }

    private static class SoftRefCache<T>
    implements Condition<T> {
        private final HashMap<Integer, Pair<SoftReference<T>, Boolean>> myCache = new HashMap();
        private final Condition<T> myCondition;

        public SoftRefCache(Condition<T> condition) {
            this.myCondition = condition;
        }

        @Override
        public final boolean value(T object) {
            int key = object.hashCode();
            Pair<SoftReference<T>, Boolean> entry = this.myCache.get(key);
            if (entry == null || ((SoftReference)entry.first).get() != object) {
                boolean value = this.myCondition.value(object);
                this.myCache.put(key, Pair.create(new SoftReference<T>(object), value));
                return value;
            }
            return (Boolean)entry.second;
        }
    }

    private static class Or<T>
    implements Condition<T> {
        final Condition<? super T> c1;
        final Condition<? super T> c2;

        Or(Condition<? super T> c1, Condition<? super T> c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        @Override
        public boolean value(T object) {
            return this.c1.value(object) || this.c2.value(object);
        }
    }

    private static class And<T>
    implements Condition<T> {
        final Condition<? super T> c1;
        final Condition<? super T> c2;

        And(Condition<? super T> c1, Condition<? super T> c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        @Override
        public boolean value(T object) {
            return this.c1.value(object) && this.c2.value(object);
        }
    }

    private static class Not<T>
    implements Condition<T> {
        final Condition<T> c;

        Not(Condition<T> c) {
            this.c = c;
        }

        @Override
        public boolean value(T value) {
            return !this.c.value(value);
        }
    }
}

