/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefEntityImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RefElementImpl
extends RefEntityImpl
implements RefElement {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.reference.RefElement");
    private static final int IS_ENTRY_MASK = 128;
    private static final int IS_PERMANENT_ENTRY_MASK = 256;
    private final SmartPsiElementPointer myID;
    private List<RefElement> myOutReferences;
    private List<RefElement> myInReferences;
    private String[] mySuppressions;
    private boolean myIsDeleted;
    private final Module myModule;
    protected static final int IS_REACHABLE_MASK = 64;

    protected RefElementImpl(@NotNull String name, @NotNull RefElement owner) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/reference/RefElementImpl", "<init>"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/reference/RefElementImpl", "<init>"));
        }
        super(name, owner.getRefManager());
        this.mySuppressions = null;
        this.myID = null;
        this.myFlags = 0L;
        this.myModule = ModuleUtilCore.findModuleForPsiElement(owner.getElement());
    }

    protected RefElementImpl(PsiFile file, RefManager manager) {
        this(file.getName(), file, manager);
    }

    protected RefElementImpl(@NotNull String name, @NotNull PsiElement element, @NotNull RefManager manager) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/reference/RefElementImpl", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/reference/RefElementImpl", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/reference/RefElementImpl", "<init>"));
        }
        super(name, manager);
        this.mySuppressions = null;
        this.myID = SmartPointerManager.getInstance(manager.getProject()).createSmartPsiElementPointer(element);
        this.myFlags = 0L;
        this.myModule = ModuleUtilCore.findModuleForPsiElement(element);
    }

    @Override
    public boolean isValid() {
        if (this.myIsDeleted) {
            return false;
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                PsiFile file = RefElementImpl.this.myID.getContainingFile();
                if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    return file != null && file.isPhysical();
                }
                PsiElement element = RefElementImpl.this.getElement();
                return element != null && element.isPhysical();
            }
        });
    }

    @Override
    @Nullable
    public Icon getIcon(boolean expanded) {
        PsiElement element = this.getElement();
        if (element != null && element.isValid()) {
            return element.getIcon(3);
        }
        return null;
    }

    @Override
    public RefModule getModule() {
        return this.myManager.getRefModule(this.myModule);
    }

    @Override
    public String getExternalName() {
        return this.getName();
    }

    @Override
    @Nullable
    public PsiElement getElement() {
        return this.myID.getElement();
    }

    @Nullable
    public PsiFile getContainingFile() {
        return this.myID.getContainingFile();
    }

    public VirtualFile getVirtualFile() {
        return this.myID.getVirtualFile();
    }

    @Override
    public SmartPsiElementPointer getPointer() {
        return this.myID;
    }

    public void buildReferences() {
    }

    @Override
    public boolean isReachable() {
        return this.checkFlag(64L);
    }

    @Override
    public boolean isReferenced() {
        return !this.getInReferences().isEmpty();
    }

    public boolean hasSuspiciousCallers() {
        for (RefElement refCaller : this.getInReferences()) {
            if (!((RefElementImpl)refCaller).isSuspicious()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<RefElement> getOutReferences() {
        if (this.myOutReferences == null) {
            List<RefElement> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefElementImpl", "getOutReferences"));
            }
            return list;
        }
        List<RefElement> list = this.myOutReferences;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefElementImpl", "getOutReferences"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<RefElement> getInReferences() {
        if (this.myInReferences == null) {
            List<RefElement> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefElementImpl", "getInReferences"));
            }
            return list;
        }
        List<RefElement> list = this.myInReferences;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefElementImpl", "getInReferences"));
        }
        return list;
    }

    public void addInReference(RefElement refElement) {
        if (!this.getInReferences().contains(refElement)) {
            if (this.myInReferences == null) {
                this.myInReferences = new ArrayList<RefElement>(1);
            }
            this.myInReferences.add(refElement);
        }
    }

    public void addOutReference(RefElement refElement) {
        if (!this.getOutReferences().contains(refElement)) {
            if (this.myOutReferences == null) {
                this.myOutReferences = new ArrayList<RefElement>(1);
            }
            this.myOutReferences.add(refElement);
        }
    }

    public void setEntry(boolean entry) {
        this.setFlag(entry, 128L);
    }

    @Override
    public boolean isEntry() {
        return this.checkFlag(128L);
    }

    @Override
    public boolean isPermanentEntry() {
        return this.checkFlag(256L);
    }

    @Override
    @NotNull
    public RefElement getContainingEntry() {
        RefElementImpl refElementImpl = this;
        if (refElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefElementImpl", "getContainingEntry"));
        }
        return refElementImpl;
    }

    public void setPermanentEntry(boolean permanentEntry) {
        this.setFlag(permanentEntry, 256L);
    }

    public boolean isSuspicious() {
        return !this.isReachable();
    }

    public void referenceRemoved() {
        this.myIsDeleted = true;
        if (this.getOwner() != null) {
            ((RefEntityImpl)this.getOwner()).removeChild(this);
        }
        for (RefElement refCallee : this.getOutReferences()) {
            refCallee.getInReferences().remove(this);
        }
        for (RefElement refCaller : this.getInReferences()) {
            refCaller.getOutReferences().remove(this);
        }
    }

    @Nullable
    public String getURL() {
        PsiElement element = this.getElement();
        if (element == null || !element.isPhysical()) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return virtualFile.getUrl() + "#" + element.getTextOffset();
    }

    protected abstract void initialize();

    public void addSuppression(String text) {
        this.mySuppressions = text.split("[, ]");
    }

    public boolean isSuppressed(String ... toolId) {
        RefEntity entity;
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/reference/RefElementImpl", "isSuppressed"));
        }
        if (this.mySuppressions != null) {
            for (String suppression : this.mySuppressions) {
                for (String id : toolId) {
                    if (!suppression.equals(id)) continue;
                    return true;
                }
                if (!suppression.equalsIgnoreCase("ALL")) continue;
                return true;
            }
        }
        return (entity = this.getOwner()) instanceof RefElementImpl && ((RefElementImpl)entity).isSuppressed(toolId);
    }
}

