/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InheritedJdkOrderEntryImpl
extends LibraryOrderEntryBaseImpl
implements InheritedJdkOrderEntry,
ClonableOrderEntry,
WritableOrderEntry {
    @NonNls
    public static final String ENTRY_TYPE = "inheritedJdk";
    private final MyJdkTableListener myJdkTableListener = new MyJdkTableListener();
    private final MyProjectJdkListener myListener = new MyProjectJdkListener();

    InheritedJdkOrderEntryImpl(RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) {
        super(rootModel, projectRootManager);
        this.myProjectRootManagerImpl.addProjectJdkListener(this.myListener);
        this.myProjectRootManagerImpl.addJdkTableListener(this.myJdkTableListener);
        this.init();
    }

    InheritedJdkOrderEntryImpl(Element element, RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        this(rootModel, projectRootManager);
        if (!element.getName().equals("orderEntry")) {
            throw new InvalidDataException(element.getName());
        }
    }

    @Override
    public OrderEntry cloneEntry(RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        return new InheritedJdkOrderEntryImpl(rootModel, projectRootManager);
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public boolean isValid() {
        return !this.isDisposed() && this.getJdk() != null;
    }

    @Override
    public <R> R accept(RootPolicy<R> policy, R initialValue) {
        return policy.visitInheritedJdkOrderEntry(this, initialValue);
    }

    @Override
    public void writeExternal(Element rootElement) throws WriteExternalException {
        Element orderEntryElement = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        rootElement.addContent(orderEntryElement);
    }

    @Override
    public Sdk getJdk() {
        Project project = this.getRootModel().getModule().getProject();
        return this.getRootModel().getConfigurationAccessor().getProjectSdk(project);
    }

    @Override
    public String getJdkName() {
        Project project = this.getRootModel().getModule().getProject();
        return this.getRootModel().getConfigurationAccessor().getProjectSdkName(project);
    }

    @Override
    protected RootProvider getRootProvider() {
        Sdk projectJdk = this.myProjectRootManagerImpl.getProjectSdk();
        return projectJdk == null ? null : projectJdk.getRootProvider();
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = "< " + this.getJdkName() + " >";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/InheritedJdkOrderEntryImpl", "getPresentableName"));
        }
        return string;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myProjectRootManagerImpl.removeJdkTableListener(this.myJdkTableListener);
        this.myProjectRootManagerImpl.removeProjectJdkListener(this.myListener);
    }

    private class MyProjectJdkListener
    implements ProjectRootManagerEx.ProjectJdkListener {
        private MyProjectJdkListener() {
        }

        @Override
        public void projectJdkChanged() {
            InheritedJdkOrderEntryImpl.this.updateFromRootProviderAndSubscribe();
        }
    }

    private class MyJdkTableListener
    implements ProjectJdkTable.Listener {
        private MyJdkTableListener() {
        }

        @Override
        public void jdkRemoved(Sdk jdk) {
            if (jdk.equals(InheritedJdkOrderEntryImpl.this.getJdk())) {
                InheritedJdkOrderEntryImpl.this.updateFromRootProviderAndSubscribe();
            }
        }

        @Override
        public void jdkAdded(Sdk jdk) {
            if (this.isAffectedByJdk(jdk)) {
                InheritedJdkOrderEntryImpl.this.updateFromRootProviderAndSubscribe();
            }
        }

        @Override
        public void jdkNameChanged(Sdk jdk, String previousName) {
            if (this.isAffectedByJdk(jdk)) {
                InheritedJdkOrderEntryImpl.this.updateFromRootProviderAndSubscribe();
            }
        }

        private boolean isAffectedByJdk(Sdk jdk) {
            return jdk.getName().equals(InheritedJdkOrderEntryImpl.this.getJdkName());
        }
    }
}

