/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeFieldFinalFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonFinalFieldInEnumInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.final.field.in.enum.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/NonFinalFieldInEnumInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass enumClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("non.final.field.in.enum.problem.descriptor", enumClass.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/NonFinalFieldInEnumInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[1];
        return MakeFieldFinalFix.buildFix(field);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonFinalFieldInEnumVisitor();
    }

    private static class NonFinalFieldInEnumVisitor
    extends BaseInspectionVisitor {
        private NonFinalFieldInEnumVisitor() {
        }

        @Override
        public void visitField(PsiField field) {
            super.visitField(field);
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null || !containingClass.isEnum()) {
                return;
            }
            if (field.hasModifierProperty("final")) {
                return;
            }
            this.registerFieldError(field, containingClass, field);
        }
    }
}

