/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyCatchBlockInspectionBase
extends BaseInspection {
    public boolean m_includeComments = true;
    public boolean m_ignoreTestCases = true;
    public boolean m_ignoreIgnoreParameter = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("empty.catch.block.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/EmptyCatchBlockInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("empty.catch.block.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/EmptyCatchBlockInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("empty.catch.block.comments.option", new Object[0]), "m_includeComments");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("empty.catch.block.ignore.ignore.option", new Object[0]), "m_ignoreIgnoreParameter");
        return optionsPanel;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new EmptyCatchBlockFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyCatchBlockVisitor();
    }

    private class EmptyCatchBlockVisitor
    extends BaseInspectionVisitor {
        private EmptyCatchBlockVisitor() {
        }

        @Override
        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiCatchSection[] catchSections;
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/EmptyCatchBlockInspectionBase$EmptyCatchBlockVisitor", "visitTryStatement"));
            }
            super.visitTryStatement(statement);
            for (PsiCatchSection section : catchSections = statement.getCatchSections()) {
                this.checkCatchSection(section);
            }
        }

        private void checkCatchSection(PsiCatchSection section) {
            PsiCodeBlock block = section.getCatchBlock();
            if (block == null || !this.isEmpty(block)) {
                return;
            }
            PsiParameter parameter = section.getParameter();
            if (parameter == null) {
                return;
            }
            PsiIdentifier identifier = parameter.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            String parameterName = parameter.getName();
            if (EmptyCatchBlockInspectionBase.this.m_ignoreIgnoreParameter && PsiUtil.isIgnoredName(parameterName)) {
                return;
            }
            PsiElement catchToken = section.getFirstChild();
            if (catchToken == null) {
                return;
            }
            this.registerError(catchToken, catchToken);
        }

        private boolean isEmpty(PsiElement element) {
            if (!EmptyCatchBlockInspectionBase.this.m_includeComments && element instanceof PsiComment) {
                return true;
            }
            if (element instanceof PsiEmptyStatement) {
                if (EmptyCatchBlockInspectionBase.this.m_includeComments) {
                    PsiElement[] children;
                    for (PsiElement child : children = element.getChildren()) {
                        if (!(child instanceof PsiComment)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (element instanceof PsiWhiteSpace) {
                return true;
            }
            if (element instanceof PsiBlockStatement) {
                PsiBlockStatement block = (PsiBlockStatement)element;
                return this.isEmpty(block.getCodeBlock());
            }
            if (element instanceof PsiCodeBlock) {
                PsiCodeBlock codeBlock = (PsiCodeBlock)element;
                PsiElement lastBodyElement = codeBlock.getLastBodyElement();
                for (PsiElement bodyElement = codeBlock.getFirstBodyElement(); bodyElement != null; bodyElement = bodyElement.getNextSibling()) {
                    if (!this.isEmpty(bodyElement)) {
                        return false;
                    }
                    if (bodyElement == lastBodyElement) break;
                }
                return true;
            }
            return false;
        }
    }

    private static class EmptyCatchBlockFix
    extends InspectionGadgetsFix {
        private EmptyCatchBlockFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/EmptyCatchBlockInspectionBase$EmptyCatchBlockFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("rename.catch.parameter.to.ignored", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/EmptyCatchBlockInspectionBase$EmptyCatchBlockFix", "getName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiCatchSection)) {
                return;
            }
            PsiCatchSection catchSection = (PsiCatchSection)parent;
            PsiParameter parameter = catchSection.getParameter();
            if (parameter == null) {
                return;
            }
            PsiIdentifier identifier = parameter.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance(project).getElementFactory();
            PsiIdentifier newIdentifier = factory.createIdentifier("ignored");
            identifier.replace(newIdentifier);
        }
    }
}

