/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class RefDirectoryImpl
extends RefElementImpl
implements RefDirectory {
    protected RefDirectoryImpl(PsiDirectory psiElement, RefManager refManager) {
        super(psiElement.getName(), psiElement, refManager);
        RefModuleImpl refModule;
        RefElementImpl refElement;
        PsiDirectory parentDirectory = psiElement.getParentDirectory();
        if (parentDirectory != null && parentDirectory.getManager().isInProject(parentDirectory) && (refElement = (RefElementImpl)refManager.getReference(parentDirectory)) != null) {
            refElement.add(this);
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement(psiElement);
        if (module != null && (refModule = (RefModuleImpl)refManager.getRefModule(module)) != null) {
            refModule.add(this);
            return;
        }
        ((RefProjectImpl)refManager.getRefProject()).add(this);
    }

    @Override
    public void accept(final @NotNull RefVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/reference/RefDirectoryImpl", "accept"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                visitor.visitDirectory(RefDirectoryImpl.this);
            }
        });
    }

    @Override
    protected void initialize() {
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefDirectoryImpl", "getQualifiedName"));
        }
        return string;
    }

    @Override
    public String getExternalName() {
        PsiElement element = this.getElement();
        assert (element != null);
        return ((PsiDirectory)element).getVirtualFile().getPath();
    }
}

