/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class IndexTodoCacheManagerImpl
implements TodoCacheManager {
    private final Project myProject;
    private final PsiManager myPsiManager;

    public IndexTodoCacheManagerImpl(PsiManager psiManager) {
        this.myPsiManager = psiManager;
        this.myProject = psiManager.getProject();
    }

    @Override
    @NotNull
    public PsiFile[] getFilesWithTodoItems() {
        if (this.myProject.isDefault()) {
            if (PsiFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "getFilesWithTodoItems"));
            }
            return PsiFile.EMPTY_ARRAY;
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        final HashSet allFiles = new HashSet();
        final ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
        for (IndexPattern indexPattern : IndexPatternUtil.getIndexPatterns()) {
            final Collection<VirtualFile> files = fileBasedIndex.getContainingFiles(TodoIndex.NAME, new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), GlobalSearchScope.allScope(this.myProject));
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    for (VirtualFile file : files) {
                        PsiFile psiFile;
                        if (!projectFileIndex.isInContent(file) || (psiFile = IndexTodoCacheManagerImpl.this.myPsiManager.findFile(file)) == null) continue;
                        allFiles.add(psiFile);
                    }
                }
            });
        }
        PsiFile[] psiFileArray = allFiles.isEmpty() ? PsiFile.EMPTY_ARRAY : PsiUtilCore.toPsiFileArray(allFiles);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "getFilesWithTodoItems"));
        }
        return psiFileArray;
    }

    @Override
    public int getTodoCount(@NotNull VirtualFile file, @NotNull IndexPatternProvider patternProvider) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "getTodoCount"));
        }
        if (patternProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternProvider", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "getTodoCount"));
        }
        if (this.myProject.isDefault()) {
            return 0;
        }
        if (file instanceof VirtualFileWindow) {
            return -1;
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        int count = 0;
        for (IndexPattern indexPattern : patternProvider.getIndexPatterns()) {
            count += this.fetchCount(fileBasedIndex, file, indexPattern);
        }
        return count;
    }

    @Override
    public int getTodoCount(@NotNull VirtualFile file, @NotNull IndexPattern pattern) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "getTodoCount"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "getTodoCount"));
        }
        if (this.myProject.isDefault()) {
            return 0;
        }
        if (file instanceof VirtualFileWindow) {
            return -1;
        }
        return this.fetchCount(FileBasedIndex.getInstance(), file, pattern);
    }

    private int fetchCount(@NotNull FileBasedIndex fileBasedIndex, @NotNull VirtualFile file, @NotNull IndexPattern indexPattern) {
        if (fileBasedIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBasedIndex", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "fetchCount"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "fetchCount"));
        }
        if (indexPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexPattern", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "fetchCount"));
        }
        final int[] count = new int[]{0};
        fileBasedIndex.processValues(TodoIndex.NAME, new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), file, new FileBasedIndex.ValueProcessor<Integer>(){

            @Override
            public boolean process(VirtualFile file, Integer value) {
                count[0] = count[0] + value;
                return true;
            }
        }, GlobalSearchScope.fileScope(this.myProject, file));
        return count[0];
    }
}

