/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.VariableUsedVisitor;
import org.jetbrains.annotations.NotNull;

class VariableValueUsedVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final PsiVariable variable;
    private boolean read;
    private boolean written;

    VariableValueUsedVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableValueUsedVisitor", "<init>"));
        }
        this.variable = variable;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/VariableValueUsedVisitor", "visitElement"));
        }
        if (this.read || this.written) {
            return;
        }
        super.visitElement(element);
    }

    @Override
    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/siyeh/ig/psiutils/VariableValueUsedVisitor", "visitAssignmentExpression"));
        }
        if (this.read || this.written) {
            return;
        }
        super.visitAssignmentExpression(assignment);
        PsiExpression lhs = assignment.getLExpression();
        if (lhs instanceof PsiReferenceExpression && this.variable.equals(target = (referenceExpression = (PsiReferenceExpression)lhs).resolve())) {
            this.written = true;
            return;
        }
        PsiExpression rhs = assignment.getRExpression();
        if (rhs == null) {
            return;
        }
        this.read = VariableUsedVisitor.isVariableUsedIn(this.variable, rhs);
    }

    @Override
    public void visitPrefixExpression(@NotNull PsiPrefixExpression prefixExpression) {
        if (prefixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression", "com/siyeh/ig/psiutils/VariableValueUsedVisitor", "visitPrefixExpression"));
        }
        if (this.read || this.written) {
            return;
        }
        super.visitPrefixExpression(prefixExpression);
        IElementType tokenType = prefixExpression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
            return;
        }
        PsiExpression operand = prefixExpression.getOperand();
        if (!(operand instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand;
        PsiElement target = referenceExpression.resolve();
        if (!this.variable.equals(target)) {
            return;
        }
        this.written = true;
    }

    @Override
    public void visitPostfixExpression(@NotNull PsiPostfixExpression postfixExpression) {
        if (postfixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfixExpression", "com/siyeh/ig/psiutils/VariableValueUsedVisitor", "visitPostfixExpression"));
        }
        if (this.read || this.written) {
            return;
        }
        super.visitPostfixExpression(postfixExpression);
        IElementType tokenType = postfixExpression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
            return;
        }
        PsiExpression operand = postfixExpression.getOperand();
        if (!(operand instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand;
        PsiElement target = referenceExpression.resolve();
        if (!this.variable.equals(target)) {
            return;
        }
        this.written = true;
    }

    @Override
    public void visitVariable(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableValueUsedVisitor", "visitVariable"));
        }
        if (this.read || this.written) {
            return;
        }
        super.visitVariable(variable);
        PsiExpression initalizer = variable.getInitializer();
        if (initalizer == null) {
            return;
        }
        this.read = VariableUsedVisitor.isVariableUsedIn(variable, initalizer);
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
        PsiExpression[] arguments;
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/psiutils/VariableValueUsedVisitor", "visitMethodCallExpression"));
        }
        if (this.read || this.written) {
            return;
        }
        super.visitMethodCallExpression(call);
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier != null && VariableUsedVisitor.isVariableUsedIn(this.variable, qualifier)) {
            this.read = true;
            return;
        }
        PsiExpressionList argumentList = call.getArgumentList();
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            if (!VariableUsedVisitor.isVariableUsedIn(this.variable, argument)) continue;
            this.read = true;
            return;
        }
    }

    @Override
    public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
        PsiExpression[] arguments;
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/siyeh/ig/psiutils/VariableValueUsedVisitor", "visitNewExpression"));
        }
        if (this.read || this.written) {
            return;
        }
        super.visitNewExpression(newExpression);
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            if (!VariableUsedVisitor.isVariableUsedIn(this.variable, argument)) continue;
            this.read = true;
            return;
        }
    }

    @Override
    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        PsiExpression[] arguments;
        if (this.read || this.written) {
            return;
        }
        super.visitArrayInitializerExpression(expression);
        for (PsiExpression argument : arguments = expression.getInitializers()) {
            if (!VariableUsedVisitor.isVariableUsedIn(this.variable, argument)) continue;
            this.read = true;
            return;
        }
    }

    @Override
    public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
        if (returnStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "com/siyeh/ig/psiutils/VariableValueUsedVisitor", "visitReturnStatement"));
        }
        if (this.read || this.written) {
            return;
        }
        super.visitReturnStatement(returnStatement);
        PsiExpression returnValue = returnStatement.getReturnValue();
        if (returnValue == null) {
            return;
        }
        this.read = VariableUsedVisitor.isVariableUsedIn(this.variable, returnValue);
    }

    @Override
    public void visitClass(PsiClass aClass) {
        if (this.read || this.written) {
            return;
        }
        super.visitClass(aClass);
        this.read = VariableUsedVisitor.isVariableUsedIn(this.variable, aClass);
    }

    boolean isVariableValueUsed() {
        return this.read;
    }
}

