/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class SafeLockInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("LockAcquiredButNotSafelyReleased" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SafeLockInspection", "getID"));
        }
        return "LockAcquiredButNotSafelyReleased";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("safe.lock.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SafeLockInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        PsiType type = expression.getType();
        assert (type != null);
        String text = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("safe.lock.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SafeLockInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SafeLockVisitor();
    }

    private static enum LockType {
        READ,
        WRITE,
        REGULAR;

    }

    private static class UnlockVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean containsUnlock;
        private final PsiVariable variable;
        private final LockType type;

        private UnlockVisitor(@NotNull PsiVariable variable, @NotNull LockType type) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/threading/SafeLockInspection$UnlockVisitor", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/siyeh/ig/threading/SafeLockInspection$UnlockVisitor", "<init>"));
            }
            this.variable = variable;
            this.type = type;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/threading/SafeLockInspection$UnlockVisitor", "visitElement"));
            }
            if (!this.containsUnlock) {
                super.visitElement(element);
            }
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/threading/SafeLockInspection$UnlockVisitor", "visitMethodCallExpression"));
            }
            if (this.containsUnlock) {
                return;
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"unlock".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier instanceof PsiReferenceExpression) {
                if (this.type != LockType.REGULAR) {
                    return;
                }
                PsiReference reference = (PsiReference)((Object)qualifier);
                PsiElement target = reference.resolve();
                if (this.variable.equals(target)) {
                    this.containsUnlock = true;
                }
            } else if (qualifier instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)qualifier;
                PsiReferenceExpression methodExpression1 = methodCallExpression.getMethodExpression();
                String methodName1 = methodExpression1.getReferenceName();
                if (this.type == LockType.READ && "readLock".equals(methodName1) || this.type == LockType.WRITE && "writeLock".equals(methodName1)) {
                    PsiExpression qualifierExpression = methodExpression1.getQualifierExpression();
                    if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                        return;
                    }
                    PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
                    PsiElement target = referenceExpression.resolve();
                    if (this.variable.equals(target)) {
                        this.containsUnlock = true;
                    }
                }
            }
        }

        boolean containsUnlock() {
            return this.containsUnlock;
        }
    }

    private static class SafeLockVisitor
    extends BaseInspectionVisitor {
        private SafeLockVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            LockType type;
            PsiVariable boundVariable;
            PsiReferenceExpression referenceExpression;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/SafeLockInspection$SafeLockVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            if (!SafeLockVisitor.isLockAcquireMethod(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression instanceof PsiReferenceExpression) {
                referenceExpression = (PsiReferenceExpression)qualifierExpression;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                boundVariable = (PsiVariable)target;
                type = LockType.REGULAR;
            } else if (qualifierExpression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)qualifierExpression;
                PsiReferenceExpression methodExpression1 = methodCallExpression.getMethodExpression();
                String methodName = methodExpression1.getReferenceName();
                if ("readLock".equals(methodName)) {
                    type = LockType.READ;
                } else if ("writeLock".equals(methodName)) {
                    type = LockType.WRITE;
                } else {
                    return;
                }
                PsiExpression qualifierExpression1 = methodExpression1.getQualifierExpression();
                if (!(qualifierExpression1 instanceof PsiReferenceExpression)) {
                    return;
                }
                referenceExpression = (PsiReferenceExpression)qualifierExpression1;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                boundVariable = (PsiVariable)target;
            } else {
                return;
            }
            PsiStatement statement = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class);
            if (statement == null) {
                return;
            }
            PsiStatement nextStatement = PsiTreeUtil.getNextSiblingOfType(statement, PsiStatement.class);
            if (!(nextStatement instanceof PsiTryStatement)) {
                this.registerError((PsiElement)expression, referenceExpression);
                return;
            }
            PsiTryStatement tryStatement = (PsiTryStatement)nextStatement;
            if (SafeLockVisitor.lockIsUnlockedInFinally(tryStatement, boundVariable, type)) {
                return;
            }
            this.registerError((PsiElement)expression, referenceExpression);
        }

        private static boolean lockIsUnlockedInFinally(PsiTryStatement tryStatement, PsiVariable boundVariable, LockType type) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock == null) {
                return false;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return false;
            }
            UnlockVisitor visitor = new UnlockVisitor(boundVariable, type);
            finallyBlock.accept(visitor);
            return visitor.containsUnlock();
        }

        private static boolean isLockAcquireMethod(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"lock".equals(methodName) && !"lockInterruptibly".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            return TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.concurrent.locks.Lock");
        }
    }
}

