/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WhitespacesBinders {
    public static final WhitespacesAndCommentsBinder DEFAULT_RIGHT_BINDER = new WhitespacesAndCommentsBinder(){

        @Override
        public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            return 0;
        }
    };
    public static final WhitespacesAndCommentsBinder DEFAULT_LEFT_BINDER = new WhitespacesAndCommentsBinder(){

        @Override
        public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            return tokens.size();
        }
    };
    public static final WhitespacesAndCommentsBinder GREEDY_LEFT_BINDER = DEFAULT_RIGHT_BINDER;
    public static final WhitespacesAndCommentsBinder GREEDY_RIGHT_BINDER = DEFAULT_LEFT_BINDER;

    private WhitespacesBinders() {
    }

    public static WhitespacesAndCommentsBinder leadingCommentsBinder(final @NotNull TokenSet commentTypes) {
        if (commentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commentTypes", "com/intellij/lang/WhitespacesBinders", "leadingCommentsBinder"));
        }
        return new WhitespacesAndCommentsBinder(){

            @Override
            public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
                int i;
                for (i = 0; i < tokens.size() && !commentTypes.contains(tokens.get(i)); ++i) {
                }
                return i;
            }
        };
    }

    public static WhitespacesAndCommentsBinder trailingCommentsBinder(final @NotNull TokenSet commentTypes) {
        if (commentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commentTypes", "com/intellij/lang/WhitespacesBinders", "trailingCommentsBinder"));
        }
        return new WhitespacesAndCommentsBinder(){

            @Override
            public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
                int i;
                for (i = tokens.size() - 1; i >= 0 && !commentTypes.contains(tokens.get(i)); --i) {
                }
                return i + 1;
            }
        };
    }
}

