/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.XmlRefCountHolder;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlUnusedNamespaceInspection
extends XmlSuppressableInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            @Override
            public void visitXmlAttribute(XmlAttribute attribute) {
                PsiFile file = holder.getFile();
                if (!(file instanceof XmlFile)) {
                    return;
                }
                XmlRefCountHolder refCountHolder = XmlRefCountHolder.getRefCountHolder((XmlFile)file);
                if (refCountHolder == null) {
                    return;
                }
                if (!attribute.isNamespaceDeclaration()) {
                    XmlUnusedNamespaceInspection.checkUnusedLocations(attribute, holder, refCountHolder);
                    return;
                }
                String namespace = attribute.getValue();
                String declaredPrefix = XmlUnusedNamespaceInspection.getDeclaredPrefix(attribute);
                if (namespace != null && !refCountHolder.isInUse(declaredPrefix)) {
                    ImplicitUsageProvider[] implicitUsageProviders;
                    for (ImplicitUsageProvider provider : implicitUsageProviders = Extensions.getExtensions(ImplicitUsageProvider.EP_NAME)) {
                        if (!provider.isImplicitUsage(attribute)) continue;
                        return;
                    }
                    XmlAttributeValue value = attribute.getValueElement();
                    assert (value != null);
                    holder.registerProblem((PsiElement)attribute, XmlBundle.message("xml.inspections.unused.schema.declaration", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new RemoveNamespaceDeclarationFix(declaredPrefix, false, !refCountHolder.isUsedNamespace(namespace)));
                    XmlTag parent = attribute.getParent();
                    if (declaredPrefix.isEmpty()) {
                        XmlAttribute location = XmlUnusedNamespaceInspection.getDefaultLocation(parent);
                        if (location != null) {
                            holder.registerProblem((PsiElement)location, XmlBundle.message("xml.inspections.unused.schema.location", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new RemoveNamespaceDeclarationFix(declaredPrefix, true, true));
                        }
                    } else if (!refCountHolder.isUsedNamespace(namespace)) {
                        for (PsiReference reference : XmlUnusedNamespaceInspection.getLocationReferences(namespace, parent)) {
                            if (XmlHighlightVisitor.hasBadResolve(reference, false)) continue;
                            holder.registerProblemForReference(reference, ProblemHighlightType.LIKE_UNUSED_SYMBOL, XmlBundle.message("xml.inspections.unused.schema.location", new Object[0]), new RemoveNamespaceDeclarationFix(declaredPrefix, true, true));
                        }
                    }
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    private static void removeReferencesOrAttribute(PsiReference[] references) {
        if (references.length == 0) {
            return;
        }
        XmlAttributeValue element = (XmlAttributeValue)references[0].getElement();
        XmlAttribute attribute = (XmlAttribute)element.getParent();
        if (element.getReferences().length == references.length) {
            attribute.delete();
            return;
        }
        PsiFile file = element.getContainingFile();
        Project project = file.getProject();
        SmartPsiElementPointer<XmlAttribute> pointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(attribute);
        for (PsiReference reference : references) {
            RemoveNamespaceDeclarationFix.removeReferenceText(reference);
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project);
        Document document = documentManager.getDocument(file);
        assert (document != null);
        documentManager.commitDocument(document);
        String trimmed = element.getValue().trim();
        XmlAttribute pointerElement = pointer.getElement();
        assert (pointerElement != null);
        pointerElement.setValue(trimmed);
    }

    private static void checkUnusedLocations(XmlAttribute attribute, ProblemsHolder holder, @NotNull XmlRefCountHolder refCountHolder) {
        if (refCountHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refCountHolder", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection", "checkUnusedLocations"));
        }
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(attribute.getNamespace())) {
            if ("noNamespaceSchemaLocation".equals(attribute.getLocalName())) {
                if (refCountHolder.isInUse("")) {
                    return;
                }
                holder.registerProblem((PsiElement)attribute, XmlBundle.message("xml.inspections.unused.schema.location", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new RemoveNamespaceLocationFix(""));
            } else if ("schemaLocation".equals(attribute.getLocalName())) {
                XmlAttributeValue value = attribute.getValueElement();
                if (value == null) {
                    return;
                }
                PsiReference[] references = value.getReferences();
                int referencesLength = references.length;
                for (int i = 0; i < referencesLength; ++i) {
                    PsiReference nextRef;
                    PsiReference reference = references[i];
                    if (!(reference instanceof URLReference)) continue;
                    String ns = XmlUnusedNamespaceInspection.getNamespaceFromReference(reference);
                    if (ArrayUtil.indexOf(attribute.getParent().knownNamespaces(), ns) != -1 || refCountHolder.isUsedNamespace(ns)) continue;
                    if (!XmlHighlightVisitor.hasBadResolve(reference, false)) {
                        holder.registerProblemForReference(reference, ProblemHighlightType.LIKE_UNUSED_SYMBOL, XmlBundle.message("xml.inspections.unused.schema.location", new Object[0]), new RemoveNamespaceLocationFix(ns));
                    }
                    for (int j = i + 1; j < referencesLength && !((nextRef = references[j]) instanceof URLReference); ++j) {
                        if (XmlHighlightVisitor.hasBadResolve(nextRef, false)) continue;
                        holder.registerProblemForReference(nextRef, ProblemHighlightType.LIKE_UNUSED_SYMBOL, XmlBundle.message("xml.inspections.unused.schema.location", new Object[0]), new RemoveNamespaceLocationFix(ns));
                    }
                }
            }
        }
    }

    private static String getDeclaredPrefix(XmlAttribute attribute) {
        return attribute.getName().contains(":") ? attribute.getLocalName() : "";
    }

    @Nullable
    private static XmlAttribute getDefaultLocation(XmlTag parent) {
        return parent.getAttribute("noNamespaceSchemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
    }

    private static PsiReference[] getLocationReferences(String namespace, XmlTag tag) {
        XmlAttribute locationAttr = tag.getAttribute("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
        if (locationAttr == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        XmlAttributeValue value = locationAttr.getValueElement();
        return value == null ? PsiReference.EMPTY_ARRAY : XmlUnusedNamespaceInspection.getLocationReferences(namespace, value);
    }

    private static PsiReference[] getLocationReferences(String namespace, XmlAttributeValue value) {
        PsiReference[] references = value.getReferences();
        int referencesLength = references.length;
        for (int i = 0; i < referencesLength; i += 2) {
            PsiReference reference = references[i];
            if (!namespace.equals(XmlUnusedNamespaceInspection.getNamespaceFromReference(reference))) continue;
            if (i + 1 < referencesLength) {
                return new PsiReference[]{references[i + 1], reference};
            }
            return new PsiReference[]{reference};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static String getNamespaceFromReference(PsiReference reference) {
        return reference.getRangeInElement().substring(reference.getElement().getText());
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = XmlInspectionGroupNames.XML_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message("xml.inspections.unused.schema", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("XmlUnusedNamespaceDeclaration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection", "getShortName"));
        }
        return "XmlUnusedNamespaceDeclaration";
    }

    public static class RemoveNamespaceLocationFix
    extends RemoveNamespaceDeclarationFix {
        public static final String NAME = "Remove unused namespace location";

        private RemoveNamespaceLocationFix(String namespace) {
            super(namespace, true, true);
        }

        @Override
        @NotNull
        public String getName() {
            if (NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection$RemoveNamespaceLocationFix", "getName"));
            }
            return NAME;
        }

        @Override
        protected void doRemove(Project project, XmlAttribute attribute, XmlTag parent) {
            if (StringUtil.isEmpty(this.myPrefix)) {
                attribute.delete();
            } else {
                XmlAttributeValue value = attribute.getValueElement();
                if (value == null) {
                    return;
                }
                PsiReference[] references = XmlUnusedNamespaceInspection.getLocationReferences(this.myPrefix, value);
                XmlUnusedNamespaceInspection.removeReferencesOrAttribute(references);
            }
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    }

    public static class RemoveNamespaceDeclarationFix
    implements LocalQuickFix {
        protected final String myPrefix;
        private final boolean myLocationFix;
        private final boolean myRemoveLocation;

        private RemoveNamespaceDeclarationFix(@Nullable String prefix, boolean locationFix, boolean removeLocation) {
            this.myPrefix = prefix;
            this.myLocationFix = locationFix;
            this.myRemoveLocation = removeLocation;
        }

        @Override
        @NotNull
        public String getName() {
            String string = XmlBundle.message("xml.inspections.unused.schema.remove", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection$RemoveNamespaceDeclarationFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = XmlInspectionGroupNames.XML_INSPECTIONS;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection$RemoveNamespaceDeclarationFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection$RemoveNamespaceDeclarationFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection$RemoveNamespaceDeclarationFix", "applyFix"));
            }
            this.doFix(project, descriptor, true);
        }

        @Nullable
        public SmartPsiElementPointer<XmlTag> doFix(Project project, ProblemDescriptor descriptor, boolean reformat) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof XmlAttributeValue) {
                element = element.getParent();
            } else if (!(element instanceof XmlAttribute)) {
                return null;
            }
            XmlAttribute attribute = (XmlAttribute)element;
            XmlTag parent = attribute.getParent();
            if (!FileModificationService.getInstance().prepareFileForWrite(parent.getContainingFile())) {
                return null;
            }
            SmartPsiElementPointer<XmlTag> pointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(parent);
            this.doRemove(project, attribute, parent);
            if (reformat) {
                RemoveNamespaceDeclarationFix.reformatStartTag(project, pointer);
            }
            return pointer;
        }

        public static void reformatStartTag(Project project, SmartPsiElementPointer<XmlTag> pointer) {
            PsiDocumentManager manager = PsiDocumentManager.getInstance(project);
            PsiFile file = pointer.getContainingFile();
            assert (file != null);
            Document document = manager.getDocument(file);
            assert (document != null);
            manager.commitDocument(document);
            XmlTag tag = pointer.getElement();
            assert (tag != null);
            XmlUtil.reformatTagStart(tag);
        }

        protected void doRemove(Project project, XmlAttribute attribute, XmlTag parent) {
            SchemaPrefix schemaPrefix;
            if (!attribute.isNamespaceDeclaration() && (schemaPrefix = XmlExtension.DEFAULT_EXTENSION.getPrefixDeclaration(parent, this.myPrefix)) != null) {
                attribute = schemaPrefix.getDeclaration();
            }
            String namespace = attribute.getValue();
            String prefix = XmlUnusedNamespaceInspection.getDeclaredPrefix(attribute);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project);
            Document document = documentManager.getDocument(attribute.getContainingFile());
            assert (document != null);
            attribute.delete();
            if (this.myRemoveLocation) {
                if (prefix.isEmpty()) {
                    XmlAttribute locationAttr = XmlUnusedNamespaceInspection.getDefaultLocation(parent);
                    if (locationAttr != null) {
                        locationAttr.delete();
                    }
                } else {
                    documentManager.doPostponedOperationsAndUnblockDocument(document);
                    PsiReference[] references = XmlUnusedNamespaceInspection.getLocationReferences(namespace, parent);
                    XmlUnusedNamespaceInspection.removeReferencesOrAttribute(references);
                    documentManager.commitDocument(document);
                }
            }
        }

        public static void removeReferenceText(PsiReference ref) {
            PsiElement element = ref.getElement();
            PsiFile file = element.getContainingFile();
            TextRange range = ref.getRangeInElement().shiftRight(element.getTextRange().getStartOffset());
            PsiDocumentManager manager = PsiDocumentManager.getInstance(file.getProject());
            Document document = manager.getDocument(file);
            assert (document != null);
            manager.doPostponedOperationsAndUnblockDocument(document);
            document.deleteString(range.getStartOffset(), range.getEndOffset());
        }

        public boolean equals(Object obj) {
            return obj instanceof RemoveNamespaceDeclarationFix && Comparing.equal(this.myPrefix, ((RemoveNamespaceDeclarationFix)obj).myPrefix) && (this.myLocationFix || ((RemoveNamespaceDeclarationFix)obj).myLocationFix);
        }

        public int hashCode() {
            return this.myPrefix == null ? 0 : this.myPrefix.hashCode();
        }
    }
}

