/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StateQueue;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataFlowRunner {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.dataFlow.DataFlowRunner");
    private static final Key<Integer> TOO_EXPENSIVE_HASH = Key.create("TOO_EXPENSIVE_HASH");
    private Instruction[] myInstructions;
    private final MultiMap<PsiElement, DfaMemoryState> myNestedClosures = new MultiMap();
    private final DfaValueFactory myValueFactory;
    public static final int MAX_STATES_PER_BRANCH = 300;

    protected DataFlowRunner() {
        this(false, true);
    }

    protected DataFlowRunner(boolean unknownMembersAreNullable, boolean honorFieldInitializers) {
        this.myValueFactory = new DfaValueFactory(honorFieldInitializers, unknownMembersAreNullable);
    }

    public DfaValueFactory getFactory() {
        return this.myValueFactory;
    }

    @Nullable
    private Collection<DfaMemoryState> createInitialStates(@NotNull PsiElement psiBlock, InstructionVisitor visitor) {
        if (psiBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiBlock", "com/intellij/codeInspection/dataFlow/DataFlowRunner", "createInitialStates"));
        }
        PsiClass containingClass = PsiTreeUtil.getParentOfType(psiBlock, PsiClass.class);
        if (containingClass != null && PsiUtil.isLocalOrAnonymousClass(containingClass)) {
            PsiElement parent = containingClass.getParent();
            PsiCodeBlock block = DfaPsiUtil.getTopmostBlockInSameClass(parent);
            if ((parent instanceof PsiNewExpression || parent instanceof PsiDeclarationStatement) && block != null) {
                Collection<DfaMemoryState> closureStates;
                RunnerResult result = this.analyzeMethod(block, visitor);
                if (result == RunnerResult.OK && !(closureStates = this.myNestedClosures.get(DfaPsiUtil.getTopmostBlockInSameClass(psiBlock))).isEmpty()) {
                    return closureStates;
                }
                return null;
            }
        }
        return Collections.singletonList(this.createMemoryState());
    }

    public final RunnerResult analyzeMethod(@NotNull PsiElement psiBlock, InstructionVisitor visitor) {
        if (psiBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiBlock", "com/intellij/codeInspection/dataFlow/DataFlowRunner", "analyzeMethod"));
        }
        Collection<DfaMemoryState> initialStates = this.createInitialStates(psiBlock, visitor);
        return initialStates == null ? RunnerResult.NOT_APPLICABLE : this.analyzeMethod(psiBlock, visitor, false, initialStates);
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public final RunnerResult analyzeMethod(@NotNull PsiElement psiBlock, InstructionVisitor visitor, boolean ignoreAssertions, @NotNull Collection<DfaMemoryState> initialStates) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleStepOutOfLoop(final @NotNull Instruction prevInstruction, @NotNull Instruction nextInstruction, final @NotNull int[] loopNumber, MultiMap<BranchingInstruction, DfaMemoryState> processedStates, MultiMap<BranchingInstruction, DfaMemoryState> incomingStates, List<DfaInstructionState> inFlightStates, DfaInstructionState[] afterStates, StateQueue queue) {
        if (prevInstruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevInstruction", "com/intellij/codeInspection/dataFlow/DataFlowRunner", "handleStepOutOfLoop"));
        }
        if (nextInstruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nextInstruction", "com/intellij/codeInspection/dataFlow/DataFlowRunner", "handleStepOutOfLoop"));
        }
        if (loopNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopNumber", "com/intellij/codeInspection/dataFlow/DataFlowRunner", "handleStepOutOfLoop"));
        }
        if (loopNumber[prevInstruction.getIndex()] == 0 || DataFlowRunner.inSameLoop(prevInstruction, nextInstruction, loopNumber)) {
            return;
        }
        for (DfaInstructionState state : inFlightStates) {
            Instruction instruction = state.getInstruction();
            if (!DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber)) continue;
            return;
        }
        for (DfaInstructionState state : afterStates) {
            Instruction instruction = state.getInstruction();
            if (!DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber)) continue;
            return;
        }
        if (!queue.processAll((Processor<? super DfaInstructionState>)new Processor<DfaInstructionState>(){

            @Override
            public boolean process(DfaInstructionState state) {
                Instruction instruction = state.getInstruction();
                return !DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber);
            }
        })) {
            return;
        }
        THashSet mayRemoveStatesFor = new THashSet();
        for (Instruction instruction : this.myInstructions) {
            if (!DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber) || !(instruction instanceof BranchingInstruction)) continue;
            mayRemoveStatesFor.add((BranchingInstruction)instruction);
        }
        for (Instruction instruction : mayRemoveStatesFor) {
            processedStates.remove((BranchingInstruction)instruction);
            incomingStates.remove((BranchingInstruction)instruction);
        }
    }

    private static boolean inSameLoop(@NotNull Instruction prevInstruction, @NotNull Instruction nextInstruction, @NotNull int[] loopNumber) {
        if (prevInstruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevInstruction", "com/intellij/codeInspection/dataFlow/DataFlowRunner", "inSameLoop"));
        }
        if (nextInstruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nextInstruction", "com/intellij/codeInspection/dataFlow/DataFlowRunner", "inSameLoop"));
        }
        if (loopNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopNumber", "com/intellij/codeInspection/dataFlow/DataFlowRunner", "inSameLoop"));
        }
        return loopNumber[nextInstruction.getIndex()] == loopNumber[prevInstruction.getIndex()];
    }

    protected boolean shouldCheckTimeLimit() {
        return !ApplicationManager.getApplication().isUnitTestMode();
    }

    protected DfaInstructionState[] acceptInstruction(InstructionVisitor visitor, DfaInstructionState instructionState) {
        Instruction instruction = instructionState.getInstruction();
        PsiElement closure = DfaUtil.getClosureInside(instruction);
        if (closure instanceof PsiClass) {
            this.registerNestedClosures(instructionState, (PsiClass)closure);
        } else if (closure instanceof PsiLambdaExpression) {
            this.registerNestedClosures(instructionState, (PsiLambdaExpression)closure);
        }
        return instruction.accept(this, instructionState.getMemoryState(), visitor);
    }

    private void registerNestedClosures(DfaInstructionState instructionState, PsiClass nestedClass) {
        DfaMemoryState state = instructionState.getMemoryState();
        for (PsiMethod psiMethod : nestedClass.getMethods()) {
            PsiCodeBlock body = psiMethod.getBody();
            if (body == null) continue;
            this.myNestedClosures.putValue(body, DataFlowRunner.createClosureState(state));
        }
        for (PsiMember psiMember : nestedClass.getInitializers()) {
            this.myNestedClosures.putValue(psiMember.getBody(), DataFlowRunner.createClosureState(state));
        }
        for (PsiMember psiMember : nestedClass.getFields()) {
            this.myNestedClosures.putValue(psiMember, DataFlowRunner.createClosureState(state));
        }
    }

    private void registerNestedClosures(DfaInstructionState instructionState, PsiLambdaExpression expr) {
        DfaMemoryState state = instructionState.getMemoryState();
        PsiElement body = expr.getBody();
        if (body != null) {
            this.myNestedClosures.putValue(body, DataFlowRunner.createClosureState(state));
        }
    }

    protected DfaMemoryState createMemoryState() {
        return new DfaMemoryStateImpl(this.myValueFactory);
    }

    public Instruction[] getInstructions() {
        return this.myInstructions;
    }

    public Instruction getInstruction(int index) {
        return this.myInstructions[index];
    }

    public MultiMap<PsiElement, DfaMemoryState> getNestedClosures() {
        return new MultiMap<PsiElement, DfaMemoryState>(this.myNestedClosures);
    }

    public Pair<Set<Instruction>, Set<Instruction>> getConstConditionalExpressions() {
        BranchingInstruction branchingInstruction;
        HashSet<BranchingInstruction> trueSet = new HashSet<BranchingInstruction>();
        HashSet<BranchingInstruction> falseSet = new HashSet<BranchingInstruction>();
        for (Instruction instruction : this.myInstructions) {
            if (!(instruction instanceof BranchingInstruction) || (branchingInstruction = (BranchingInstruction)instruction).getPsiAnchor() == null || !branchingInstruction.isConditionConst()) continue;
            if (!branchingInstruction.isTrueReachable()) {
                falseSet.add(branchingInstruction);
            }
            if (branchingInstruction.isFalseReachable()) continue;
            trueSet.add(branchingInstruction);
        }
        for (Instruction instruction : this.myInstructions) {
            if (!(instruction instanceof BranchingInstruction)) continue;
            branchingInstruction = (BranchingInstruction)instruction;
            if (branchingInstruction.isTrueReachable()) {
                falseSet.remove(branchingInstruction);
            }
            if (!branchingInstruction.isFalseReachable()) continue;
            trueSet.remove(branchingInstruction);
        }
        return Pair.create(trueSet, falseSet);
    }

    private static DfaMemoryStateImpl createClosureState(DfaMemoryState memState) {
        DfaMemoryStateImpl copy = (DfaMemoryStateImpl)memState.createCopy();
        copy.flushFields();
        HashSet<DfaVariableValue> vars = new HashSet<DfaVariableValue>(copy.getVariableStates().keySet());
        for (DfaVariableValue value : vars) {
            copy.flushDependencies(value);
        }
        copy.emptyStack();
        return copy;
    }
}

