/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PsiDiamondType
extends PsiType {
    public static final RecursionGuard ourDiamondGuard = RecursionManager.createGuard("diamondInference");

    public PsiDiamondType(PsiAnnotation[] annotations) {
        super(annotations);
    }

    public abstract DiamondInferenceResult resolveInferredTypes();

    public static class DiamondInferenceResult {
        public static final DiamondInferenceResult EXPLICIT_CONSTRUCTOR_TYPE_ARGS = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondType$DiamondInferenceResult$1", "getTypes"));
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot use diamonds with explicit type parameters for constructor";
            }
        };
        public static final DiamondInferenceResult NULL_RESULT = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondType$DiamondInferenceResult$2", "getTypes"));
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot infer arguments";
            }
        };
        public static final DiamondInferenceResult UNRESOLVED_CONSTRUCTOR = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondType$DiamondInferenceResult$3", "getTypes"));
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot infer arguments (unable to resolve constructor)";
            }
        };
        public static final DiamondInferenceResult ANONYMOUS_INNER_RESULT = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondType$DiamondInferenceResult$4", "getTypes"));
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot use ''<>'' with anonymous inner classes";
            }
        };
        private final List<PsiType> myInferredTypes = new ArrayList<PsiType>();
        private String myErrorMessage;
        private String myNewExpressionPresentableText;

        public DiamondInferenceResult() {
        }

        public DiamondInferenceResult(String expressionPresentableText) {
            this.myNewExpressionPresentableText = expressionPresentableText;
        }

        @NotNull
        public PsiType[] getTypes() {
            PsiType[] psiTypeArray = this.myErrorMessage == null ? this.myInferredTypes.toArray(PsiType.createArray(this.myInferredTypes.size())) : PsiType.EMPTY_ARRAY;
            if (psiTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondType$DiamondInferenceResult", "getTypes"));
            }
            return psiTypeArray;
        }

        public List<PsiType> getInferredTypes() {
            return this.myInferredTypes;
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public boolean failedToInfer() {
            return this.myErrorMessage != null;
        }

        public void addInferredType(PsiType psiType) {
            if (this.myErrorMessage != null) {
                return;
            }
            if (psiType == null) {
                this.myErrorMessage = "Cannot infer type arguments for " + this.myNewExpressionPresentableText;
            } else {
                this.myInferredTypes.add(psiType);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiamondInferenceResult that = (DiamondInferenceResult)o;
            if (this.myErrorMessage != null ? !this.myErrorMessage.equals(that.myErrorMessage) : that.myErrorMessage != null) {
                return false;
            }
            return this.myInferredTypes.equals(that.myInferredTypes);
        }

        public int hashCode() {
            int result = this.myInferredTypes.hashCode();
            result = 31 * result + (this.myErrorMessage != null ? this.myErrorMessage.hashCode() : 0);
            return result;
        }
    }
}

