/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexedRootsProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class IndexableSetContributor
implements IndexedRootsProvider {
    protected static final Set<VirtualFile> EMPTY_FILE_SET = Collections.emptySet();
    private static final Logger LOG = Logger.getInstance(IndexableSetContributor.class);

    @Override
    public final Set<String> getRootsToIndex() {
        return ContainerUtil.map2Set(this.getAdditionalRootsToIndex(), new NotNullFunction<VirtualFile, String>(){

            @Override
            @NotNull
            public String fun(VirtualFile virtualFile) {
                String string = virtualFile.getUrl();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor$1", "fun"));
                }
                return string;
            }
        });
    }

    @NotNull
    public static Set<VirtualFile> getProjectRootsToIndex(IndexedRootsProvider provider, Project project) {
        if (provider instanceof IndexableSetContributor) {
            IndexableSetContributor contributor = (IndexableSetContributor)provider;
            Set<VirtualFile> roots = contributor.getAdditionalProjectRootsToIndex(project);
            Set<VirtualFile> set = IndexableSetContributor.filterOutNulls(contributor, "getAdditionalProjectRootsToIndex(Project)", roots);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor", "getProjectRootsToIndex"));
            }
            return set;
        }
        Set<VirtualFile> set = EMPTY_FILE_SET;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor", "getProjectRootsToIndex"));
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getRootsToIndex(IndexedRootsProvider provider) {
        if (provider instanceof IndexableSetContributor) {
            IndexableSetContributor contributor = (IndexableSetContributor)provider;
            Set<VirtualFile> roots = contributor.getAdditionalRootsToIndex();
            Set<VirtualFile> set = IndexableSetContributor.filterOutNulls(contributor, "getAdditionalRootsToIndex()", roots);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor", "getRootsToIndex"));
            }
            return set;
        }
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        for (String url : provider.getRootsToIndex()) {
            ContainerUtil.addIfNotNull(VirtualFileManager.getInstance().findFileByUrl(url), result);
        }
        HashSet<VirtualFile> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor", "getRootsToIndex"));
        }
        return hashSet;
    }

    @NotNull
    public Set<VirtualFile> getAdditionalProjectRootsToIndex(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/IndexableSetContributor", "getAdditionalProjectRootsToIndex"));
        }
        Set<VirtualFile> set = EMPTY_FILE_SET;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor", "getAdditionalProjectRootsToIndex"));
        }
        return set;
    }

    @NotNull
    public abstract Set<VirtualFile> getAdditionalRootsToIndex();

    @NotNull
    private static Set<VirtualFile> filterOutNulls(@NotNull IndexableSetContributor contributor, @NotNull String methodInfo, @NotNull Set<VirtualFile> roots) {
        if (contributor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contributor", "com/intellij/util/indexing/IndexableSetContributor", "filterOutNulls"));
        }
        if (methodInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodInfo", "com/intellij/util/indexing/IndexableSetContributor", "filterOutNulls"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/indexing/IndexableSetContributor", "filterOutNulls"));
        }
        for (VirtualFile root : roots) {
            if (root != null) continue;
            LOG.error("Please fix " + contributor.getClass().getName() + "#" + methodInfo + ".\n" + "The returned set is not expected to contain nulls, but it is " + roots);
            HashSet<VirtualFile> result = ContainerUtil.newHashSet(roots.size());
            ContainerUtil.addAllNotNull(result, roots);
            HashSet<VirtualFile> hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor", "filterOutNulls"));
            }
            return hashSet;
        }
        Set<VirtualFile> set = roots;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexableSetContributor", "filterOutNulls"));
        }
        return set;
    }
}

