/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.lang.html.structureView.HtmlTagTreeElement;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Html5SectionTreeElement
extends PsiTreeElementBase<XmlTag> {
    private final Computable<Collection<StructureViewTreeElement>> myChildrenComputable;
    private final String myHeader;

    public Html5SectionTreeElement(XmlTag tag, Computable<Collection<StructureViewTreeElement>> childrenComputable, @Nullable String header) {
        super(tag);
        this.myChildrenComputable = childrenComputable;
        this.myHeader = header;
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        Collection<StructureViewTreeElement> collection = this.myChildrenComputable.compute();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/structureView/Html5SectionTreeElement", "getChildrenBase"));
        }
        return collection;
    }

    @Override
    @Nullable
    public String getPresentableText() {
        if (this.myHeader != null) {
            return HtmlTagTreeElement.normalizeSpacesAndShortenIfLong(this.myHeader);
        }
        XmlTag tag = (XmlTag)this.getElement();
        return tag == null ? null : HtmlTagTreeElement.normalizeSpacesAndShortenIfLong(tag.getValue().getTrimmedText());
    }

    @Override
    public String getLocationString() {
        XmlTag tag = (XmlTag)this.getElement();
        if (tag == null) {
            return null;
        }
        return HtmlTagTreeElement.getTagPresentation(tag);
    }

    @Override
    public boolean isSearchInLocationString() {
        return true;
    }
}

