/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class BackwardDependenciesBuilder
extends DependenciesBuilder {
    private final AnalysisScope myForwardScope;

    public BackwardDependenciesBuilder(Project project, AnalysisScope scope) {
        this(project, scope, null);
    }

    public BackwardDependenciesBuilder(Project project, AnalysisScope scope, @Nullable AnalysisScope scopeOfInterest) {
        super(project, scope, scopeOfInterest);
        this.myForwardScope = scopeOfInterest != null ? scopeOfInterest : ApplicationManager.getApplication().runReadAction(new Computable<AnalysisScope>(){

            @Override
            public AnalysisScope compute() {
                return BackwardDependenciesBuilder.this.getScope().getNarrowedComplementaryScope(BackwardDependenciesBuilder.this.getProject());
            }
        });
        this.myFileCount = this.myForwardScope.getFileCount();
        this.myTotalFileCount = this.myFileCount + scope.getFileCount();
    }

    @Override
    public String getRootNodeNameInUsageView() {
        return AnalysisScopeBundle.message("backward.dependencies.usage.view.root.node.text", new Object[0]);
    }

    @Override
    public String getInitialUsagesPosition() {
        return AnalysisScopeBundle.message("backward.dependencies.usage.view.initial.text", new Object[0]);
    }

    @Override
    public boolean isBackward() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze() {
        AnalysisScope scope = this.myForwardScope;
        final ForwardDependenciesBuilder builder = new ForwardDependenciesBuilder(this.getProject(), scope, this.getScopeOfInterest());
        builder.setTotalFileCount(this.myTotalFileCount);
        ((DependenciesBuilder)builder).analyze();
        BackwardDependenciesBuilder.subtractScope(builder, this.getScope());
        final PsiManager psiManager = PsiManager.getInstance(this.getProject());
        psiManager.startBatchFilesProcessingMode();
        try {
            final int fileCount = this.getScope().getFileCount();
            final boolean includeTestSource = this.getScope().isIncludeTestSource();
            final ProjectFileIndex fileIndex = ProjectRootManager.getInstance(this.getProject()).getFileIndex();
            this.getScope().accept(new Processor<VirtualFile>(){

                @Override
                public boolean process(final VirtualFile virtualFile) {
                    if (!includeTestSource && fileIndex.isInTestSourceContent(virtualFile)) {
                        return true;
                    }
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    if (indicator != null) {
                        if (indicator.isCanceled()) {
                            throw new ProcessCanceledException();
                        }
                        indicator.setText(AnalysisScopeBundle.message("package.dependencies.progress.text", new Object[0]));
                        indicator.setText2(BackwardDependenciesBuilder.this.getRelativeToProjectPath(virtualFile));
                        if (fileCount > 0) {
                            indicator.setFraction((double)(++BackwardDependenciesBuilder.this.myFileCount) / (double)BackwardDependenciesBuilder.this.myTotalFileCount);
                        }
                    }
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            PsiFile file = psiManager.findFile(virtualFile);
                            if (file != null) {
                                Map<PsiFile, Set<PsiFile>> dependencies = builder.getDependencies();
                                for (PsiFile psiFile : dependencies.keySet()) {
                                    if (!dependencies.get(psiFile).contains(file)) continue;
                                    Set<PsiFile> fileDeps = BackwardDependenciesBuilder.this.getDependencies().get(file);
                                    if (fileDeps == null) {
                                        fileDeps = new HashSet<PsiFile>();
                                        BackwardDependenciesBuilder.this.getDependencies().put(file, fileDeps);
                                    }
                                    fileDeps.add(psiFile);
                                }
                                psiManager.dropResolveCaches();
                            }
                        }
                    });
                    return true;
                }
            });
        }
        finally {
            psiManager.finishBatchFilesProcessingMode();
        }
    }

    private static void subtractScope(DependenciesBuilder builders, AnalysisScope scope) {
        Map<PsiFile, Set<PsiFile>> dependencies = builders.getDependencies();
        HashSet<PsiFile> excluded = new HashSet<PsiFile>();
        for (PsiFile psiFile : dependencies.keySet()) {
            if (!scope.contains(psiFile)) continue;
            excluded.add(psiFile);
        }
        for (PsiFile psiFile : excluded) {
            dependencies.remove(psiFile);
        }
    }
}

