/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.event;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;

public class DocumentEventImpl
extends DocumentEvent {
    private final int myOffset;
    private final CharSequence myOldString;
    private final int myOldLength;
    private final CharSequence myNewString;
    private final int myNewLength;
    private boolean isOnlyOneLineChangedCalculated;
    private boolean isOnlyOneLineChanged;
    private boolean isStartOldIndexCalculated;
    private int myStartOldIndex;
    private final long myOldTimeStamp;
    private final boolean myIsWholeDocReplaced;
    private Diff.Change myChange;
    private static final Diff.Change TOO_BIG_FILE = new Diff.Change(0, 0, 0, 0, null){};
    private int myOptimizedLineShift;
    private boolean myOptimizedLineShiftCalculated;
    private int myOptimizedOldLineShift;
    private boolean myOptimizedOldLineShiftCalculated;
    private final int myInitialStartOffset;
    private final int myInitialOldLength;

    /*
     * WARNING - void declaration
     */
    public DocumentEventImpl(@NotNull Document document, int offset, CharSequence oldString, CharSequence newString, long oldTimeStamp, boolean bl) {
        void wholeTextReplaced;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/event/DocumentEventImpl", "<init>"));
        }
        this(document, offset, oldString, newString, oldTimeStamp, (boolean)wholeTextReplaced, offset, oldString == null ? 0 : oldString.length());
    }

    /*
     * WARNING - void declaration
     */
    public DocumentEventImpl(@NotNull Document document, int offset, CharSequence oldString, CharSequence newString, long oldTimeStamp, boolean wholeTextReplaced, int initialStartOffset, int n) {
        void initialOldLength;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/event/DocumentEventImpl", "<init>"));
        }
        super(document);
        this.isOnlyOneLineChangedCalculated = false;
        this.isStartOldIndexCalculated = false;
        this.myOptimizedLineShift = -1;
        this.myOptimizedOldLineShift = -1;
        this.myOffset = offset;
        this.myOldString = oldString == null ? "" : oldString;
        this.myOldLength = this.myOldString.length();
        this.myNewString = newString == null ? "" : newString;
        this.myNewLength = this.myNewString.length();
        this.myInitialStartOffset = initialStartOffset;
        this.myInitialOldLength = initialOldLength;
        this.myOldTimeStamp = oldTimeStamp;
        if (this.getDocument().getTextLength() == 0) {
            this.isOnlyOneLineChangedCalculated = true;
            this.isOnlyOneLineChanged = false;
            this.myIsWholeDocReplaced = false;
        } else {
            this.myIsWholeDocReplaced = wholeTextReplaced;
        }
    }

    @Override
    public int getOffset() {
        return this.myOffset;
    }

    @Override
    public int getOldLength() {
        return this.myOldLength;
    }

    @Override
    public int getNewLength() {
        return this.myNewLength;
    }

    @Override
    @NotNull
    public CharSequence getOldFragment() {
        CharSequence charSequence = this.myOldString;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/event/DocumentEventImpl", "getOldFragment"));
        }
        return charSequence;
    }

    @Override
    @NotNull
    public CharSequence getNewFragment() {
        CharSequence charSequence = this.myNewString;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/event/DocumentEventImpl", "getNewFragment"));
        }
        return charSequence;
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = (Document)this.getSource();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/event/DocumentEventImpl", "getDocument"));
        }
        return document;
    }

    public int getInitialStartOffset() {
        return this.myInitialStartOffset;
    }

    public int getInitialOldLength() {
        return this.myInitialOldLength;
    }

    public int getStartOldIndex() {
        if (this.isStartOldIndexCalculated) {
            return this.myStartOldIndex;
        }
        this.isStartOldIndexCalculated = true;
        this.myStartOldIndex = this.getDocument().getLineNumber(this.myOffset);
        return this.myStartOldIndex;
    }

    public boolean isOnlyOneLineChanged() {
        int i;
        if (this.isOnlyOneLineChangedCalculated) {
            return this.isOnlyOneLineChanged;
        }
        this.isOnlyOneLineChangedCalculated = true;
        this.isOnlyOneLineChanged = true;
        for (i = 0; i < this.myOldString.length(); ++i) {
            if (this.myOldString.charAt(i) != '\n') continue;
            this.isOnlyOneLineChanged = false;
            break;
        }
        if (this.isOnlyOneLineChanged) {
            for (i = 0; i < this.myNewString.length(); ++i) {
                if (this.myNewString.charAt(i) != '\n') continue;
                this.isOnlyOneLineChanged = false;
                break;
            }
        }
        return this.isOnlyOneLineChanged;
    }

    @Override
    public long getOldTimeStamp() {
        return this.myOldTimeStamp;
    }

    @Override
    public String toString() {
        return "DocumentEventImpl[myOffset=" + this.myOffset + ", myOldLength=" + this.myOldLength + ", myNewLength=" + this.myNewLength + ", myOldString='" + this.myOldString + "', myNewString='" + this.myNewString + "']" + (this.isWholeTextReplaced() ? " Whole." : ".");
    }

    @Override
    public boolean isWholeTextReplaced() {
        return this.myIsWholeDocReplaced;
    }

    public int translateLineViaDiff(int line) throws FilesTooBigForDiffException {
        Diff.Change change = this.reBuildDiffIfNeeded();
        if (change == null) {
            return line;
        }
        int newLine = line;
        while (change != null && line >= change.line0) {
            if (line >= change.line0 + change.deleted) {
                newLine += change.inserted - change.deleted;
            } else {
                int delta = Math.min(change.inserted, line - change.line0);
                newLine = change.line1 + delta;
                break;
            }
            change = change.link;
        }
        return newLine;
    }

    public int translateLineViaDiffStrict(int line) throws FilesTooBigForDiffException {
        Diff.Change change = this.reBuildDiffIfNeeded();
        if (change == null) {
            return line;
        }
        return Diff.translateLine(change, line);
    }

    private Diff.Change reBuildDiffIfNeeded() throws FilesTooBigForDiffException {
        if (this.myChange == TOO_BIG_FILE) {
            throw new FilesTooBigForDiffException(0);
        }
        if (this.myChange == null) {
            try {
                this.myChange = Diff.buildChanges(this.myOldString, this.myNewString);
            }
            catch (FilesTooBigForDiffException e) {
                this.myChange = TOO_BIG_FILE;
                throw e;
            }
        }
        return this.myChange;
    }

    public int getOptimizedLineShift() {
        if (!this.myOptimizedLineShiftCalculated) {
            this.myOptimizedLineShiftCalculated = true;
            if (this.myOldLength == 0) {
                int lineShift = StringUtil.countNewLines(this.myNewString);
                this.myOptimizedLineShift = lineShift == 0 ? -1 : lineShift;
            }
        }
        return this.myOptimizedLineShift;
    }

    public int getOptimizedOldLineShift() {
        if (!this.myOptimizedOldLineShiftCalculated) {
            this.myOptimizedOldLineShiftCalculated = true;
            if (this.myNewLength == 0) {
                int lineShift = StringUtil.countNewLines(this.myOldString);
                this.myOptimizedOldLineShift = lineShift == 0 ? -1 : lineShift;
            }
        }
        return this.myOptimizedOldLineShift;
    }
}

