/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.vcs.FileStatus;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FileStatusFactory {
    private static final FileStatusFactory ourInstance = new FileStatusFactory();
    private final List<FileStatus> myStatuses = new ArrayList<FileStatus>();

    private FileStatusFactory() {
    }

    public synchronized FileStatus createFileStatus(@NonNls @NotNull String id, @NotNull String description, Color color) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/vcs/FileStatusFactory", "createFileStatus"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/openapi/vcs/FileStatusFactory", "createFileStatus"));
        }
        FileStatusImpl result = new FileStatusImpl(id, ColorKey.createColorKey("FILESTATUS_" + id, color), description);
        this.myStatuses.add(result);
        return result;
    }

    public synchronized FileStatus createOnlyColorForFileStatus(@NonNls @NotNull String id, Color color) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/vcs/FileStatusFactory", "createOnlyColorForFileStatus"));
        }
        FileStatusImpl.OnlyColorFileStatus result = new FileStatusImpl.OnlyColorFileStatus(id, ColorKey.createColorKey("FILESTATUS_" + id, color), null);
        this.myStatuses.add(result);
        return result;
    }

    public synchronized FileStatus[] getAllFileStatuses() {
        return this.myStatuses.toArray(new FileStatus[this.myStatuses.size()]);
    }

    public static FileStatusFactory getInstance() {
        return ourInstance;
    }

    private static class FileStatusImpl
    implements FileStatus {
        private final String myStatus;
        private final ColorKey myColorKey;
        private final String myText;

        public FileStatusImpl(@NotNull String status, @NotNull ColorKey key, String text) {
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/openapi/vcs/FileStatusFactory$FileStatusImpl", "<init>"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/vcs/FileStatusFactory$FileStatusImpl", "<init>"));
            }
            this.myStatus = status;
            this.myColorKey = key;
            this.myText = text;
        }

        public String toString() {
            return this.myStatus;
        }

        @Override
        public String getText() {
            return this.myText;
        }

        @Override
        public Color getColor() {
            return EditorColorsManager.getInstance().getGlobalScheme().getColor(this.getColorKey());
        }

        @Override
        @NotNull
        public ColorKey getColorKey() {
            ColorKey colorKey = this.myColorKey;
            if (colorKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/FileStatusFactory$FileStatusImpl", "getColorKey"));
            }
            return colorKey;
        }

        @Override
        @NotNull
        public String getId() {
            String string = this.myStatus;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/FileStatusFactory$FileStatusImpl", "getId"));
            }
            return string;
        }

        private static class OnlyColorFileStatus
        extends FileStatusImpl {
            public OnlyColorFileStatus(@NotNull String status, @NotNull ColorKey key, String text) {
                if (status == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/openapi/vcs/FileStatusFactory$FileStatusImpl$OnlyColorFileStatus", "<init>"));
                }
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/vcs/FileStatusFactory$FileStatusImpl$OnlyColorFileStatus", "<init>"));
                }
                super(status, key, text);
            }

            @Override
            @NotNull
            public String getId() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getText() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

