/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

public abstract class CapacityAllocationPolicy {
    public static final CapacityAllocationPolicy FIXED = new CapacityAllocationPolicy(){

        @Override
        public int calculateCapacity(int requiredLength) {
            return requiredLength;
        }
    };
    public static final CapacityAllocationPolicy FIVE_PERCENT_FOR_GROWTH = new CapacityAllocationPolicy(){

        @Override
        public int calculateCapacity(int requiredLength) {
            return Math.min((int)((double)requiredLength * 1.05), (requiredLength / 1024 + 1) * 1024);
        }
    };
    public static final CapacityAllocationPolicy DEFAULT = new CapacityAllocationPolicy(){

        @Override
        public int calculateCapacity(int requiredLength) {
            return Math.max(64, Math.min(Integer.highestOneBit(requiredLength * 3 / 2) << 1, (requiredLength / 1024 + 1) * 1024));
        }
    };
    public static final CapacityAllocationPolicy REASONABLY_SMALL = new CapacityAllocationPolicy(){

        @Override
        public int calculateCapacity(int requiredLength) {
            return Math.max(8, Math.min((int)((double)requiredLength * 1.2), (requiredLength / 1024 + 1) * 1024));
        }
    };

    public abstract int calculateCapacity(int var1);
}

