/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PsiIntersectionType
extends PsiType.Stub {
    private final PsiType[] myConjuncts;

    private PsiIntersectionType(@NotNull PsiType[] conjuncts) {
        if (conjuncts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conjuncts", "com/intellij/psi/PsiIntersectionType", "<init>"));
        }
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myConjuncts = conjuncts;
    }

    @NotNull
    public static PsiType createIntersection(@NotNull List<PsiType> conjuncts) {
        if (conjuncts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conjuncts", "com/intellij/psi/PsiIntersectionType", "createIntersection"));
        }
        PsiType psiType = PsiIntersectionType.createIntersection(conjuncts.toArray(PsiIntersectionType.createArray(conjuncts.size())));
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiIntersectionType", "createIntersection"));
        }
        return psiType;
    }

    @NotNull
    public static PsiType createIntersection(PsiType ... conjuncts) {
        PsiType psiType = PsiIntersectionType.createIntersection(true, conjuncts);
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiIntersectionType", "createIntersection"));
        }
        return psiType;
    }

    @NotNull
    public static PsiType createIntersection(boolean flatten, PsiType ... conjuncts) {
        assert (conjuncts.length > 0);
        if (flatten) {
            conjuncts = PsiIntersectionType.flattenAndRemoveDuplicates(conjuncts);
        }
        if (conjuncts.length == 1) {
            PsiType psiType = conjuncts[0];
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiIntersectionType", "createIntersection"));
            }
            return psiType;
        }
        PsiIntersectionType psiIntersectionType = new PsiIntersectionType(conjuncts);
        if (psiIntersectionType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiIntersectionType", "createIntersection"));
        }
        return psiIntersectionType;
    }

    private static PsiType[] flattenAndRemoveDuplicates(PsiType[] conjuncts) {
        try {
            Set<PsiType> flattened = PsiIntersectionType.flatten(conjuncts, ContainerUtil.<PsiType>newLinkedHashSet());
            return flattened.toArray(PsiIntersectionType.createArray(flattened.size()));
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException(Arrays.toString(conjuncts), e);
        }
    }

    public static Set<PsiType> flatten(PsiType[] conjuncts, Set<PsiType> types) {
        for (PsiType conjunct : conjuncts) {
            if (conjunct instanceof PsiIntersectionType) {
                PsiIntersectionType type = (PsiIntersectionType)conjunct;
                PsiIntersectionType.flatten(type.getConjuncts(), types);
                continue;
            }
            types.add(conjunct);
        }
        if (types.size() > 1) {
            PsiType[] array = types.toArray(PsiIntersectionType.createArray(types.size()));
            Iterator<PsiType> iterator = types.iterator();
            block1: while (iterator.hasNext()) {
                PsiType type = iterator.next();
                for (PsiType existing : array) {
                    boolean allowUncheckedConversion;
                    if (type == existing) continue;
                    boolean bl = allowUncheckedConversion = type instanceof PsiClassType && ((PsiClassType)type).isRaw();
                    if (!TypeConversionUtil.isAssignable(type, existing, allowUncheckedConversion)) continue;
                    iterator.remove();
                    continue block1;
                }
            }
            if (types.isEmpty()) {
                types.add(array[0]);
            }
        }
        return types;
    }

    @NotNull
    public PsiType[] getConjuncts() {
        if (this.myConjuncts == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiIntersectionType", "getConjuncts"));
        }
        return this.myConjuncts;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = StringUtil.join(this.myConjuncts, new Function<PsiType, String>(){

            @Override
            public String fun(PsiType psiType) {
                return psiType.getPresentableText();
            }
        }, " & ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiIntersectionType", "getPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.myConjuncts[0].getCanonicalText(annotated);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiIntersectionType", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = StringUtil.join(this.myConjuncts, new Function<PsiType, String>(){

            @Override
            public String fun(PsiType psiType) {
                return psiType.getInternalCanonicalText();
            }
        }, " & ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiIntersectionType", "getInternalCanonicalText"));
        }
        return string;
    }

    @Override
    public boolean isValid() {
        for (PsiType conjunct : this.myConjuncts) {
            if (conjunct.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/PsiIntersectionType", "equalsToText"));
        }
        return false;
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/PsiIntersectionType", "accept"));
        }
        return visitor.visitIntersectionType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myConjuncts[0].getResolveScope();
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        if (this.myConjuncts == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiIntersectionType", "getSuperTypes"));
        }
        return this.myConjuncts;
    }

    @NotNull
    public PsiType getRepresentative() {
        PsiType psiType = this.myConjuncts[0];
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiIntersectionType", "getRepresentative"));
        }
        return psiType;
    }

    public boolean equals(Object obj) {
        PsiType[] second;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PsiIntersectionType)) {
            return false;
        }
        PsiType[] first = this.getConjuncts();
        if (first.length != (second = ((PsiIntersectionType)obj).getConjuncts()).length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            if (first[i].equals(second[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.myConjuncts[0].hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("PsiIntersectionType: ");
        for (int i = 0; i < this.myConjuncts.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.myConjuncts[i].getPresentableText());
        }
        return sb.toString();
    }

    public String getConflictingConjunctsMessage() {
        PsiType[] conjuncts = this.getConjuncts();
        for (int i = 0; i < conjuncts.length; ++i) {
            PsiClass conjunct = PsiUtil.resolveClassInClassTypeOnly(conjuncts[i]);
            if (conjunct == null || conjunct.isInterface()) continue;
            for (int i1 = i + 1; i1 < conjuncts.length; ++i1) {
                PsiClass oppositeConjunct = PsiUtil.resolveClassInClassTypeOnly(conjuncts[i1]);
                if (oppositeConjunct == null || oppositeConjunct.isInterface() || conjunct.isInheritor(oppositeConjunct, true) || oppositeConjunct.isInheritor(conjunct, true)) continue;
                return conjuncts[i].getPresentableText() + " and " + conjuncts[i1].getPresentableText();
            }
        }
        return null;
    }
}

