/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.MarkerCache;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelfElementInfo
extends SmartPointerElementInfo {
    private static final FileDocumentManager ourFileDocManager = FileDocumentManager.getInstance();
    protected volatile Class myType;
    private final SmartPointerManagerImpl myManager;
    protected final Language myLanguage;
    private final MarkerCache myMarkerCache;
    private final boolean myForInjected;
    private boolean myHasRange;
    private int myStartOffset;
    private int myEndOffset;

    SelfElementInfo(@NotNull Project project, @NotNull ProperTextRange range, @NotNull Class anchorClass, @NotNull PsiFile containingFile, @NotNull Language language, boolean forInjected) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (anchorClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchorClass", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        this.myLanguage = language;
        this.myForInjected = forInjected;
        this.myType = anchorClass;
        assert (!PsiFile.class.isAssignableFrom(anchorClass)) : "FileElementInfo must be used for files";
        this.myManager = (SmartPointerManagerImpl)SmartPointerManager.getInstance(project);
        this.myMarkerCache = this.myManager.getMarkerCache(containingFile.getViewProvider().getVirtualFile());
        this.setRange(range);
    }

    void setRange(@Nullable Segment range) {
        if (range != null) {
            this.myHasRange = true;
            this.myStartOffset = range.getStartOffset();
            this.myEndOffset = range.getEndOffset();
            this.myMarkerCache.rangeChanged(this.markerCacheKey());
        } else {
            this.myHasRange = false;
        }
    }

    long markerCacheKey() {
        long result;
        if (!this.myHasRange) {
            return 0L;
        }
        long start = this.myStartOffset;
        assert (start >= 0L);
        assert (start < Integer.MAX_VALUE);
        long packed = start + 1L | (long)this.myEndOffset << 32;
        assert (packed > 0L);
        assert (packed != Long.MIN_VALUE);
        long l = result = this.myForInjected ? -packed : packed;
        assert (result != 0L);
        return result;
    }

    boolean isForInjected() {
        return this.myForInjected;
    }

    @Override
    public Document getDocumentToSynchronize() {
        return ourFileDocManager.getCachedDocument(this.getVirtualFile());
    }

    @Override
    public PsiElement restoreElement() {
        ProperTextRange segment = this.getPsiRange();
        if (segment == null) {
            return null;
        }
        PsiFile file = this.restoreFile();
        if (file == null || !file.isValid()) {
            return null;
        }
        return SelfElementInfo.findElementInside(file, segment.getStartOffset(), segment.getEndOffset(), this.myType, this.myLanguage);
    }

    @Override
    @Nullable
    public ProperTextRange getPsiRange() {
        return this.calcPsiRange();
    }

    @Nullable
    private ProperTextRange calcPsiRange() {
        return this.myHasRange ? ProperTextRange.create(this.myStartOffset, this.myEndOffset) : null;
    }

    @Override
    public PsiFile restoreFile() {
        return SelfElementInfo.restoreFileFromVirtual(this.getVirtualFile(), this.getProject(), this.myLanguage);
    }

    public static PsiElement findElementInside(@NotNull PsiFile file, int syncStartOffset, int syncEndOffset, @NotNull Class type, @NotNull Language language) {
        PsiElement lastChild;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        PsiElement anchor = file.getViewProvider().findElementAt(syncStartOffset, language);
        if (anchor == null && syncStartOffset == file.getTextLength() && (lastChild = file.getViewProvider().getPsi(language).getLastChild()) != null) {
            anchor = PsiTreeUtil.getDeepestLast(lastChild);
        }
        if (anchor == null) {
            return null;
        }
        PsiElement result = SelfElementInfo.findParent(syncStartOffset, syncEndOffset, type, anchor);
        if (syncEndOffset == syncStartOffset) {
            while (result == null && anchor.getTextRange().getStartOffset() == syncEndOffset && (anchor = PsiTreeUtil.prevLeaf(anchor, false)) != null) {
                result = SelfElementInfo.findParent(syncStartOffset, syncEndOffset, type, anchor);
            }
        }
        return result;
    }

    @Nullable
    private static PsiElement findParent(int syncStartOffset, int syncEndOffset, @NotNull Class type, PsiElement anchor) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findParent"));
        }
        TextRange range = anchor.getTextRange();
        if (range.getStartOffset() != syncStartOffset) {
            return null;
        }
        while (range.getEndOffset() < syncEndOffset && (anchor = anchor.getParent()) != null && anchor.getTextRange() != null) {
            range = anchor.getTextRange();
        }
        while (range.getEndOffset() == syncEndOffset && anchor != null && !type.equals(anchor.getClass()) && (anchor = anchor.getParent()) != null && anchor.getTextRange() != null) {
            range = anchor.getTextRange();
        }
        return range.getEndOffset() == syncEndOffset ? anchor : null;
    }

    @Override
    public void cleanup() {
        this.myHasRange = false;
    }

    @Nullable
    public static PsiFile restoreFileFromVirtual(final @NotNull VirtualFile virtualFile, final @NotNull Project project, final @Nullable Language language) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreFileFromVirtual"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreFileFromVirtual"));
        }
        return ApplicationManager.getApplication().runReadAction(new NullableComputable<PsiFile>(){

            @Override
            public PsiFile compute() {
                if (project.isDisposed()) {
                    return null;
                }
                VirtualFile child = SelfElementInfo.restoreVFile(virtualFile);
                if (child == null || !child.isValid()) {
                    return null;
                }
                PsiFile file = PsiManager.getInstance(project).findFile(child);
                if (file != null && language != null) {
                    return file.getViewProvider().getPsi(language);
                }
                return file;
            }
        });
    }

    @Nullable
    public static PsiDirectory restoreDirectoryFromVirtual(final VirtualFile virtualFile, final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreDirectoryFromVirtual"));
        }
        if (virtualFile == null) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<PsiDirectory>(){

            @Override
            public PsiDirectory compute() {
                VirtualFile child = SelfElementInfo.restoreVFile(virtualFile);
                if (child == null || !child.isValid()) {
                    return null;
                }
                PsiDirectory file = PsiManager.getInstance(project).findDirectory(child);
                if (file == null || !file.isValid()) {
                    return null;
                }
                return file;
            }
        });
    }

    @Nullable
    private static VirtualFile restoreVFile(VirtualFile virtualFile) {
        VirtualFile child;
        if (virtualFile.isValid()) {
            child = virtualFile;
        } else {
            VirtualFile vParent = virtualFile.getParent();
            if (vParent == null || !vParent.isValid()) {
                return null;
            }
            String name = virtualFile.getName();
            child = vParent.findChild(name);
        }
        return child;
    }

    @Override
    public int elementHashCode() {
        return this.getVirtualFile().hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(final @NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof SelfElementInfo) {
            SelfElementInfo otherInfo = (SelfElementInfo)other;
            ProperTextRange range1 = this.getPsiRange();
            ProperTextRange range2 = otherInfo.getPsiRange();
            return Comparing.equal(this.getVirtualFile(), otherInfo.getVirtualFile()) && this.myType == otherInfo.myType && range1 != null && range2 != null && range1.getStartOffset() == range2.getStartOffset() && range1.getEndOffset() == range2.getEndOffset();
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                return Comparing.equal(SelfElementInfo.this.restoreElement(), other.restoreElement());
            }
        });
    }

    @Override
    @NotNull
    public final VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myMarkerCache.getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "getVirtualFile"));
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public Segment getRange() {
        PsiDocumentManagerBase documentManager;
        List<DocumentEvent> events;
        Document document;
        if (this.myHasRange && (document = this.getDocumentToSynchronize()) != null && !(events = (documentManager = this.myManager.getPsiDocumentManager()).getEventsSinceCommit(document)).isEmpty()) {
            return this.myMarkerCache.getUpdatedRange(this.markerCacheKey(), (FrozenDocument)documentManager.getLastCommittedDocument(document), events);
        }
        return this.calcPsiRange();
    }

    @Override
    @NotNull
    public final Project getProject() {
        Project project = this.myManager.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "getProject"));
        }
        return project;
    }

    public String toString() {
        return "psi:range=" + this.calcPsiRange() + ",type=" + this.myType;
    }
}

