/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MathRandomCastToIntInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("math.random.cast.to.int.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MathRandomCastToIntInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("math.random.cast.to.int.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MathRandomCastToIntInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiTypeCastExpression expression = (PsiTypeCastExpression)infos[0];
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        if (JavaTokenType.ASTERISK != tokenType) {
            return null;
        }
        return new MathRandomCastToIntegerFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MathRandomCastToIntegerVisitor();
    }

    private static class MathRandomCastToIntegerVisitor
    extends BaseInspectionVisitor {
        private MathRandomCastToIntegerVisitor() {
        }

        @Override
        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            super.visitTypeCastExpression(expression);
            PsiExpression operand = expression.getOperand();
            if (!(operand instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiTypeElement castType = expression.getCastType();
            if (castType == null) {
                return;
            }
            PsiType type = castType.getType();
            if (!PsiType.INT.equals(type) && !PsiType.LONG.equals(type)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)operand;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"random".equals(referenceName)) {
                return;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (!"java.lang.Math".equals(qualifiedName) && !"java.lang.StrictMath".equals(qualifiedName)) {
                return;
            }
            this.registerError((PsiElement)methodCallExpression, expression);
        }
    }

    private static class MathRandomCastToIntegerFix
    extends InspectionGadgetsFix {
        private MathRandomCastToIntegerFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MathRandomCastToIntInspection$MathRandomCastToIntegerFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("math.random.cast.to.int.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MathRandomCastToIntInspection$MathRandomCastToIntegerFix", "getName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiExpression[] operands;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
            PsiElement grandParent = typeCastExpression.getParent();
            if (!(grandParent instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)grandParent;
            PsiExpression operand = typeCastExpression.getOperand();
            if (operand == null) {
                return;
            }
            StringBuilder newExpression = new StringBuilder();
            newExpression.append("(int)(");
            for (PsiExpression expression : operands = polyadicExpression.getOperands()) {
                PsiJavaToken token = polyadicExpression.getTokenBeforeOperand(expression);
                if (token != null) {
                    newExpression.append(token.getText());
                }
                if (typeCastExpression.equals(expression)) {
                    newExpression.append(operand.getText());
                    continue;
                }
                newExpression.append(expression.getText());
            }
            newExpression.append(')');
            PsiReplacementUtil.replaceExpression(polyadicExpression, newExpression.toString());
        }
    }
}

