/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SynchronizationOnLocalVariableOrMethodParameterInspection
extends BaseInspection {
    public boolean reportLocalVariables = true;
    public boolean reportMethodParameters = true;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("synchronization.on.local.variable.or.method.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Boolean localVariable = (Boolean)infos[0];
        if (localVariable.booleanValue()) {
            String string = InspectionGadgetsBundle.message("synchronization.on.local.variable.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("synchronization.on.method.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizationOnLocalVariableVisitor();
    }

    private class SynchronizationOnLocalVariableVisitor
    extends BaseInspectionVisitor {
        private SynchronizationOnLocalVariableVisitor() {
        }

        @Override
        public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
            super.visitSynchronizedStatement(statement);
            if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportLocalVariables && !SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportMethodParameters) {
                return;
            }
            PsiExpression lockExpression = statement.getLockExpression();
            if (!(lockExpression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lockExpression;
            if (referenceExpression.isQualified()) {
                return;
            }
            boolean localVariable = false;
            PsiElement target = referenceExpression.resolve();
            if (target instanceof PsiLocalVariable) {
                if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportLocalVariables) {
                    return;
                }
                localVariable = true;
            } else if (target instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)target;
                PsiElement scope = parameter.getDeclarationScope();
                if (scope instanceof PsiMethod) {
                    if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportMethodParameters) {
                        return;
                    }
                } else {
                    if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportLocalVariables) {
                        return;
                    }
                    localVariable = true;
                }
            } else {
                return;
            }
            PsiElement statementScope = this.getScope(statement);
            PsiElement targetScope = this.getScope(target);
            if (statementScope != targetScope) {
                return;
            }
            this.registerError((PsiElement)referenceExpression, localVariable);
        }

        private PsiElement getScope(PsiElement element) {
            return PsiTreeUtil.getParentOfType(element, PsiMethod.class, PsiLambdaExpression.class, PsiClassInitializer.class);
        }
    }
}

