/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DfaTypeValue
extends DfaValue {
    private final DfaPsiType myType;
    private final Nullness myNullness;

    private DfaTypeValue(DfaPsiType type, Nullness nullness, DfaValueFactory factory) {
        super(factory);
        this.myType = type;
        this.myNullness = nullness;
    }

    public DfaPsiType getDfaType() {
        return this.myType;
    }

    public boolean isNullable() {
        return this.myNullness == Nullness.NULLABLE;
    }

    public boolean isNotNull() {
        return this.myNullness == Nullness.NOT_NULL;
    }

    public Nullness getNullness() {
        return this.myNullness;
    }

    @NonNls
    public String toString() {
        return this.myType + ", nullable=" + (Object)((Object)this.myNullness);
    }

    public static class Factory {
        private final Map<DfaPsiType, ArrayList<DfaTypeValue>> myCache = ContainerUtil.newHashMap();
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        @NotNull
        public DfaTypeValue createTypeValue(@NotNull DfaPsiType type, @NotNull Nullness nullness) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/value/DfaTypeValue$Factory", "createTypeValue"));
            }
            if (nullness == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullness", "com/intellij/codeInspection/dataFlow/value/DfaTypeValue$Factory", "createTypeValue"));
            }
            ArrayList<DfaTypeValue> conditions = this.myCache.get(type);
            if (conditions == null) {
                conditions = new ArrayList();
                this.myCache.put(type, conditions);
            } else {
                for (DfaTypeValue aType : conditions) {
                    if (aType.myNullness != nullness) continue;
                    DfaTypeValue dfaTypeValue = aType;
                    if (dfaTypeValue == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaTypeValue$Factory", "createTypeValue"));
                    }
                    return dfaTypeValue;
                }
            }
            DfaTypeValue result = new DfaTypeValue(type, nullness, this.myFactory);
            conditions.add(result);
            DfaTypeValue dfaTypeValue = result;
            if (dfaTypeValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaTypeValue$Factory", "createTypeValue"));
            }
            return dfaTypeValue;
        }
    }
}

