/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import java.util.concurrent.atomic.AtomicLong;

public class StripedIDGenerator {
    private static final int CHUNK_SIZE = 1000;
    private final AtomicLong nextChunkStart = new AtomicLong();
    private final ThreadLocal<NextPair> localCounter = new ThreadLocal();

    public long next() {
        NextPair nextPair = this.localCounter.get();
        if (nextPair == null || nextPair.nextId == nextPair.limit) {
            long start = this.nextChunkStart.getAndAdd(1000L);
            nextPair = new NextPair(start, start + 1000L);
            this.localCounter.set(nextPair);
        }
        long result = nextPair.nextId++;
        return result;
    }

    private static class NextPair {
        long nextId;
        final long limit;

        private NextPair(long nextId, long limit) {
            this.nextId = nextId;
            this.limit = limit;
        }
    }
}

