/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariablesOrder;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.CheckedExceptionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.TypesDistinctProver;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSession {
    private static final Logger LOG = Logger.getInstance("#" + InferenceSession.class.getName());
    public static final Key<PsiType> LOWER_BOUND = Key.create("LowBound");
    private static final Key<PsiElement> ORIGINAL_CONTEXT = Key.create("ORIGINAL_CONTEXT");
    private static final Key<Boolean> ERASED = Key.create("UNCHECKED_CONVERSION");
    private static final Function<Pair<PsiType, PsiType>, PsiType> UPPER_BOUND_FUNCTION = new Function<Pair<PsiType, PsiType>, PsiType>(){

        @Override
        public PsiType fun(Pair<PsiType, PsiType> pair) {
            if (pair.first instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)pair.first, (PsiType)pair.second)) {
                return null;
            }
            if (pair.second instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)pair.second, (PsiType)pair.first)) {
                return null;
            }
            return GenericsUtil.getGreatestLowerBound((PsiType)pair.first, (PsiType)pair.second);
        }
    };
    private static final String EQUALITY_CONSTRAINTS_PRESENTATION = "equality constraints";
    private static final String UPPER_BOUNDS_PRESENTATION = "upper bounds";
    private static final String LOWER_BOUNDS_PRESENTATION = "lower bounds";
    private final Set<InferenceVariable> myInferenceVariables = new LinkedHashSet<InferenceVariable>();
    private final List<ConstraintFormula> myConstraints = new ArrayList<ConstraintFormula>();
    private final Set<ConstraintFormula> myConstraintsCopy = new HashSet<ConstraintFormula>();
    private PsiSubstitutor mySiteSubstitutor;
    private final PsiManager myManager;
    private int myConstraintIdx = 0;
    private List<String> myErrorMessages;
    private boolean myErased = false;
    private final InferenceIncorporationPhase myIncorporationPhase = new InferenceIncorporationPhase(this);
    private final PsiElement myContext;
    private PsiSubstitutor myInferenceSubstitution = PsiSubstitutor.EMPTY;
    private final Map<PsiElement, InferenceSession> myNestedSessions = new HashMap<PsiElement, InferenceSession>();

    public void registerNestedSession(InferenceSession session) {
        this.propagateVariables(session.getInferenceVariables());
        this.myNestedSessions.put(session.getContext(), session);
        this.myNestedSessions.putAll(session.myNestedSessions);
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiType[] leftTypes, PsiType[] rightTypes, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.initBounds(typeParams);
        LOG.assertTrue(leftTypes.length == rightTypes.length);
        for (int i = 0; i < leftTypes.length; ++i) {
            PsiType rightType = this.mySiteSubstitutor.substitute(rightTypes[i]);
            if (rightType == null || leftTypes[i] == null) continue;
            this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(leftTypes[i]), this.substituteWithInferenceVariables(rightType)));
        }
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.initBounds(typeParams);
    }

    public void initExpressionConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiElement parent, PsiMethod method) {
        MethodCandidateInfo.CurrentCandidateProperties currentProperties = InferenceSession.getCurrentProperties(parent);
        this.initExpressionConstraints(parameters, args, parent, method, currentProperties != null && currentProperties.isVarargs());
    }

    public void initExpressionConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiElement parent, PsiMethod method, boolean varargs) {
        MethodCandidateInfo.CurrentCandidateProperties currentProperties = InferenceSession.getCurrentProperties(parent);
        if (method == null && currentProperties != null) {
            method = currentProperties.getMethod();
        }
        if (method != null) {
            this.initThrowsConstraints(method);
        }
        if (parameters.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null || !InferenceSession.isPertinentToApplicability(args[i], method)) continue;
                PsiType parameterType = InferenceSession.getParameterType(parameters, i, this.mySiteSubstitutor, varargs);
                this.addConstraint(new ExpressionCompatibilityConstraint(args[i], this.substituteWithInferenceVariables(parameterType)));
            }
        }
    }

    public void initThrowsConstraints(PsiMethod method) {
        for (PsiClassType thrownType : method.getThrowsList().getReferencedTypes()) {
            InferenceVariable variable = this.getInferenceVariable(this.substituteWithInferenceVariables(thrownType));
            if (variable == null) continue;
            variable.setThrownBound();
        }
    }

    private static MethodCandidateInfo.CurrentCandidateProperties getCurrentProperties(PsiElement parent) {
        if (parent instanceof PsiCall) {
            return MethodCandidateInfo.getCurrentMethod(((PsiCall)parent).getArgumentList());
        }
        return null;
    }

    public static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method) {
        return InferenceSession.isPertinentToApplicability(expr, method, null);
    }

    private static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method, PsiType expectedReturnType) {
        if ((expr instanceof PsiLambdaExpression && ((PsiLambdaExpression)expr).hasFormalParameterTypes() || expr instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)expr).isExact()) && method != null) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp(expr.getParent());
            PsiType paramType = null;
            if (parent instanceof PsiExpressionList) {
                PsiElement gParent = parent.getParent();
                PsiTypeParameterListOwner owner = InferenceSession.getTypeParameterOwner(method, gParent);
                if (owner != null) {
                    PsiParameter[] parameters;
                    int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)parent, expr);
                    if (idx > (parameters = method.getParameterList().getParameters()).length - 1) {
                        PsiType lastParamType = parameters[parameters.length - 1].getType();
                        paramType = parameters[parameters.length - 1].isVarArgs() ? ((PsiEllipsisType)lastParamType).getComponentType() : lastParamType;
                    } else {
                        paramType = parameters[idx].getType();
                    }
                    if (InferenceSession.isTypeParameterType(owner, paramType)) {
                        return false;
                    }
                }
            } else if (expectedReturnType != null && parent instanceof PsiLambdaExpression) {
                if (InferenceSession.isTypeParameterType(method, expectedReturnType)) {
                    return false;
                }
                paramType = expectedReturnType;
            }
            if (expr instanceof PsiLambdaExpression) {
                for (PsiExpression expression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)expr)) {
                    if (InferenceSession.isPertinentToApplicability(expression, method, LambdaUtil.getFunctionalInterfaceReturnType(paramType))) continue;
                    return false;
                }
                return true;
            }
        }
        if (expr instanceof PsiLambdaExpression) {
            return ((PsiLambdaExpression)expr).hasFormalParameterTypes();
        }
        if (expr instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)expr).isExact();
        }
        if (expr instanceof PsiParenthesizedExpression) {
            return InferenceSession.isPertinentToApplicability(((PsiParenthesizedExpression)expr).getExpression(), method);
        }
        if (expr instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            if (!InferenceSession.isPertinentToApplicability(thenExpression, method)) {
                return false;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            if (!InferenceSession.isPertinentToApplicability(elseExpression, method)) {
                return false;
            }
        }
        return true;
    }

    private static PsiTypeParameterListOwner getTypeParameterOwner(@NotNull PsiMethod method, PsiElement gParent) {
        PsiTypeElement[] typeElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        PsiClass containingClass;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "getTypeParameterOwner"));
        }
        PsiTypeParameterListOwner owner = null;
        if (method.getTypeParameters().length > 0 && gParent instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArgumentList().getTypeParameterElements().length == 0) {
            owner = method;
        } else if (method.isConstructor() && gParent instanceof PsiNewExpression && (containingClass = method.getContainingClass()) != null && containingClass.hasTypeParameters() && (classReference = ((PsiNewExpression)gParent).getClassOrAnonymousClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (typeElements = parameterList.getTypeParameterElements()).length == 1 && typeElements[0].getType() instanceof PsiDiamondType) {
            owner = containingClass;
        }
        return owner;
    }

    private static boolean isTypeParameterType(PsiTypeParameterListOwner method, PsiType paramType) {
        PsiClass psiClass = PsiUtil.resolveClassInType(paramType);
        return psiClass instanceof PsiTypeParameter && ((PsiTypeParameter)psiClass).getOwner() == method;
    }

    private static PsiType getParameterType(PsiParameter[] parameters, int i, @Nullable PsiSubstitutor substitutor, boolean varargs) {
        PsiType parameterType;
        if (substitutor == null) {
            return null;
        }
        PsiParameter parameter = parameters[i < parameters.length ? i : parameters.length - 1];
        PsiType type = parameter.getType();
        if (!type.isValid()) {
            PsiUtil.ensureValidType(type, "Invalid type of parameter " + parameter + " of " + parameter.getClass());
        }
        if ((parameterType = substitutor.substitute(type)) instanceof PsiEllipsisType && varargs) {
            parameterType = ((PsiEllipsisType)parameterType).getComponentType();
        }
        return parameterType;
    }

    @NotNull
    public PsiSubstitutor infer() {
        PsiSubstitutor psiSubstitutor = this.infer(null, null, null);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent) {
        Iterator<PsiTypeParameter> iterator;
        Map<PsiTypeParameter, PsiType> map;
        PsiSubstitutor substitutor;
        MethodCandidateInfo.CurrentCandidateProperties properties = InferenceSession.getCurrentProperties(parent);
        if (!this.repeatInferencePhases(true)) {
            PsiSubstitutor psiSubstitutor = this.resolveSubset(this.myInferenceVariables, this.mySiteSubstitutor);
            PsiSubstitutor psiSubstitutor2 = psiSubstitutor;
            if (psiSubstitutor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
            }
            return psiSubstitutor2;
        }
        if (properties != null && !properties.isApplicabilityCheck()) {
            this.initReturnTypeConstraint(properties.getMethod(), (PsiCall)parent);
            if (!this.repeatInferencePhases(true)) {
                PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
                PsiSubstitutor psiSubstitutor3 = psiSubstitutor;
                if (psiSubstitutor3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
                }
                return psiSubstitutor3;
            }
            if (parameters != null && args != null) {
                LinkedHashSet<ConstraintFormula> additionalConstraints = new LinkedHashSet<ConstraintFormula>();
                if (parameters.length > 0) {
                    this.collectAdditionalConstraints(parameters, args, properties.getMethod(), this.mySiteSubstitutor, additionalConstraints, properties.isVarargs());
                }
                if (!additionalConstraints.isEmpty() && !this.proceedWithAdditionalConstraints(additionalConstraints)) {
                    PsiSubstitutor psiSubstitutor = this.prepareSubstitution().putAll(this.retrieveNonPrimitiveEqualsBounds(this.myInferenceVariables));
                    PsiSubstitutor psiSubstitutor4 = psiSubstitutor;
                    if (psiSubstitutor4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
                    }
                    return psiSubstitutor4;
                }
            }
        }
        if ((substitutor = this.resolveBounds(this.myInferenceVariables, PsiSubstitutor.EMPTY)) != null) {
            if (this.myContext != null) {
                this.myContext.putUserData(ERASED, this.myErased);
            }
            map = substitutor.getSubstitutionMap();
            iterator = map.keySet().iterator();
        } else {
            PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
            PsiSubstitutor psiSubstitutor5 = psiSubstitutor;
            if (psiSubstitutor5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
            }
            return psiSubstitutor5;
        }
        while (iterator.hasNext()) {
            PsiTypeParameter param;
            PsiTypeParameter parameter = iterator.next();
            PsiType mapping = map.get(parameter);
            if (parameter instanceof InferenceVariable) {
                ((InferenceVariable)parameter).setInstantiation(mapping);
                if (((InferenceVariable)parameter).getCallContext() != this.myContext) continue;
                param = ((InferenceVariable)parameter).getParameter();
            } else {
                param = parameter;
            }
            this.mySiteSubstitutor = this.mySiteSubstitutor.put(param, mapping);
        }
        PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
        PsiSubstitutor psiSubstitutor6 = psiSubstitutor;
        if (psiSubstitutor6 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor6;
        finally {
            if (properties != null && this.myErrorMessages != null) {
                properties.getInfo().setInferenceError(StringUtil.join(this.myErrorMessages, "\n"));
            }
        }
    }

    private void collectAdditionalConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiMethod parentMethod, PsiSubstitutor siteSubstitutor, Set<ConstraintFormula> additionalConstraints, boolean varargs) {
        for (int i = 0; i < args.length; ++i) {
            PsiExpression arg = PsiUtil.skipParenthesizedExprDown(args[i]);
            if (arg == null) continue;
            if (MethodCandidateInfo.isOverloadCheck() && arg instanceof PsiLambdaExpression) {
                for (Object expr : MethodCandidateInfo.ourOverloadGuard.currentStack()) {
                    if (PsiTreeUtil.getParentOfType((PsiElement)expr, PsiLambdaExpression.class) != arg) continue;
                    return;
                }
            }
            InferenceSession nestedCallSession = this.findNestedCallSession(arg);
            PsiType parameterType = nestedCallSession.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters, i, siteSubstitutor, varargs));
            if (!InferenceSession.isPertinentToApplicability(arg, parentMethod)) {
                additionalConstraints.add(new ExpressionCompatibilityConstraint(arg, parameterType));
            }
            additionalConstraints.add(new CheckedExceptionCompatibilityConstraint(arg, parameterType));
            if (arg instanceof PsiCall) {
                PsiMethod calledMethod = InferenceSession.getCalledMethod((PsiCall)((Object)arg));
                if (calledMethod == null || !PsiPolyExpressionUtil.isMethodCallPolyExpression(arg, calledMethod)) continue;
                this.collectAdditionalConstraints(additionalConstraints, (PsiCall)((Object)arg));
                continue;
            }
            if (!(arg instanceof PsiLambdaExpression) || !InferenceSession.isPertinentToApplicability(arg, parentMethod) || this.isProperType(this.retrieveNonPrimitiveEqualsBounds(this.myInferenceVariables).substitute(parameterType))) continue;
            this.collectLambdaReturnExpression(additionalConstraints, (PsiLambdaExpression)arg, parameterType);
        }
    }

    private static PsiMethod getCalledMethod(PsiCall arg) {
        PsiExpressionList argumentList = arg.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod(argumentList);
        if (properties != null) {
            return properties.getMethod();
        }
        JavaResolveResult resolveResult = InferenceSession.getMethodResult(arg);
        if (resolveResult instanceof MethodCandidateInfo) {
            return (PsiMethod)resolveResult.getElement();
        }
        return null;
    }

    private void collectLambdaReturnExpression(Set<ConstraintFormula> additionalConstraints, PsiLambdaExpression lambdaExpression, PsiType parameterType) {
        PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(parameterType);
        if (interfaceReturnType != null) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(lambdaExpression);
            for (PsiExpression returnExpression : returnExpressions) {
                this.processReturnExpression(additionalConstraints, returnExpression, interfaceReturnType);
            }
        }
    }

    private void processReturnExpression(Set<ConstraintFormula> additionalConstraints, PsiExpression returnExpression, PsiType functionalType) {
        if (returnExpression instanceof PsiCallExpression) {
            PsiMethod calledMethod = InferenceSession.getCalledMethod((PsiCallExpression)returnExpression);
            if (calledMethod != null && PsiPolyExpressionUtil.isMethodCallPolyExpression(returnExpression, calledMethod)) {
                this.collectAdditionalConstraints(additionalConstraints, (PsiCallExpression)returnExpression);
            }
        } else if (returnExpression instanceof PsiParenthesizedExpression) {
            this.processReturnExpression(additionalConstraints, ((PsiParenthesizedExpression)returnExpression).getExpression(), functionalType);
        } else if (returnExpression instanceof PsiConditionalExpression) {
            this.processReturnExpression(additionalConstraints, ((PsiConditionalExpression)returnExpression).getThenExpression(), functionalType);
            this.processReturnExpression(additionalConstraints, ((PsiConditionalExpression)returnExpression).getElseExpression(), functionalType);
        } else if (returnExpression instanceof PsiLambdaExpression) {
            this.collectLambdaReturnExpression(additionalConstraints, (PsiLambdaExpression)returnExpression, functionalType);
        }
    }

    private void collectAdditionalConstraints(Set<ConstraintFormula> additionalConstraints, PsiCall callExpression) {
        PsiExpressionList argumentList = callExpression.getArgumentList();
        if (argumentList != null) {
            PsiMethod method;
            JavaResolveResult result = InferenceSession.getMethodResult(callExpression);
            MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod(argumentList);
            PsiMethod psiMethod = result instanceof MethodCandidateInfo ? ((MethodCandidateInfo)result).getElement() : (method = properties != null ? properties.getMethod() : null);
            if (method != null) {
                PsiExpression[] newArgs = argumentList.getExpressions();
                PsiParameter[] newParams = method.getParameterList().getParameters();
                if (newParams.length > 0) {
                    this.collectAdditionalConstraints(newParams, newArgs, method, InferenceSession.chooseSiteSubstitutor(properties, result, method), additionalConstraints, InferenceSession.chooseVarargsMode(properties, result));
                }
            }
        }
    }

    private static JavaResolveResult getMethodResult(final PsiCall callExpression) {
        PsiExpressionList argumentList = callExpression.getArgumentList();
        PsiLambdaExpression expression = PsiTreeUtil.getParentOfType((PsiElement)argumentList, PsiLambdaExpression.class);
        Computable<JavaResolveResult> computableResolve = new Computable<JavaResolveResult>(){

            @Override
            public JavaResolveResult compute() {
                return InferenceSession.getResolveResult(callExpression);
            }
        };
        MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod(argumentList);
        return properties != null ? null : (expression == null || !PsiResolveHelper.ourGraphGuard.currentStack().contains(expression) ? (JavaResolveResult)computableResolve.compute() : PsiResolveHelper.ourGraphGuard.doPreventingRecursion(expression, false, computableResolve));
    }

    public static JavaResolveResult getResolveResult(final PsiCall callExpression) {
        if (callExpression instanceof PsiNewExpression) {
            PsiUtilCore.ensureValid(callExpression);
            return CachedValuesManager.getCachedValue(callExpression, new CachedValueProvider<JavaResolveResult>(){

                @Override
                @Nullable
                public CachedValueProvider.Result<JavaResolveResult> compute() {
                    PsiElement psiClass;
                    PsiJavaCodeReferenceElement classReference = ((PsiNewExpression)callExpression).getClassOrAnonymousClassReference();
                    JavaResolveResult constructor = JavaResolveResult.EMPTY;
                    JavaResolveResult resolveResult = null;
                    if (classReference != null && (psiClass = (resolveResult = classReference.advancedResolve(false)).getElement()) != null) {
                        JavaPsiFacade facade = JavaPsiFacade.getInstance(callExpression.getProject());
                        PsiExpressionList argumentList = callExpression.getArgumentList();
                        if (argumentList != null) {
                            constructor = facade.getResolveHelper().resolveConstructor(facade.getElementFactory().createType((PsiClass)psiClass).rawType(), argumentList, callExpression);
                        }
                    }
                    return new CachedValueProvider.Result<JavaResolveResult>(constructor.getElement() == null && resolveResult != null ? resolveResult : constructor, PsiModificationTracker.MODIFICATION_COUNT);
                }
            });
        }
        return callExpression.resolveMethodGenerics();
    }

    public static PsiSubstitutor chooseSiteSubstitutor(MethodCandidateInfo.CurrentCandidateProperties candidateProperties, JavaResolveResult resolveResult, PsiMethod method) {
        return resolveResult instanceof MethodCandidateInfo && method != null && !method.isConstructor() ? ((MethodCandidateInfo)resolveResult).getSiteSubstitutor() : (candidateProperties != null ? candidateProperties.getSubstitutor() : PsiSubstitutor.EMPTY);
    }

    public static boolean chooseVarargsMode(MethodCandidateInfo.CurrentCandidateProperties candidateProperties, JavaResolveResult resolveResult) {
        return resolveResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)resolveResult).isVarargs() || candidateProperties != null && candidateProperties.isVarargs();
    }

    public PsiSubstitutor retrieveNonPrimitiveEqualsBounds(Collection<InferenceVariable> variables) {
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : variables) {
            PsiType equalsBound = this.getEqualsBound(variable, substitutor);
            if (equalsBound instanceof PsiPrimitiveType) continue;
            substitutor = substitutor.put(variable, equalsBound);
        }
        return substitutor;
    }

    private PsiSubstitutor prepareSubstitution() {
        ArrayList<InferenceVariable> allVars = new ArrayList<InferenceVariable>(this.myInferenceVariables);
        while (!allVars.isEmpty()) {
            List<InferenceVariable> variables = InferenceVariablesOrder.resolveOrder(allVars, this);
            for (InferenceVariable inferenceVariable : variables) {
                PsiTypeParameter typeParameter = inferenceVariable.getParameter();
                PsiType instantiation = inferenceVariable.getInstantiation();
                if (instantiation != PsiType.NULL) continue;
                this.checkBoundsConsistency(this.mySiteSubstitutor, inferenceVariable);
                this.mySiteSubstitutor = this.mySiteSubstitutor.put(typeParameter, JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(typeParameter));
            }
            allVars.removeAll(variables);
        }
        return this.mySiteSubstitutor;
    }

    public void initBounds(PsiTypeParameter ... typeParameters) {
        this.initBounds(this.myContext, typeParameters);
    }

    public InferenceVariable[] initBounds(PsiElement context, PsiTypeParameter ... typeParameters) {
        ArrayList<InferenceVariable> result = new ArrayList<InferenceVariable>(typeParameters.length);
        for (PsiTypeParameter parameter : typeParameters) {
            InferenceVariable variable = new InferenceVariable(context, parameter);
            result.add(variable);
            this.myInferenceSubstitution = this.myInferenceSubstitution.put(parameter, JavaPsiFacade.getElementFactory(variable.getProject()).createType(variable));
        }
        for (InferenceVariable variable : result) {
            PsiClassType[] extendsListTypes;
            PsiTypeParameter parameter = variable.getParameter();
            boolean added = false;
            for (PsiType classType : extendsListTypes = parameter.getExtendsListTypes()) {
                if (this.isProperType(classType = this.substituteWithInferenceVariables(this.mySiteSubstitutor.substitute(classType)))) {
                    added = true;
                }
                variable.addBound(classType, InferenceBound.UPPER);
            }
            if (added) continue;
            variable.addBound(PsiType.getJavaLangObject(parameter.getManager(), parameter.getResolveScope()), InferenceBound.UPPER);
        }
        this.myInferenceVariables.addAll(result);
        return result.toArray(new InferenceVariable[result.size()]);
    }

    private void initReturnTypeConstraint(PsiMethod method, PsiCall context) {
        PsiType targetType;
        PsiType returnType;
        if (context instanceof PsiCallExpression && PsiPolyExpressionUtil.isMethodCallPolyExpression((PsiExpression)((Object)context), method) && !PsiType.VOID.equals(returnType = method.getReturnType()) && returnType != null && (targetType = InferenceSession.getTargetType(context)) != null && !PsiType.VOID.equals(targetType)) {
            this.registerReturnTypeConstraints(PsiUtil.isRawSubstitutor(method, this.mySiteSubstitutor) ? returnType : this.mySiteSubstitutor.substitute(returnType), targetType);
        }
    }

    public void registerReturnTypeConstraints(PsiType returnType, PsiType targetType) {
        InferenceVariable inferenceVariable = this.shouldResolveAndInstantiate(returnType = this.substituteWithInferenceVariables(returnType), targetType);
        if (inferenceVariable != null) {
            PsiSubstitutor substitutor = this.resolveSubset(Collections.singletonList(inferenceVariable), this.mySiteSubstitutor);
            PsiType substitutedReturnType = substitutor.substitute(inferenceVariable.getParameter());
            if (substitutedReturnType != null) {
                this.addConstraint(new TypeCompatibilityConstraint(targetType, PsiImplUtil.normalizeWildcardTypeByPosition(substitutedReturnType, (PsiExpression)this.myContext)));
            }
        } else if (FunctionalInterfaceParameterizationUtil.isWildcardParameterized(returnType)) {
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(returnType);
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass != null) {
                LOG.assertTrue(returnType instanceof PsiClassType);
                PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
                PsiTypeParameter[] copy = this.initBounds((PsiElement)null, typeParameters);
                PsiType substitutedCapture = PsiImplUtil.normalizeWildcardTypeByPosition(returnType, (PsiExpression)this.myContext);
                this.myIncorporationPhase.addCapture(copy, (PsiClassType)this.substituteWithInferenceVariables(returnType));
                this.addConstraint(new TypeCompatibilityConstraint(targetType, substitutedCapture));
            }
        } else {
            this.addConstraint(new TypeCompatibilityConstraint(targetType, this.myErased ? TypeConversionUtil.erasure(returnType) : returnType));
        }
    }

    private InferenceVariable shouldResolveAndInstantiate(PsiType returnType, PsiType targetType) {
        InferenceVariable inferenceVariable = this.getInferenceVariable(returnType);
        if (inferenceVariable != null) {
            if (targetType instanceof PsiPrimitiveType && InferenceSession.hasPrimitiveWrapperBound(inferenceVariable)) {
                return inferenceVariable;
            }
            if (targetType instanceof PsiClassType && (this.myErased || InferenceSession.hasUncheckedBounds(inferenceVariable, (PsiClassType)targetType) || InferenceSession.hasWildcardParameterization(inferenceVariable, (PsiClassType)targetType))) {
                return inferenceVariable;
            }
        }
        return null;
    }

    private static boolean hasPrimitiveWrapperBound(InferenceVariable inferenceVariable) {
        InferenceBound[] boundTypes;
        for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.UPPER, InferenceBound.LOWER, InferenceBound.EQ}) {
            List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
            for (PsiType bound : bounds) {
                if (PsiPrimitiveType.getUnboxedType(bound) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasUncheckedBounds(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!targetType.isRaw()) {
            InferenceBound[] boundTypes;
            for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.EQ, InferenceBound.LOWER}) {
                List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
                for (PsiType bound : bounds) {
                    if (!TypeCompatibilityConstraint.isUncheckedConversion(targetType, bound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasWildcardParameterization(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(targetType)) {
            Processor<Pair<PsiType, PsiType>> differentParameterizationProcessor;
            List<PsiType> bounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            if (InferenceSession.findParameterizationOfTheSameGenericClass(bounds, differentParameterizationProcessor = new Processor<Pair<PsiType, PsiType>>(){

                @Override
                public boolean process(Pair<PsiType, PsiType> pair) {
                    return pair.first == null || pair.second == null || !TypesDistinctProver.provablyDistinct((PsiType)pair.first, (PsiType)pair.second);
                }
            }) != null) {
                return true;
            }
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            ArrayList<PsiType> boundsToCheck = new ArrayList<PsiType>(bounds);
            boundsToCheck.addAll(eqBounds);
            for (PsiType lowBound : boundsToCheck) {
                if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(lowBound)) continue;
                return true;
            }
        }
        return false;
    }

    public static PsiType getTargetType(PsiElement context) {
        PsiType targetType = PsiTypesUtil.getExpectedTypeByParent(context);
        if (targetType != null) {
            return targetType;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(context.getParent());
        if (parent instanceof PsiExpressionList) {
            PsiExpressionList argumentList;
            PsiElement gParent = parent.getParent();
            if (gParent instanceof PsiAnonymousClass) {
                gParent = gParent.getParent();
            }
            if (gParent instanceof PsiCall && (argumentList = ((PsiCall)gParent).getArgumentList()) != null) {
                MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod(argumentList);
                if (properties != null && properties.isApplicabilityCheck()) {
                    return InferenceSession.getTypeByMethod(context, argumentList, properties.getMethod(), properties.isVarargs(), properties.getSubstitutor());
                }
                final JavaResolveResult result = properties != null ? properties.getInfo() : ((PsiCall)gParent).resolveMethodGenerics();
                boolean varargs = InferenceSession.chooseVarargsMode(properties, result);
                PsiSubstitutor substitutor = PsiResolveHelper.ourGraphGuard.doPreventingRecursion(context, false, new Computable<PsiSubstitutor>(){

                    @Override
                    public PsiSubstitutor compute() {
                        return result.getSubstitutor();
                    }
                });
                if (substitutor == null && properties != null) {
                    substitutor = properties.getSubstitutor();
                }
                return InferenceSession.getTypeByMethod(context, argumentList, result.getElement(), varargs, substitutor);
            }
        } else {
            if (parent instanceof PsiConditionalExpression) {
                return InferenceSession.getTargetType(parent);
            }
            if (parent instanceof PsiLambdaExpression) {
                return InferenceSession.getTargetTypeByContainingLambda((PsiLambdaExpression)parent);
            }
            if (parent instanceof PsiReturnStatement) {
                return InferenceSession.getTargetTypeByContainingLambda(PsiTreeUtil.getParentOfType(parent, PsiLambdaExpression.class));
            }
        }
        return null;
    }

    private static PsiType getTargetTypeByContainingLambda(PsiLambdaExpression lambdaExpression) {
        if (lambdaExpression != null) {
            if (PsiUtil.skipParenthesizedExprUp(lambdaExpression.getParent()) instanceof PsiExpressionList) {
                PsiType typeTypeByParentCall = InferenceSession.getTargetType(lambdaExpression);
                return LambdaUtil.getFunctionalInterfaceReturnType(FunctionalInterfaceParameterizationUtil.getGroundTargetType(typeTypeByParentCall, lambdaExpression));
            }
            return LambdaUtil.getFunctionalInterfaceReturnType(lambdaExpression.getFunctionalInterfaceType());
        }
        return null;
    }

    private static PsiType getTypeByMethod(PsiElement context, PsiExpressionList argumentList, PsiElement parentMethod, boolean varargs, PsiSubstitutor substitutor) {
        if (parentMethod instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)parentMethod).getParameterList().getParameters();
            if (parameters.length == 0) {
                return null;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (!((PsiMethod)parentMethod).isVarArgs() && parameters.length != args.length) {
                return null;
            }
            PsiElement arg = context;
            while (arg.getParent() instanceof PsiParenthesizedExpression) {
                arg = arg.getParent();
            }
            int i = ArrayUtilRt.find(args, arg);
            if (i < 0) {
                return null;
            }
            PsiType parameterType = InferenceSession.getParameterType(parameters, i, substitutor, varargs);
            boolean isRaw = substitutor != null && PsiUtil.isRawSubstitutor((PsiMethod)parentMethod, substitutor);
            return isRaw ? TypeConversionUtil.erasure(parameterType) : parameterType;
        }
        return null;
    }

    public InferenceVariable getInferenceVariable(PsiType psiType) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(psiType);
        if (psiClass instanceof InferenceVariable) {
            return (InferenceVariable)psiClass;
        }
        return null;
    }

    public boolean isProperType(@Nullable PsiType type) {
        return this.collectDependencies(type, null);
    }

    public boolean collectDependencies(@Nullable PsiType type, final @Nullable Set<InferenceVariable> dependencies) {
        if (type == null) {
            return true;
        }
        Boolean isProper = type.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitType(PsiType type) {
                return true;
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }

            @Override
            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound == null) {
                    return true;
                }
                return bound.accept(this);
            }

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                InferenceVariable inferenceVariable = InferenceSession.this.getInferenceVariable(classType);
                if (inferenceVariable != null) {
                    if (dependencies != null) {
                        dependencies.add(inferenceVariable);
                        return true;
                    }
                    return false;
                }
                for (PsiType psiType : classType.getParameters()) {
                    if (psiType.accept(this).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        });
        return dependencies != null ? !dependencies.isEmpty() : isProper;
    }

    public boolean repeatInferencePhases(boolean incorporate) {
        do {
            if (!this.reduceConstraints()) {
                return false;
            }
            if (!incorporate || this.myIncorporationPhase.incorporate()) continue;
            return false;
        } while (incorporate && !this.myIncorporationPhase.isFullyIncorporated() || this.myConstraintIdx < this.myConstraints.size());
        return true;
    }

    private boolean reduceConstraints() {
        ArrayList<ConstraintFormula> newConstraints = new ArrayList<ConstraintFormula>();
        for (int i = this.myConstraintIdx; i < this.myConstraints.size(); ++i) {
            ConstraintFormula constraint = this.myConstraints.get(i);
            if (constraint.reduce(this, newConstraints)) continue;
            return false;
        }
        this.myConstraintIdx = this.myConstraints.size();
        for (ConstraintFormula constraint : newConstraints) {
            this.addConstraint(constraint);
        }
        return true;
    }

    private boolean isThrowable(List<PsiType> upperBounds) {
        boolean commonThrowable = false;
        for (PsiType upperBound : upperBounds) {
            if (upperBound.equalsToText("java.lang.Object") || !this.isProperType(upperBound)) continue;
            if (upperBound.equalsToText("java.lang.Exception") || upperBound.equalsToText("java.lang.Throwable")) {
                commonThrowable = true;
                continue;
            }
            return false;
        }
        return commonThrowable;
    }

    private PsiType substituteNonProperBound(PsiType bound, PsiSubstitutor substitutor) {
        LinkedHashSet<InferenceVariable> dependencies = new LinkedHashSet<InferenceVariable>();
        if (!this.collectDependencies(bound, dependencies)) {
            return bound;
        }
        for (InferenceVariable dependency : dependencies) {
            PsiType instantiation = dependency.getInstantiation();
            if (instantiation == PsiType.NULL) continue;
            substitutor = substitutor.put(dependency, instantiation);
        }
        return substitutor.substitute(bound);
    }

    private boolean hasBoundProblems(List<InferenceVariable> typeParams, PsiSubstitutor substitutor) {
        for (InferenceVariable typeParameter : typeParams) {
            List<PsiType> extendsTypes;
            PsiType[] bounds;
            if (GenericsUtil.findTypeParameterBoundError(typeParameter, bounds = (extendsTypes = typeParameter.getBounds(InferenceBound.UPPER)).toArray(new PsiType[extendsTypes.size()]), substitutor, this.myContext, true) == null) continue;
            return true;
        }
        return false;
    }

    private PsiSubstitutor resolveBounds(Collection<InferenceVariable> inferenceVariables, PsiSubstitutor substitutor) {
        ArrayList<InferenceVariable> allVars = new ArrayList<InferenceVariable>(inferenceVariables);
        while (!allVars.isEmpty()) {
            List<InferenceVariable> vars = InferenceVariablesOrder.resolveOrder(allVars, this);
            if (!this.myIncorporationPhase.hasCaptureConstraints(vars)) {
                PsiSubstitutor firstSubstitutor = this.resolveSubset(vars, substitutor);
                if (this.hasBoundProblems(vars, firstSubstitutor)) {
                    firstSubstitutor = null;
                }
                if (firstSubstitutor != null) {
                    substitutor = firstSubstitutor;
                    allVars.removeAll(vars);
                    continue;
                }
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.getManager().getProject());
            PsiTypeParameter[] freshParameters = this.createFreshVariables(vars, substitutor);
            for (int i = 0; i < freshParameters.length; ++i) {
                PsiTypeParameter parameter = freshParameters[i];
                InferenceVariable var = vars.get(i);
                PsiType lub = this.getLowerBound(var, substitutor);
                if (lub != PsiType.NULL) {
                    for (PsiClassType upperBoundType : parameter.getExtendsListTypes()) {
                        if (TypeConversionUtil.isAssignable(upperBoundType, lub)) continue;
                        return null;
                    }
                    parameter.putUserData(LOWER_BOUND, lub);
                }
                if (var.addBound(elementFactory.createType(parameter), InferenceBound.EQ)) continue;
                return null;
            }
            this.myIncorporationPhase.forgetCaptures(vars);
            if (this.repeatInferencePhases(true)) continue;
            return null;
        }
        return substitutor;
    }

    private PsiTypeParameter[] createFreshVariables(List<InferenceVariable> vars, final PsiSubstitutor siteSubstitutor) {
        PsiTypeParameter[] parameters;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.getManager().getProject());
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiTypeParameter[] yVars = new PsiTypeParameter[vars.size()];
        for (int i = 0; i < vars.size(); ++i) {
            InferenceVariable var = vars.get(i);
            PsiTypeParameter parameter = var.getParameter();
            yVars[i] = elementFactory.createTypeParameterFromText(InferenceSession.getFreshVariableName(var), parameter);
            substitutor = substitutor.put(var, elementFactory.createType(yVars[i]));
        }
        final PsiSubstitutor ySubstitutor = substitutor;
        String classText = "class I<" + StringUtil.join(vars, new Function<InferenceVariable, String>(){

            @Override
            public String fun(InferenceVariable variable) {
                PsiType glb = InferenceSession.this.composeBound(variable, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, ySubstitutor.putAll(siteSubstitutor), true);
                return InferenceSession.getFreshVariableName(variable) + " extends " + glb.getInternalCanonicalText();
            }
        }, ", ") + ">{}";
        PsiFile file = PsiFileFactory.getInstance(this.getManager().getProject()).createFileFromText("inference_dummy.java", JavaFileType.INSTANCE, (CharSequence)classText);
        LOG.assertTrue(file instanceof PsiJavaFile, classText);
        PsiClass[] classes = ((PsiJavaFile)file).getClasses();
        LOG.assertTrue(classes.length == 1, classText);
        for (PsiTypeParameter parameter : parameters = classes[0].getTypeParameters()) {
            parameter.putUserData(ORIGINAL_CONTEXT, this.myContext);
        }
        return parameters;
    }

    private static String getFreshVariableName(InferenceVariable var) {
        return var.getName();
    }

    private PsiSubstitutor resolveSubsetOrdered(Set<InferenceVariable> varsToResolve, PsiSubstitutor siteSubstitutor) {
        PsiSubstitutor substitutor = siteSubstitutor;
        HashSet<InferenceVariable> copy = new HashSet<InferenceVariable>(varsToResolve);
        while (!copy.isEmpty()) {
            List<InferenceVariable> vars = InferenceVariablesOrder.resolveOrder(copy, this);
            PsiSubstitutor resolveSubset = this.resolveSubset(vars, substitutor);
            copy.removeAll(vars);
            substitutor = substitutor.putAll(resolveSubset);
        }
        return substitutor;
    }

    @NotNull
    private PsiSubstitutor resolveSubset(Collection<InferenceVariable> vars, PsiSubstitutor substitutor) {
        for (InferenceVariable var : vars) {
            LOG.assertTrue(var.getInstantiation() == PsiType.NULL);
            PsiType type = this.checkBoundsConsistency(substitutor, var);
            if (type == PsiType.NULL) continue;
            substitutor = substitutor.put(var, type);
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "resolveSubset"));
        }
        return psiSubstitutor;
    }

    private PsiType checkBoundsConsistency(PsiSubstitutor substitutor, InferenceVariable var) {
        PsiType type;
        PsiType eqBound = this.getEqualsBound(var, substitutor);
        if (eqBound != PsiType.NULL && eqBound instanceof PsiPrimitiveType) {
            return PsiType.NULL;
        }
        PsiType lowerBound = this.getLowerBound(var, substitutor);
        PsiType upperBound = this.getUpperBound(var, substitutor);
        if (eqBound != PsiType.NULL && (this.myErased || eqBound != null)) {
            if (lowerBound != PsiType.NULL && !TypeConversionUtil.isAssignable(eqBound, lowerBound)) {
                this.registerIncompatibleErrorMessage(this.incompatibleBoundsMessage(var, substitutor, InferenceBound.EQ, EQUALITY_CONSTRAINTS_PRESENTATION, InferenceBound.LOWER, LOWER_BOUNDS_PRESENTATION));
                return PsiType.NULL;
            }
            type = eqBound;
        } else {
            type = lowerBound;
        }
        if (type == PsiType.NULL) {
            String conflictingConjunctsMessage;
            if (var.isThrownBound() && this.isThrowable(var.getBounds(InferenceBound.UPPER))) {
                type = PsiType.getJavaLangRuntimeException(this.myManager, GlobalSearchScope.allScope(this.myManager.getProject()));
            } else {
                PsiType psiType = type = this.myErased ? null : upperBound;
            }
            if (type instanceof PsiIntersectionType && (conflictingConjunctsMessage = ((PsiIntersectionType)type).getConflictingConjunctsMessage()) != null) {
                this.registerIncompatibleErrorMessage("Type parameter " + var.getName() + " has incompatible upper bounds: " + conflictingConjunctsMessage);
                return PsiType.NULL;
            }
        } else {
            for (PsiType upperType : var.getBounds(InferenceBound.UPPER)) {
                if (!this.isProperType(upperType)) continue;
                String incompatibleBoundsMessage = null;
                if (type != lowerBound && !TypeConversionUtil.isAssignable(substitutor.substitute(upperType), type)) {
                    incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor, InferenceBound.EQ, EQUALITY_CONSTRAINTS_PRESENTATION, InferenceBound.UPPER, UPPER_BOUNDS_PRESENTATION);
                } else if (type == lowerBound && !TypeConversionUtil.isAssignable(substitutor.substitute(upperType), lowerBound)) {
                    incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor, InferenceBound.LOWER, LOWER_BOUNDS_PRESENTATION, InferenceBound.UPPER, UPPER_BOUNDS_PRESENTATION);
                }
                if (incompatibleBoundsMessage == null) continue;
                this.registerIncompatibleErrorMessage(incompatibleBoundsMessage);
                return PsiType.NULL;
            }
        }
        return type;
    }

    private void registerIncompatibleErrorMessage(String value) {
        if (this.myErrorMessages == null) {
            this.myErrorMessages = new ArrayList<String>();
        }
        if (!this.myErrorMessages.contains(value)) {
            this.myErrorMessages.add(value);
        }
    }

    private String incompatibleBoundsMessage(InferenceVariable var, final PsiSubstitutor substitutor, InferenceBound lowBound, String lowBoundName, InferenceBound upperBound, String upperBoundName) {
        Function<PsiType, String> typePresentation = new Function<PsiType, String>(){

            @Override
            public String fun(PsiType type) {
                PsiType substituted = InferenceSession.this.substituteNonProperBound(type, substitutor);
                return (substituted != null ? substituted : type).getPresentableText();
            }
        };
        return "inference variable " + var.getName() + " has incompatible bounds:\n " + lowBoundName + ": " + StringUtil.join(var.getBounds(lowBound), typePresentation, ", ") + "\n" + upperBoundName + ": " + StringUtil.join(var.getBounds(upperBound), typePresentation, ", ");
    }

    private PsiType getLowerBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.LOWER, new Function<Pair<PsiType, PsiType>, PsiType>(){

            @Override
            public PsiType fun(Pair<PsiType, PsiType> pair) {
                return GenericsUtil.getLeastUpperBound((PsiType)pair.first, (PsiType)pair.second, InferenceSession.this.myManager);
            }
        }, substitutor);
    }

    private PsiType getUpperBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, substitutor);
    }

    public PsiType getEqualsBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.EQ, new Function<Pair<PsiType, PsiType>, PsiType>(){

            @Override
            public PsiType fun(Pair<PsiType, PsiType> pair) {
                return !Comparing.equal(pair.first, pair.second) ? null : (PsiType)pair.first;
            }
        }, substitutor);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor) {
        return this.composeBound(variable, boundType, fun, substitutor, false);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor, boolean includeNonProperBounds) {
        List<PsiType> lowerBounds = variable.getBounds(boundType);
        PsiType lub = PsiType.NULL;
        for (PsiType lowerBound : lowerBounds) {
            lowerBound = this.substituteNonProperBound(lowerBound, substitutor);
            if (!includeNonProperBounds && !this.isProperType(lowerBound)) continue;
            if (lub == PsiType.NULL) {
                lub = lowerBound;
                continue;
            }
            Pair<PsiPrimitiveType, PsiType> pair = Pair.create(lub, lowerBound);
            if ((lub = fun.fun(pair)) != null) continue;
            return PsiType.NULL;
        }
        return lub;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public GlobalSearchScope getScope() {
        return GlobalSearchScope.allScope(this.myManager.getProject());
    }

    public Collection<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables;
    }

    public void addConstraint(ConstraintFormula constraint) {
        if (this.myConstraintsCopy.add(constraint)) {
            this.myConstraints.add(constraint);
        }
    }

    private boolean proceedWithAdditionalConstraints(Set<ConstraintFormula> additionalConstraints) {
        PsiSubstitutor siteSubstitutor = PsiSubstitutor.EMPTY;
        while (!additionalConstraints.isEmpty()) {
            Set<ConstraintFormula> subset = this.buildSubset(additionalConstraints);
            LinkedHashSet<InferenceVariable> varsToResolve = new LinkedHashSet<InferenceVariable>();
            for (ConstraintFormula formula : subset) {
                if (!(formula instanceof InputOutputConstraintFormula)) continue;
                this.collectVarsToResolve(varsToResolve, (InputOutputConstraintFormula)formula);
            }
            for (ConstraintFormula formula : subset) {
                if (this.processOneConstraint(formula, siteSubstitutor, varsToResolve, additionalConstraints)) continue;
                return false;
            }
        }
        return true;
    }

    private void collectVarsToResolve(Set<InferenceVariable> varsToResolve, InputOutputConstraintFormula formula) {
        Set<InferenceVariable> inputVariables = formula.getInputVariables(this);
        if (inputVariables != null) {
            for (InferenceVariable inputVariable : inputVariables) {
                varsToResolve.addAll(inputVariable.getDependencies(this));
            }
            varsToResolve.addAll(inputVariables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processOneConstraint(ConstraintFormula formula, PsiSubstitutor siteSubstitutor, Set<InferenceVariable> varsToResolve, Set<ConstraintFormula> additionalConstraints) {
        InferenceSession session;
        PsiExpression expression;
        PsiCall callExpression;
        if (formula instanceof ExpressionCompatibilityConstraint && (callExpression = PsiTreeUtil.getParentOfType((PsiElement)(expression = ((ExpressionCompatibilityConstraint)formula).getExpression()), PsiCall.class, false)) != null && (session = this.myNestedSessions.get(callExpression)) != null) {
            formula.apply(session.myInferenceSubstitution, true);
            this.collectVarsToResolve(varsToResolve, (InputOutputConstraintFormula)formula);
        }
        PsiSubstitutor substitutor = this.resolveSubsetOrdered(varsToResolve, siteSubstitutor);
        if (this.myContext instanceof PsiCall) {
            PsiExpressionList argumentList = ((PsiCall)this.myContext).getArgumentList();
            LOG.assertTrue(argumentList != null);
            MethodCandidateInfo.updateSubstitutor(argumentList, substitutor);
        }
        try {
            PsiType parameterType;
            PsiExpression expression2;
            formula.apply(substitutor, true);
            this.myConstraints.add(formula);
            if (!this.repeatInferencePhases(true)) {
                boolean argumentList = false;
                return argumentList;
            }
            if (formula instanceof ExpressionCompatibilityConstraint && (expression2 = ((ExpressionCompatibilityConstraint)formula).getExpression()) instanceof PsiLambdaExpression && !this.isProperType(parameterType = ((ExpressionCompatibilityConstraint)formula).getT())) {
                this.collectLambdaReturnExpression(additionalConstraints, (PsiLambdaExpression)expression2, parameterType);
            }
        }
        finally {
            if (formula instanceof InputOutputConstraintFormula) {
                LambdaUtil.getFunctionalTypeMap().remove(((InputOutputConstraintFormula)formula).getExpression());
            }
        }
        return true;
    }

    private Set<ConstraintFormula> buildSubset(Set<ConstraintFormula> additionalConstraints) {
        LinkedHashSet<ConstraintFormula> subset = new LinkedHashSet<ConstraintFormula>();
        HashSet<InferenceVariable> outputVariables = new HashSet<InferenceVariable>();
        for (ConstraintFormula constraint : additionalConstraints) {
            Set<InferenceVariable> inputVariables;
            Set<InferenceVariable> outputVars;
            if (!(constraint instanceof InputOutputConstraintFormula) || (outputVars = ((InputOutputConstraintFormula)constraint).getOutputVariables(inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this), this)) == null) continue;
            outputVariables.addAll(outputVars);
        }
        LinkedHashSet<ConstraintFormula> noInputVariables = new LinkedHashSet<ConstraintFormula>();
        for (ConstraintFormula constraint : additionalConstraints) {
            if (constraint instanceof InputOutputConstraintFormula) {
                Set<InferenceVariable> inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this);
                if (inputVariables != null) {
                    boolean dependsOnOutput = false;
                    for (InferenceVariable inputVariable : inputVariables) {
                        if (dependsOnOutput) break;
                        if (inputVariable.hasInstantiation(this)) continue;
                        Set<InferenceVariable> dependencies = inputVariable.getDependencies(this);
                        dependencies.add(inputVariable);
                        if (!this.hasCapture(inputVariable)) {
                            for (InferenceVariable outputVariable : outputVariables) {
                                if (!ContainerUtil.intersects(outputVariable.getDependencies(this), dependencies)) continue;
                                dependsOnOutput = true;
                                break;
                            }
                        }
                        dependencies.retainAll(outputVariables);
                        if (dependencies.isEmpty()) continue;
                        dependsOnOutput = true;
                        break;
                    }
                    if (dependsOnOutput) continue;
                    subset.add(constraint);
                    if (!inputVariables.isEmpty()) continue;
                    noInputVariables.add(constraint);
                    continue;
                }
                subset.add(constraint);
                noInputVariables.add(constraint);
                continue;
            }
            subset.add(constraint);
        }
        if (subset.isEmpty()) {
            subset.add(additionalConstraints.iterator().next());
        }
        if (!noInputVariables.isEmpty()) {
            subset = noInputVariables;
        }
        additionalConstraints.removeAll(subset);
        return subset;
    }

    public PsiSubstitutor collectApplicabilityConstraints(PsiMethodReferenceExpression reference, MethodCandidateInfo candidateInfo, PsiType functionalInterfaceType) {
        block11: {
            PsiSubstitutor psiSubstitutor;
            boolean isStatic;
            PsiParameter[] parameters;
            PsiClass containingClass;
            PsiClass methodContainingClass;
            PsiMethod method;
            boolean varargs;
            MethodSignature signature;
            block10: {
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
                LOG.assertTrue(interfaceMethod != null, this.myContext);
                PsiSubstitutor functionalInterfaceSubstitutor = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
                signature = interfaceMethod.getSignature(functionalInterfaceSubstitutor);
                varargs = candidateInfo.isVarargs();
                method = candidateInfo.getElement();
                methodContainingClass = method.getContainingClass();
                PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(reference);
                containingClass = qualifierResolveResult.getContainingClass();
                if (containingClass == null) {
                    return this.resolveSubset(this.myInferenceVariables, this.mySiteSubstitutor);
                }
                PsiParameter[] functionalMethodParameters = interfaceMethod.getParameterList().getParameters();
                parameters = method.getParameterList().getParameters();
                isStatic = method.hasModifierProperty("static");
                psiSubstitutor = qualifierResolveResult.getSubstitutor();
                if ((parameters.length != functionalMethodParameters.length || varargs) && (!isStatic || !varargs)) break block10;
                if (method.isConstructor() && PsiUtil.isRawSubstitutor(containingClass, psiSubstitutor)) {
                    this.initBounds(containingClass.getTypeParameters());
                    psiSubstitutor = PsiSubstitutor.EMPTY;
                }
                if (methodContainingClass != null) {
                    LOG.assertTrue((psiSubstitutor = TypeConversionUtil.getClassSubstitutor(methodContainingClass, containingClass, psiSubstitutor)) != null, "derived: " + containingClass + "; super: " + methodContainingClass);
                }
                for (int i = 0; i < functionalMethodParameters.length; ++i) {
                    PsiType pType = signature.getParameterTypes()[i];
                    this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters, i, psiSubstitutor, varargs)), PsiImplUtil.normalizeWildcardTypeByPosition(pType, reference)));
                }
                break block11;
            }
            if (!PsiMethodReferenceUtil.isResolvedBySecondSearch(reference, signature, varargs, isStatic, parameters.length)) break block11;
            PsiType pType = signature.getParameterTypes()[0];
            if (PsiUtil.isRawSubstitutor(containingClass, psiSubstitutor)) {
                PsiType normalizedPType = PsiImplUtil.normalizeWildcardTypeByPosition(pType, (PsiExpression)this.myContext);
                PsiSubstitutor receiverSubstitutor = PsiMethodReferenceCompatibilityConstraint.getParameterizedTypeSubstitutor(containingClass, normalizedPType);
                if (receiverSubstitutor != null) {
                    if (!method.hasTypeParameters() && (signature.getParameterTypes().length == 1 || PsiUtil.isRawSubstitutor(containingClass, receiverSubstitutor))) {
                        return receiverSubstitutor;
                    }
                    this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(receiverSubstitutor);
                    psiSubstitutor = receiverSubstitutor;
                }
            } else if (methodContainingClass != null) {
                LOG.assertTrue((psiSubstitutor = TypeConversionUtil.getClassSubstitutor(methodContainingClass, containingClass, psiSubstitutor)) != null, "derived: " + containingClass + "; super: " + methodContainingClass);
            }
            PsiClassType qType = JavaPsiFacade.getElementFactory(method.getProject()).createType(containingClass, psiSubstitutor);
            this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(qType), pType));
            for (int i = 0; i < signature.getParameterTypes().length - 1; ++i) {
                PsiType interfaceParamType = signature.getParameterTypes()[i + 1];
                this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters, i, psiSubstitutor, varargs)), PsiImplUtil.normalizeWildcardTypeByPosition(interfaceParamType, reference)));
            }
        }
        return null;
    }

    public void setErased() {
        this.myErased = true;
    }

    public InferenceVariable getInferenceVariable(PsiTypeParameter parameter) {
        return parameter instanceof InferenceVariable && this.myInferenceVariables.contains(parameter) ? (InferenceVariable)parameter : null;
    }

    public static boolean isMoreSpecific(PsiMethod m1, PsiMethod m2, PsiSubstitutor siteSubstitutor1, PsiExpression[] args, PsiElement context, boolean varargs) {
        ArrayList<PsiTypeParameter> params = new ArrayList<PsiTypeParameter>();
        for (PsiTypeParameter param : PsiUtil.typeParametersIterable(m2)) {
            params.add(param);
        }
        siteSubstitutor1 = InferenceSession.getSiteSubstitutor(siteSubstitutor1, params);
        InferenceSession session = new InferenceSession(params.toArray(new PsiTypeParameter[params.size()]), siteSubstitutor1, m2.getManager(), context);
        PsiParameter[] parameters1 = m1.getParameterList().getParameters();
        PsiParameter[] parameters2 = m2.getParameterList().getParameters();
        if (!varargs) {
            LOG.assertTrue(parameters1.length == parameters2.length);
        }
        int paramsLength = !varargs ? parameters1.length : Math.max(parameters1.length, parameters2.length) - 1;
        for (int i = 0; i < paramsLength; ++i) {
            PsiType sType = InferenceSession.getParameterType(parameters1, i, siteSubstitutor1, false);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i, siteSubstitutor1, varargs));
            if (sType instanceof PsiClassType && tType instanceof PsiClassType && LambdaUtil.isFunctionalType(sType) && LambdaUtil.isFunctionalType(tType) && !InferenceSession.relates(sType, tType)) {
                if (InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, session, args[i])) continue;
                return false;
            }
            if (session.isProperType(tType) && !TypeConversionUtil.isAssignable(tType, sType)) {
                return false;
            }
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        if (varargs) {
            PsiType sType = InferenceSession.getParameterType(parameters1, paramsLength, siteSubstitutor1, true);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, paramsLength, siteSubstitutor1, true));
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        return session.repeatInferencePhases(true);
    }

    private static PsiSubstitutor getSiteSubstitutor(PsiSubstitutor siteSubstitutor1, List<PsiTypeParameter> params) {
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter param : params) {
            subst = subst.put(param, siteSubstitutor1.substitute(param));
        }
        return subst;
    }

    public static boolean isFunctionalTypeMoreSpecificOnExpression(PsiType sType, PsiType tType, PsiExpression arg) {
        return InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, null, arg);
    }

    private static boolean isFunctionalTypeMoreSpecific(PsiType sType, PsiType tType, @Nullable InferenceSession session, PsiExpression ... args) {
        PsiType capturedSType = sType;
        PsiClassType.ClassResolveResult sResult = PsiUtil.resolveGenericsClassInType(capturedSType);
        PsiMethod sInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(sResult);
        LOG.assertTrue(sInterfaceMethod != null);
        PsiSubstitutor sSubstitutor = LambdaUtil.getSubstitutor(sInterfaceMethod, sResult);
        PsiClassType.ClassResolveResult tResult = PsiUtil.resolveGenericsClassInType(tType);
        PsiMethod tInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(tResult);
        LOG.assertTrue(tInterfaceMethod != null);
        PsiSubstitutor tSubstitutor = LambdaUtil.getSubstitutor(tInterfaceMethod, tResult);
        for (PsiExpression arg : args) {
            if (InferenceSession.argConstraints(arg, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor)) continue;
            return false;
        }
        return true;
    }

    protected static boolean argConstraints(PsiExpression arg, @Nullable InferenceSession session, PsiMethod sInterfaceMethod, PsiSubstitutor sSubstitutor, PsiMethod tInterfaceMethod, PsiSubstitutor tSubstitutor) {
        if (arg instanceof PsiLambdaExpression && ((PsiLambdaExpression)arg).hasFormalParameterTypes()) {
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (PsiType.VOID.equals(tReturnType)) {
                return true;
            }
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)arg);
            if (sReturnType instanceof PsiClassType && tReturnType instanceof PsiClassType && LambdaUtil.isFunctionalType(sReturnType) && LambdaUtil.isFunctionalType(tReturnType) && !TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(sReturnType), TypeConversionUtil.erasure(tReturnType)) && !TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(tReturnType), TypeConversionUtil.erasure(sReturnType))) {
                if (!InferenceSession.isFunctionalTypeMoreSpecific(sReturnType, tReturnType, session, returnExpressions.toArray(new PsiExpression[returnExpressions.size()]))) {
                    return false;
                }
            } else {
                boolean tPrimitive;
                boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(sReturnType);
                boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(tReturnType);
                if (sPrimitive ^ tPrimitive) {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (!PsiPolyExpressionUtil.isPolyExpression(returnExpression)) {
                            PsiType returnExpressionType = returnExpression.getType();
                            if (!(sPrimitive ? !(returnExpressionType instanceof PsiPrimitiveType) : !(returnExpressionType instanceof PsiClassType))) continue;
                            return false;
                        }
                        if (!sPrimitive) continue;
                        return false;
                    }
                    return true;
                }
                if (session != null) {
                    session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                    return true;
                }
                return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable(tReturnType, sReturnType);
            }
        }
        if (arg instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)arg).isExact()) {
            boolean tPrimitive;
            PsiParameter[] tParameters;
            PsiParameter[] sParameters = sInterfaceMethod.getParameterList().getParameters();
            LOG.assertTrue(sParameters.length == (tParameters = tInterfaceMethod.getParameterList().getParameters()).length, "s: " + sInterfaceMethod.getParameterList().getText() + "; t: " + tInterfaceMethod.getParameterList().getText());
            for (int i = 0; i < tParameters.length; ++i) {
                PsiType tSubstituted = tSubstitutor.substitute(tParameters[i].getType());
                PsiType sSubstituted = sSubstitutor.substitute(sParameters[i].getType());
                if (session != null) {
                    session.addConstraint(new TypeEqualityConstraint(tSubstituted, sSubstituted));
                    continue;
                }
                if (Comparing.equal(tSubstituted, sSubstituted)) continue;
                return false;
            }
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (PsiType.VOID.equals(tReturnType)) {
                return true;
            }
            boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(sReturnType);
            boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(tReturnType);
            if (sPrimitive ^ tPrimitive) {
                PsiMember member = ((PsiMethodReferenceExpression)arg).getPotentiallyApplicableMember();
                LOG.assertTrue(member != null, arg);
                if (member instanceof PsiMethod) {
                    PsiType methodReturnType = ((PsiMethod)member).getReturnType();
                    if (sPrimitive && methodReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(methodReturnType) || tPrimitive && methodReturnType instanceof PsiClassType) {
                        return true;
                    }
                }
                return false;
            }
            if (session != null) {
                session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                return true;
            }
            return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable(tReturnType, sReturnType);
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return InferenceSession.argConstraints(((PsiParenthesizedExpression)arg).getExpression(), session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        if (arg instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)arg).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)arg).getElseExpression();
            return InferenceSession.argConstraints(thenExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor) && InferenceSession.argConstraints(elseExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        return false;
    }

    private static boolean relates(PsiType sType, PsiType tType) {
        PsiType sTypeErasure;
        PsiType erasedType = TypeConversionUtil.erasure(tType);
        LOG.assertTrue(erasedType != null);
        if (sType instanceof PsiIntersectionType) {
            boolean superRelation = true;
            boolean subRelation = false;
            for (PsiType sConjunct : ((PsiIntersectionType)sType).getConjuncts()) {
                PsiType sConjunctErasure = TypeConversionUtil.erasure(sConjunct);
                if (sConjunctErasure == null) continue;
                superRelation &= TypeConversionUtil.isAssignable(sConjunctErasure, erasedType);
                subRelation |= TypeConversionUtil.isAssignable(erasedType, sConjunctErasure);
            }
            return superRelation || subRelation;
        }
        if (sType instanceof PsiClassType && (sTypeErasure = TypeConversionUtil.erasure(sType)) != null) {
            return TypeConversionUtil.isAssignable(sTypeErasure, erasedType) || TypeConversionUtil.isAssignable(erasedType, sTypeErasure);
        }
        return false;
    }

    public void collectCaptureDependencies(InferenceVariable inferenceVariable, Set<InferenceVariable> dependencies) {
        this.myIncorporationPhase.collectCaptureDependencies(inferenceVariable, dependencies);
    }

    public boolean hasCapture(InferenceVariable inferenceVariable) {
        return this.myIncorporationPhase.hasCaptureConstraints(Collections.singletonList(inferenceVariable));
    }

    public static boolean wasUncheckedConversionPerformed(PsiElement call) {
        Boolean erased = call.getUserData(ERASED);
        return erased != null && erased != false;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public void propagateVariables(Collection<InferenceVariable> variables) {
        this.myInferenceVariables.addAll(variables);
    }

    public PsiType substituteWithInferenceVariables(PsiType type) {
        return this.myInferenceSubstitution.substitute(type);
    }

    public InferenceSession findNestedCallSession(PsiExpression arg) {
        InferenceSession session = this.myNestedSessions.get(PsiTreeUtil.getParentOfType((PsiElement)arg, PsiCall.class));
        if (session == null) {
            session = this;
        }
        return session;
    }

    public PsiType startWithFreshVars(PsiType type) {
        PsiSubstitutor s = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : this.myInferenceVariables) {
            s = s.put(variable, JavaPsiFacade.getElementFactory(variable.getProject()).createType(variable.getParameter()));
        }
        return s.substitute(type);
    }

    public static boolean areSameFreshVariables(PsiTypeParameter p1, PsiTypeParameter p2) {
        PsiElement originalContext = p1.getUserData(ORIGINAL_CONTEXT);
        return originalContext != null && originalContext == p2.getUserData(ORIGINAL_CONTEXT);
    }

    public static boolean isFreshVariable(PsiTypeParameter typeParameter) {
        return typeParameter.getUserData(ORIGINAL_CONTEXT) != null;
    }

    public static PsiClass findParameterizationOfTheSameGenericClass(List<PsiType> upperBounds, Processor<Pair<PsiType, PsiType>> processor) {
        for (int i = 0; i < upperBounds.size(); ++i) {
            PsiType sBound = upperBounds.get(i);
            PsiClass sClass = PsiUtil.resolveClassInClassTypeOnly(sBound);
            if (sClass == null) continue;
            LinkedHashSet<PsiClass> superClasses = InheritanceUtil.getSuperClasses(sClass);
            superClasses.add(sClass);
            for (int j = i + 1; j < upperBounds.size(); ++j) {
                PsiType tBound = upperBounds.get(j);
                PsiClass tClass = PsiUtil.resolveClassInClassTypeOnly(tBound);
                if (tClass == null) continue;
                LinkedHashSet<PsiClass> tSupers = InheritanceUtil.getSuperClasses(tClass);
                tSupers.add(tClass);
                tSupers.retainAll(superClasses);
                for (PsiClass gClass : tSupers) {
                    PsiSubstitutor sSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(gClass, (PsiClassType)sBound);
                    PsiSubstitutor tSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(gClass, (PsiClassType)tBound);
                    for (PsiTypeParameter typeParameter : gClass.getTypeParameters()) {
                        PsiType tType;
                        PsiType sType = sSubstitutor.substitute(typeParameter);
                        Pair<PsiType, PsiType> typePair = Pair.create(sType, tType = tSubstitutor.substitute(typeParameter));
                        if (processor.process(typePair)) continue;
                        return gClass;
                    }
                }
            }
        }
        return null;
    }

    public void registerSiteSubstitutor(PsiSubstitutor substitutor) {
        this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(substitutor);
    }
}

