/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class XmlValueReference
implements PsiReference {
    protected final XmlTag myTag;
    protected TextRange myRange;

    protected XmlValueReference(XmlTag tag) {
        this.myTag = tag;
        this.myRange = ElementManipulators.getValueTextRange(tag);
    }

    @Override
    public PsiElement getElement() {
        return this.myTag;
    }

    @Override
    public TextRange getRangeInElement() {
        return this.myRange;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.myRange.substring(this.myTag.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/XmlValueReference", "getCanonicalText"));
        }
        return string;
    }

    protected void replaceContent(String str) throws IncorrectOperationException {
        ElementManipulator<XmlTag> manipulator = ElementManipulators.getManipulator(this.myTag);
        manipulator.handleContentChange(this.myTag, this.myRange, str);
        this.myRange = manipulator.getRangeInElement(this.myTag);
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return this.myTag.getManager().areElementsEquivalent(element, this.resolve());
    }

    @Override
    public boolean isSoft() {
        return false;
    }
}

